/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class RoutingTableIncrementalDiff
implements Diff<RoutingTable> {
    private final Map<String, Diff<IndexRoutingTable>> diffs;

    public RoutingTableIncrementalDiff(Map<String, Diff<IndexRoutingTable>> diffs) {
        this.diffs = diffs;
    }

    public Map<String, Diff<IndexRoutingTable>> getDiffs() {
        return this.diffs;
    }

    public static RoutingTableIncrementalDiff readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<String, Diff<IndexRoutingTable>> diffs = new HashMap<String, Diff<IndexRoutingTable>>();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            IndexRoutingTableIncrementalDiff diff = IndexRoutingTableIncrementalDiff.readFrom(in);
            diffs.put(key, diff);
        }
        return new RoutingTableIncrementalDiff(diffs);
    }

    @Override
    public RoutingTable apply(RoutingTable part) {
        RoutingTable.Builder builder = new RoutingTable.Builder();
        for (IndexRoutingTable indexRoutingTable : part) {
            builder.add(indexRoutingTable);
        }
        for (Map.Entry entry : this.diffs.entrySet()) {
            builder.add(((Diff)entry.getValue()).apply(part.index((String)entry.getKey())));
        }
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.diffs.size());
        for (Map.Entry<String, Diff<IndexRoutingTable>> entry : this.diffs.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    public static class IndexRoutingTableIncrementalDiff
    implements Diff<IndexRoutingTable> {
        private final List<IndexShardRoutingTable> indexShardRoutingTables;

        public IndexRoutingTableIncrementalDiff(List<IndexShardRoutingTable> indexShardRoutingTables) {
            this.indexShardRoutingTables = indexShardRoutingTables;
        }

        @Override
        public IndexRoutingTable apply(IndexRoutingTable part) {
            IndexRoutingTable.Builder builder = new IndexRoutingTable.Builder(part.getIndex());
            for (IndexShardRoutingTable shardRoutingTable : part) {
                builder.addIndexShard(shardRoutingTable);
            }
            for (IndexShardRoutingTable diffShard : this.indexShardRoutingTables) {
                builder.addIndexShard(diffShard);
            }
            return builder.build();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.indexShardRoutingTables.size());
            for (IndexShardRoutingTable shardRoutingTable : this.indexShardRoutingTables) {
                IndexShardRoutingTable.Builder.writeTo(shardRoutingTable, out);
            }
        }

        public static IndexRoutingTableIncrementalDiff readFrom(StreamInput in) throws IOException {
            int size = in.readVInt();
            ArrayList<IndexShardRoutingTable> indexShardRoutingTables = new ArrayList<IndexShardRoutingTable>(size);
            for (int i = 0; i < size; ++i) {
                IndexShardRoutingTable shardRoutingTable = IndexShardRoutingTable.Builder.readFrom(in);
                indexShardRoutingTables.add(shardRoutingTable);
            }
            return new IndexRoutingTableIncrementalDiff(indexShardRoutingTables);
        }
    }
}

