/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.PitSearchContextIdForNode;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.TransportCreatePitAction;
import org.opensearch.action.search.UpdatePitContextRequest;
import org.opensearch.action.search.UpdatePitContextResponse;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchService;
import org.opensearch.search.dfs.DfsSearchResult;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.QueryFetchSearchResult;
import org.opensearch.search.fetch.ScrollQueryFetchSearchResult;
import org.opensearch.search.fetch.ShardFetchRequest;
import org.opensearch.search.fetch.ShardFetchSearchRequest;
import org.opensearch.search.internal.InternalScrollSearchRequest;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.query.QuerySearchRequest;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ScrollQuerySearchResult;
import org.opensearch.tasks.Task;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportActionProxy;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public class SearchTransportService {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String FREE_PIT_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context/pit]";
    public static final String FREE_ALL_PIT_CONTEXTS_ACTION_NAME = "indices:data/read/search[free_pit_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String QUERY_CAN_MATCH_NAME = "indices:data/read/search[can_match]";
    public static final String CREATE_READER_CONTEXT_ACTION_NAME = "indices:data/read/search[create_context]";
    public static final String UPDATE_READER_CONTEXT_ACTION_NAME = "indices:data/read/search[update_context]";
    private final TransportService transportService;
    private final BiFunction<Transport.Connection, SearchActionListener, ActionListener> responseWrapper;
    private final Map<String, Long> clientConnections = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public SearchTransportService(TransportService transportService, BiFunction<Transport.Connection, SearchActionListener, ActionListener> responseWrapper) {
        this.transportService = transportService;
        this.responseWrapper = responseWrapper;
    }

    public void sendFreeContext(Transport.Connection connection, ShardSearchContextId contextId, OriginalIndices originalIndices) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(originalIndices, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(new ActionListener<SearchFreeContextResponse>(){

            public void onResponse(SearchFreeContextResponse response) {
            }

            public void onFailure(Exception e) {
            }
        }, SearchFreeContextResponse::new));
    }

    public void sendFreeContext(Transport.Connection connection, ShardSearchContextId contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_SCROLL_ACTION_NAME, (TransportRequest)new ScrollFreeContextRequest(contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new));
    }

    public void updatePitContext(Transport.Connection connection, UpdatePitContextRequest request, ActionListener<UpdatePitContextResponse> actionListener) {
        this.transportService.sendRequest(connection, UPDATE_READER_CONTEXT_ACTION_NAME, (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<UpdatePitContextResponse>(actionListener, UpdatePitContextResponse::new));
    }

    public void createPitContext(Transport.Connection connection, TransportCreatePitAction.CreateReaderContextRequest request, SearchTask task, ActionListener<TransportCreatePitAction.CreateReaderContextResponse> actionListener) {
        this.transportService.sendChildRequest(connection, CREATE_READER_CONTEXT_ACTION_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportCreatePitAction.CreateReaderContextResponse>(actionListener, TransportCreatePitAction.CreateReaderContextResponse::new));
    }

    public void sendCanMatch(Transport.Connection connection, ShardSearchRequest request, SearchTask task, ActionListener<SearchService.CanMatchResponse> listener) {
        this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchService.CanMatchResponse>(listener, SearchService.CanMatchResponse::new));
    }

    public void sendClearAllScrollContexts(Transport.Connection connection, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(connection, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse>(listener, in -> TransportResponse.Empty.INSTANCE));
    }

    public void sendFreePITContexts(Transport.Connection connection, List<PitSearchContextIdForNode> contextIds, ActionListener<DeletePitResponse> listener) {
        this.transportService.sendRequest(connection, FREE_PIT_CONTEXT_ACTION_NAME, (TransportRequest)new PitFreeContextsRequest(contextIds), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<DeletePitResponse>(listener, DeletePitResponse::new));
    }

    public void sendExecuteDfs(Transport.Connection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ConnectionCountingHandler<DfsSearchResult>(listener, DfsSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(Transport.Connection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<SearchPhaseResult> listener) {
        boolean fetchDocuments = request.numberOfShards() == 1;
        Writeable.Reader reader = fetchDocuments ? QueryFetchSearchResult::new : QuerySearchResult::new;
        ActionListener handler = this.responseWrapper.apply(connection, listener);
        this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ConnectionCountingHandler(handler, reader, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(Transport.Connection connection, QuerySearchRequest request, SearchTask task, SearchActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ConnectionCountingHandler<QuerySearchResult>(listener, QuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollQuery(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQuerySearchResult>(listener, ScrollQuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollFetch(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQueryFetchSearchResult>(listener, ScrollQueryFetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteFetch(Transport.Connection connection, ShardFetchSearchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(Transport.Connection connection, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(Transport.Connection connection, String action, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ConnectionCountingHandler<FetchSearchResult>(listener, FetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    void sendExecuteMultiSearch(MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        Transport.Connection connection = this.transportService.getConnection(this.transportService.getLocalNode());
        this.transportService.sendChildRequest(connection, "indices:data/read/msearch", request, task, new ConnectionCountingHandler<MultiSearchResponse>(listener, MultiSearchResponse::new, this.clientConnections, connection.getNode().getId()));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.transportService.getRemoteClusterService();
    }

    public Map<String, Long> getPendingSearchRequests() {
        return new HashMap<String, Long>(this.clientConnections);
    }

    static boolean keepStatesInContext(Version version) {
        return version.before((Version)LegacyESVersion.V_7_10_0);
    }

    public static void registerRequestHandler(TransportService transportService, SearchService searchService) {
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, "same", ScrollFreeContextRequest::new, (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)SearchFreeContextResponse::new));
        transportService.registerRequestHandler(FREE_PIT_CONTEXT_ACTION_NAME, "same", PitFreeContextsRequest::new, (request, channel, task) -> channel.sendResponse((TransportResponse)searchService.freeReaderContextsIfFound(request.getContextIds())));
        TransportActionProxy.registerProxyAction(transportService, FREE_PIT_CONTEXT_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)DeletePitResponse::new));
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, "same", SearchFreeContextRequest::new, (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)SearchFreeContextResponse::new));
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, "same", TransportRequest.Empty::new, (request, channel, task) -> {
            searchService.freeAllScrollContexts();
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        });
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)in -> TransportResponse.Empty.INSTANCE));
        transportService.registerRequestHandler(DFS_ACTION_NAME, "same", false, true, AdmissionControlActionType.SEARCH, ShardSearchRequest::new, (request, channel, task) -> searchService.executeDfsPhase((ShardSearchRequest)request, SearchTransportService.keepStatesInContext(channel.getVersion()), (SearchShardTask)task, new ChannelActionListener(channel, DFS_ACTION_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)DfsSearchResult::new));
        transportService.registerRequestHandler(QUERY_ACTION_NAME, "same", false, true, AdmissionControlActionType.SEARCH, ShardSearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((ShardSearchRequest)request, SearchTransportService.keepStatesInContext(channel.getVersion()), (SearchShardTask)task, new ChannelActionListener(channel, QUERY_ACTION_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyActionWithDynamicResponseType(transportService, QUERY_ACTION_NAME, request -> ((ShardSearchRequest)request).numberOfShards() == 1 ? QueryFetchSearchResult::new : QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, "same", false, true, AdmissionControlActionType.SEARCH, QuerySearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((QuerySearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_ID_ACTION_NAME, (QuerySearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)QuerySearchResult::new));
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, "same", InternalScrollSearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_SCROLL_ACTION_NAME, (InternalScrollSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)ScrollQuerySearchResult::new));
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, "same", InternalScrollSearchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_FETCH_SCROLL_ACTION_NAME, (InternalScrollSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)ScrollQueryFetchSearchResult::new));
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, "same", ShardFetchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, FETCH_ID_SCROLL_ACTION_NAME, (ShardFetchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)FetchSearchResult::new));
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, "same", true, true, AdmissionControlActionType.SEARCH, ShardFetchSearchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, FETCH_ID_ACTION_NAME, (ShardFetchSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)FetchSearchResult::new));
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.canMatch((ShardSearchRequest)request, new ChannelActionListener(channel, QUERY_CAN_MATCH_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)SearchService.CanMatchResponse::new));
        transportService.registerRequestHandler(CREATE_READER_CONTEXT_ACTION_NAME, "same", TransportCreatePitAction.CreateReaderContextRequest::new, (request, channel, task) -> {
            ChannelActionListener listener = new ChannelActionListener(channel, CREATE_READER_CONTEXT_ACTION_NAME, (TransportCreatePitAction.CreateReaderContextRequest)request);
            searchService.createPitReaderContext(request.getShardId(), request.getKeepAlive(), (ActionListener<ShardSearchContextId>)ActionListener.wrap(r -> listener.onResponse(new TransportCreatePitAction.CreateReaderContextResponse((ShardSearchContextId)r)), listener::onFailure));
        });
        TransportActionProxy.registerProxyAction(transportService, CREATE_READER_CONTEXT_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)TransportCreatePitAction.CreateReaderContextResponse::new));
        transportService.registerRequestHandler(UPDATE_READER_CONTEXT_ACTION_NAME, "same", UpdatePitContextRequest::new, (request, channel, task) -> {
            ChannelActionListener listener = new ChannelActionListener(channel, UPDATE_READER_CONTEXT_ACTION_NAME, (UpdatePitContextRequest)request);
            searchService.updatePitIdAndKeepAlive((UpdatePitContextRequest)request, listener);
        });
        TransportActionProxy.registerProxyAction(transportService, UPDATE_READER_CONTEXT_ACTION_NAME, (Writeable.Reader<? extends TransportResponse>)((Writeable.Reader)UpdatePitContextResponse::new));
    }

    public Transport.Connection getConnection(@Nullable String clusterAlias, DiscoveryNode node) {
        if (clusterAlias == null) {
            return this.transportService.getConnection(node);
        }
        return this.transportService.getRemoteClusterService().getConnection(node, clusterAlias);
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest(OriginalIndices originalIndices, ShardSearchContextId id) {
            super(id);
            this.originalIndices = originalIndices;
        }

        SearchFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private ShardSearchContextId contextId;

        ScrollFreeContextRequest(ShardSearchContextId contextId) {
            this.contextId = Objects.requireNonNull(contextId);
        }

        ScrollFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.contextId.writeTo(out);
        }

        public ShardSearchContextId id() {
            return this.contextId;
        }
    }

    static class PitFreeContextsRequest
    extends TransportRequest {
        private List<PitSearchContextIdForNode> contextIds;

        PitFreeContextsRequest(List<PitSearchContextIdForNode> contextIds) {
            this.contextIds = new ArrayList<PitSearchContextIdForNode>();
            this.contextIds.addAll(contextIds);
        }

        PitFreeContextsRequest(StreamInput in) throws IOException {
            super(in);
            int size = in.readVInt();
            if (size > 0) {
                this.contextIds = new ArrayList<PitSearchContextIdForNode>();
                for (int i = 0; i < size; ++i) {
                    PitSearchContextIdForNode contextId = new PitSearchContextIdForNode(in);
                    this.contextIds.add(contextId);
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.contextIds.size());
            for (PitSearchContextIdForNode contextId : this.contextIds) {
                contextId.writeTo(out);
            }
        }

        public List<PitSearchContextIdForNode> getContextIds() {
            return this.contextIds;
        }
    }

    final class ConnectionCountingHandler<Response extends TransportResponse>
    extends ActionListenerResponseHandler<Response> {
        private final Map<String, Long> clientConnections;
        private final String nodeId;

        ConnectionCountingHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> responseReader, Map<String, Long> clientConnections, String nodeId) {
            super(listener, responseReader);
            this.clientConnections = clientConnections;
            this.nodeId = nodeId;
            clientConnections.compute(nodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }

        @Override
        public void handleResponse(Response response) {
            super.handleResponse(response);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        @Override
        public void handleException(TransportException e) {
            super.handleException(e);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        private boolean assertNodePresent() {
            this.clientConnections.compute(this.nodeId, (id, conns) -> {
                assert (conns != null) : "number of connections for " + id + " is null, but should be an integer";
                assert (conns >= 1L) : "number of connections for " + id + " should be >= 1 but was " + conns;
                return conns;
            });
            return true;
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse(StreamInput in) throws IOException {
            this.freed = in.readBoolean();
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.freed);
        }
    }
}

