/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class PutIndexTemplateRequest
extends ClusterManagerNodeRequest<PutIndexTemplateRequest>
implements IndicesRequest,
ToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(PutIndexTemplateRequest.class);
    private String name;
    private String cause = "";
    private List<String> indexPatterns;
    private int order;
    private boolean create;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    @Nullable
    private String mappings;
    private final Set<Alias> aliases = new HashSet<Alias>();
    private Integer version;

    public PutIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        int i;
        this.cause = in.readString();
        this.name = in.readString();
        this.indexPatterns = in.readStringList();
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        if (in.getVersion().before(Version.V_2_0_0)) {
            int size = in.readVInt();
            for (i = 0; i < size; ++i) {
                in.readString();
                this.mappings = in.readString();
            }
        } else {
            this.mappings = in.readOptionalString();
        }
        int aliasesSize = in.readVInt();
        for (i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        this.version = in.readOptionalVInt();
    }

    public PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.indexPatterns == null || this.indexPatterns.size() == 0) {
            validationException = ValidateActions.addValidationError("index patterns are missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest patterns(List<String> indexPatterns) {
        this.indexPatterns = indexPatterns;
        return this;
    }

    public List<String> patterns() {
        return this.indexPatterns;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source, MediaType mediaType) {
        this.settings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String source, MediaType mediaType) {
        return this.mapping((BytesReference)new BytesArray(source), mediaType);
    }

    public PutIndexTemplateRequest mapping(XContentBuilder source) {
        return this.mapping(BytesReference.bytes((XContentBuilder)source), source.contentType());
    }

    public PutIndexTemplateRequest mapping(BytesReference source, MediaType mediaType) {
        Objects.requireNonNull(mediaType);
        Map mappingAsMap = (Map)XContentHelper.convertToMap(source, false, mediaType).v2();
        return this.mapping(mappingAsMap);
    }

    public PutIndexTemplateRequest mapping(Map<String, Object> source) {
        if (source.size() != 1 || !source.containsKey("_doc")) {
            source = Map.of("_doc", source);
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            this.mappings = builder.toString();
            return this;
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public PutIndexTemplateRequest mapping(String ... source) {
        this.mapping(PutMappingRequest.simpleMapping(source));
        return this;
    }

    public String mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(BytesReference.bytes((XContentBuilder)templateBuilder), templateBuilder.contentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map<String, Object> templateSource) {
        Map<String, Object> source = templateSource;
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("template")) {
                if (!(entry.getValue() instanceof String)) continue;
                deprecationLogger.deprecate("put_index_template_field", "Deprecated field [template] used, replaced by [index_patterns]", new Object[0]);
                this.patterns(Collections.singletonList((String)entry.getValue()));
                continue;
            }
            if (name.equals("index_patterns")) {
                if (entry.getValue() instanceof String) {
                    this.patterns(Collections.singletonList((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List<String> elements = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.toList());
                    this.patterns(elements);
                    continue;
                }
                throw new IllegalArgumentException("Malformed [template] value, should be a string or a list of strings");
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry.getValue(), this.order()));
                continue;
            }
            if ("version".equals(name)) {
                if (!(entry.getValue() instanceof Integer)) {
                    throw new IllegalArgumentException("Malformed [version] value, should be an integer");
                }
                this.version((Integer)entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed [settings] section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    if (!(entry1.getValue() instanceof Map)) {
                        throw new IllegalArgumentException("Malformed [mappings] section for type [" + (String)entry1.getKey() + "], should include an inner object describing the mapping");
                    }
                    this.mapping((Map)entry1.getValue());
                }
                continue;
            }
            if (name.equals("aliases")) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new OpenSearchParseException("unknown key [{}] in the template ", new Object[]{name});
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(xContentType.xContent(), templateSource, true));
    }

    public PutIndexTemplateRequest source(byte[] source, MediaType mediaType) {
        return this.source(source, 0, source.length, mediaType);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length, MediaType mediaType) {
        return this.source((BytesReference)new BytesArray(source, offset, length), mediaType);
    }

    public PutIndexTemplateRequest source(BytesReference source, MediaType mediaType) {
        return this.source((Map)XContentHelper.convertToMap(source, true, mediaType).v2());
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public PutIndexTemplateRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes((XContentBuilder)builder));
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public PutIndexTemplateRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes((XContentBuilder)source));
    }

    public PutIndexTemplateRequest aliases(String source) {
        return this.aliases((BytesReference)new BytesArray(source));
    }

    public PutIndexTemplateRequest aliases(BytesReference source) {
        PutIndexTemplateRequest putIndexTemplateRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                putIndexTemplateRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return putIndexTemplateRequest;
    }

    public PutIndexTemplateRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indexPatterns.toArray(new String[this.indexPatterns.size()]);
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpand();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.name);
        out.writeStringCollection(this.indexPatterns);
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        Settings.writeSettingsToStream(this.settings, out);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeVInt(this.mappings == null ? 0 : 1);
            if (this.mappings != null) {
                out.writeString("_doc");
                out.writeString(this.mappings);
            }
        } else {
            out.writeOptionalString(this.mappings);
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        out.writeOptionalVInt(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index_patterns", this.indexPatterns);
        builder.field("order", this.order);
        if (this.version != null) {
            builder.field("version", this.version);
        }
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.startObject("mappings");
        if (this.mappings != null) {
            builder.field("_doc");
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, this.mappings);){
                builder.copyCurrentStructure(parser);
            }
        }
        builder.endObject();
        builder.startObject("aliases");
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

