/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.exporter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.plugin.insights.core.exporter.DebugExporter;
import org.opensearch.plugin.insights.core.exporter.LocalIndexExporter;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporter;
import org.opensearch.plugin.insights.core.exporter.SinkType;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;

public class QueryInsightsExporterFactory {
    private final Logger logger = LogManager.getLogger();
    private final Client client;
    private final Set<QueryInsightsExporter> exporters;

    public QueryInsightsExporterFactory(Client client) {
        this.client = client;
        this.exporters = new HashSet<QueryInsightsExporter>();
    }

    public void validateExporterConfig(Settings settings) throws IllegalArgumentException {
        SinkType type;
        if (settings.get("type") == null) {
            return;
        }
        try {
            type = SinkType.parse(settings.get("type", QueryInsightsSettings.DEFAULT_TOP_QUERIES_EXPORTER_TYPE));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid exporter type [%s], type should be one of %s", settings.get("type"), SinkType.allSinkTypes()));
        }
        switch (type) {
            case LOCAL_INDEX: {
                String indexPattern = settings.get("config.index", "'top_queries-'YYYY.MM.dd");
                if (indexPattern.length() == 0) {
                    throw new IllegalArgumentException("Empty index pattern configured for the exporter");
                }
                try {
                    DateTimeFormat.forPattern((String)indexPattern);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid index pattern [%s] configured for the exporter", indexPattern));
                }
            }
        }
    }

    public QueryInsightsExporter createExporter(SinkType type, String indexPattern) {
        if (SinkType.LOCAL_INDEX.equals((Object)type)) {
            LocalIndexExporter exporter = new LocalIndexExporter(this.client, DateTimeFormat.forPattern((String)indexPattern));
            this.exporters.add(exporter);
            return exporter;
        }
        return DebugExporter.getInstance();
    }

    public QueryInsightsExporter updateExporter(QueryInsightsExporter exporter, String indexPattern) {
        if (exporter.getClass() == LocalIndexExporter.class) {
            ((LocalIndexExporter)exporter).setIndexPattern(DateTimeFormat.forPattern((String)indexPattern));
        }
        return exporter;
    }

    public void closeExporter(QueryInsightsExporter exporter) throws IOException {
        if (exporter != null) {
            exporter.close();
            this.exporters.remove(exporter);
        }
    }

    public void closeAllExporters() {
        for (QueryInsightsExporter exporter : this.exporters) {
            try {
                this.closeExporter(exporter);
            }
            catch (IOException e) {
                this.logger.error("Fail to close query insights exporter, error: ", (Throwable)e);
            }
        }
    }
}

