/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.threatIntel.action.SAGetTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SAGetTIFSourceConfigRequest;

public class RestGetTIFSourceConfigAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestGetTIFSourceConfigAction.class);

    public String getName() {
        return "get_tif_config_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/threat_intel/sources", "threat_intel_source_config_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String saTifSourceConfigId = request.param("threat_intel_source_config_id", "");
        if (saTifSourceConfigId == null || saTifSourceConfigId.isEmpty()) {
            throw new IllegalArgumentException("missing threat intel source config id");
        }
        SAGetTIFSourceConfigRequest req = new SAGetTIFSourceConfigRequest(saTifSourceConfigId, RestActions.parseVersion((RestRequest)request));
        return channel -> client.execute((ActionType)SAGetTIFSourceConfigAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }
}

