/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.alert.notifications;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.notifications.NotificationsPluginInterface;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.action.GetNotificationConfigResponse;
import org.opensearch.commons.notifications.action.SendNotificationResponse;
import org.opensearch.commons.notifications.model.ChannelMessage;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.notifications.model.SeverityType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;
import org.opensearch.securityanalytics.correlation.alert.notifications.CorrelationAlertContext;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.ThreatIntelAlertContext;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class NotificationService {
    private static final Logger logger = LogManager.getLogger(NotificationService.class);
    private static ScriptService scriptService;
    private final NodeClient client;

    public NotificationService(NodeClient client, ScriptService scriptService) {
        this.client = client;
        NotificationService.scriptService = scriptService;
    }

    public void sendNotification(final String configId, String severity, String subject, String notificationMessageText) throws IOException {
        ChannelMessage message = NotificationService.generateMessage(notificationMessageText);
        ArrayList<String> channelIds = new ArrayList<String>();
        channelIds.add(configId);
        SeverityType severityType = SeverityType.Companion.fromTagOrDefault(severity);
        NotificationsPluginInterface.INSTANCE.sendNotification(this.client, new EventSource(subject, configId, severityType, Collections.emptyList()), message, channelIds, (ActionListener)new ActionListener<SendNotificationResponse>(){

            public void onResponse(SendNotificationResponse sendNotificationResponse) {
                if (sendNotificationResponse.getStatus() == RestStatus.OK) {
                    logger.info("Successfully sent a notification, Notification Event: " + String.valueOf(sendNotificationResponse.getNotificationEvent()));
                } else {
                    logger.error("Error while sending a notification, Notification Event: " + String.valueOf(sendNotificationResponse.getNotificationEvent()));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed while sending a notification with " + configId, (Throwable)e);
            }
        });
    }

    public void sendNotification(String configId, String severity, String subject, String notificationMessageText, ActionListener<Void> listener) {
        ChannelMessage message = NotificationService.generateMessage(notificationMessageText);
        ArrayList<String> channelIds = new ArrayList<String>();
        channelIds.add(configId);
        SeverityType severityType = SeverityType.Companion.fromTagOrDefault(severity);
        NotificationsPluginInterface.INSTANCE.sendNotification(this.client, new EventSource(subject, configId, severityType, Collections.emptyList()), message, channelIds, ActionListener.wrap(sendNotificationResponse -> {
            if (sendNotificationResponse.getStatus() == RestStatus.OK) {
                logger.info("Successfully sent a notification, Notification Event: " + String.valueOf(sendNotificationResponse.getNotificationEvent()));
            } else {
                listener.onFailure(new Exception("Error while sending a notification, Notification Event: " + String.valueOf(sendNotificationResponse.getNotificationEvent())));
            }
        }, e -> {
            logger.error("Failed while sending a notification with " + configId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public GetNotificationConfigResponse getNotificationConfigInfo(final String id) {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        GetNotificationConfigRequest getNotificationConfigRequest = new GetNotificationConfigRequest(idSet, 0, 10, null, null, new HashMap());
        final GetNotificationConfigResponse configResp = null;
        NotificationsPluginInterface.INSTANCE.getNotificationConfig(this.client, getNotificationConfigRequest, (ActionListener)new ActionListener<GetNotificationConfigResponse>(){

            public void onResponse(GetNotificationConfigResponse getNotificationConfigResponse) {
                if (getNotificationConfigResponse.getStatus() == RestStatus.OK) {
                    getNotificationConfigResponse = configResp;
                } else {
                    logger.error("Successfully sent a notification, Notification Event: " + String.valueOf(getNotificationConfigResponse));
                }
            }

            public void onFailure(Exception e) {
                logger.error("Notification config [" + id + "] was not found");
                new SecurityAnalyticsException("Failed to fetch notification config", RestStatus.INTERNAL_SERVER_ERROR, e);
            }
        });
        logger.info("Notification config response is: {} ", configResp);
        return configResp;
    }

    public static ChannelMessage generateMessage(String message) {
        return new ChannelMessage(message, null, null);
    }

    public static String compileTemplate(CorrelationAlertContext ctx, Script template) {
        return NotificationService.compileTemplateGeneric(template, ctx.asTemplateArg());
    }

    public static String compileTemplate(ThreatIntelAlertContext ctx, Script template) {
        return NotificationService.compileTemplateGeneric(template, ctx.asTemplateArg());
    }

    private static String compileTemplateGeneric(Script template, Map<String, Object> templateArg) {
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(template.getParams());
        params.put("ctx", templateArg);
        TemplateScript templateScript = factory.newInstance(params);
        return templateScript.execute();
    }
}

