/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.cluster;

import com.google.common.collect.Sets;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.opensearch.action.admin.cluster.node.info.PluginsAndModules;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.client.AdminClient;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.Murmur3HashFunction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.plugins.PluginInfo;
import org.opensearch.timeseries.cluster.ADDataMigrator;
import org.opensearch.timeseries.cluster.TimeSeriesNodeInfo;
import org.opensearch.timeseries.cluster.VersionUtil;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.ml.SingleStreamModelIdMapper;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;

public class HashRing {
    private static final Logger LOG = LogManager.getLogger(HashRing.class);
    static final String COOLDOWN_MSG = "Hash ring doesn't respond to cluster state change within the cooldown period.";
    private static final String DEFAULT_HASH_RING_MODEL_ID = "DEFAULT_HASHRING_MODEL_ID";
    static final String REMOVE_MODEL_MSG = "Remove model";
    private final int VIRTUAL_NODE_COUNT = 100;
    private Semaphore buildHashRingSemaphore;
    private Map<String, TimeSeriesNodeInfo> nodeVersions;
    private TreeMap<Version, TreeMap<Integer, DiscoveryNode>> circles;
    private AtomicBoolean hashRingInited;
    private long lastUpdateForRealtimeAD;
    private volatile TimeValue coolDownPeriodForRealtimeAD;
    private TreeMap<Version, TreeMap<Integer, DiscoveryNode>> circlesForRealtimeAD;
    private ConcurrentLinkedQueue<Boolean> nodeChangeEvents;
    private final DiscoveryNodeFilterer nodeFilter;
    private final ClusterService clusterService;
    private final ADDataMigrator dataMigrator;
    private final Clock clock;
    private final Client client;
    private final ADModelManager modelManager;

    public HashRing(DiscoveryNodeFilterer nodeFilter, Clock clock, Settings settings, Client client, ClusterService clusterService, ADDataMigrator dataMigrator, ADModelManager modelManager) {
        this.nodeFilter = nodeFilter;
        this.buildHashRingSemaphore = new Semaphore(1);
        this.clock = clock;
        this.coolDownPeriodForRealtimeAD = (TimeValue)AnomalyDetectorSettings.AD_COOLDOWN_MINUTES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_COOLDOWN_MINUTES, it -> {
            this.coolDownPeriodForRealtimeAD = it;
        });
        this.lastUpdateForRealtimeAD = 0L;
        this.client = client;
        this.clusterService = clusterService;
        this.dataMigrator = dataMigrator;
        this.nodeVersions = new ConcurrentHashMap<String, TimeSeriesNodeInfo>();
        this.circles = new TreeMap();
        this.circlesForRealtimeAD = new TreeMap();
        this.hashRingInited = new AtomicBoolean(false);
        this.nodeChangeEvents = new ConcurrentLinkedQueue();
        this.modelManager = modelManager;
    }

    public boolean isHashRingInited() {
        return this.hashRingInited.get();
    }

    public void buildCircles(DiscoveryNodes.Delta delta, ActionListener<Boolean> listener) {
        if (!this.buildHashRingSemaphore.tryAcquire()) {
            LOG.info("hash ring change is in progress. Can't build hash ring for node delta event.");
            listener.onResponse((Object)false);
            return;
        }
        Set<String> removedNodeIds = delta.removed() ? delta.removedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet()) : null;
        Set addedNodeIds = delta.added() ? delta.addedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet()) : null;
        this.buildCircles(removedNodeIds, addedNodeIds, listener);
    }

    public void buildCircles(ActionListener<Boolean> actionListener) {
        if (!this.buildHashRingSemaphore.tryAcquire()) {
            LOG.info("hash ring change is in progress. Can't rebuild hash ring.");
            actionListener.onResponse((Object)false);
            return;
        }
        DiscoveryNode[] allNodes = this.nodeFilter.getAllNodes();
        HashSet<String> nodeIds = new HashSet<String>();
        for (DiscoveryNode node : allNodes) {
            nodeIds.add(node.getId());
        }
        Set<String> currentNodeIds = this.nodeVersions.keySet();
        Sets.SetView removedNodeIds = Sets.difference(currentNodeIds, nodeIds);
        Sets.SetView addedNodeIds = Sets.difference(nodeIds, currentNodeIds);
        this.buildCircles((Set<String>)removedNodeIds, (Set<String>)addedNodeIds, actionListener);
    }

    public void buildCirclesForRealtime() {
        if (this.nodeChangeEvents.isEmpty()) {
            return;
        }
        this.buildCircles((ActionListener<Boolean>)ActionListener.wrap(r -> LOG.debug("build circles successfully"), e -> LOG.error("Failed to build circles", (Throwable)e)));
    }

    private void buildCircles(Set<String> removedNodeIds, Set<String> addedNodeIds, ActionListener<Boolean> actionListener) {
        if (this.buildHashRingSemaphore.availablePermits() != 0) {
            throw new TimeSeriesException("Must get update hash ring semaphore before building AD hash ring");
        }
        try {
            DiscoveryNode localNode = this.clusterService.localNode();
            if (removedNodeIds != null && removedNodeIds.size() > 0) {
                LOG.info("Node removed: {}", (Object)Arrays.toString(removedNodeIds.toArray(new String[0])));
                for (String nodeId : removedNodeIds) {
                    TimeSeriesNodeInfo nodeInfo = this.nodeVersions.remove(nodeId);
                    if (nodeInfo == null || !nodeInfo.isEligibleDataNode()) continue;
                    this.removeNodeFromCircles(nodeId, nodeInfo.getVersion());
                    LOG.info("Remove data node from version hash ring: {}", (Object)nodeId);
                }
            }
            HashSet<String> allAddedNodes = new HashSet<String>();
            if (addedNodeIds != null) {
                allAddedNodes.addAll(addedNodeIds);
            }
            if (!this.nodeVersions.containsKey(localNode.getId())) {
                allAddedNodes.add(localNode.getId());
            }
            if (allAddedNodes.size() == 0) {
                actionListener.onResponse((Object)true);
                this.rebuildCirclesForRealtimeAD();
                this.buildHashRingSemaphore.release();
                return;
            }
            LOG.info("Node added: {}", (Object)Arrays.toString(allAddedNodes.toArray(new String[0])));
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
            nodesInfoRequest.nodesIds(allAddedNodes.toArray(new String[0]));
            nodesInfoRequest.clear().addMetric(NodesInfoRequest.Metric.PLUGINS.metricName());
            AdminClient admin = this.client.admin();
            ClusterAdminClient cluster = admin.cluster();
            cluster.nodesInfo(nodesInfoRequest, ActionListener.wrap(r -> {
                Map nodesMap = r.getNodesMap();
                if (nodesMap != null && nodesMap.size() > 0) {
                    for (Map.Entry entry : nodesMap.entrySet()) {
                        NodeInfo nodeInfo = (NodeInfo)entry.getValue();
                        PluginsAndModules plugins = (PluginsAndModules)nodeInfo.getInfo(PluginsAndModules.class);
                        DiscoveryNode curNode = nodeInfo.getNode();
                        if (plugins == null) continue;
                        TreeMap circle = null;
                        for (PluginInfo pluginInfo : plugins.getPluginInfos()) {
                            if (!"opensearch-anomaly-detection".equals(pluginInfo.getName()) && !"org.opensearch.ad.AnomalyDetectorPlugin".equals(pluginInfo.getName()) && !"opensearch-time-series-analytics".equals(pluginInfo.getName()) && !"org.opensearch.timeseries.TimeSeriesAnalyticsPlugin".equals(pluginInfo.getName())) continue;
                            Version version = VersionUtil.fromString(pluginInfo.getVersion());
                            boolean eligibleNode = this.nodeFilter.isEligibleNode(curNode);
                            if (eligibleNode) {
                                circle = this.circles.computeIfAbsent(version, key -> new TreeMap());
                                LOG.info("Add data node to version hash ring: {}", (Object)curNode.getId());
                            }
                            this.nodeVersions.put(curNode.getId(), new TimeSeriesNodeInfo(version, eligibleNode));
                            break;
                        }
                        if (circle == null) continue;
                        for (int i = 0; i < 100; ++i) {
                            circle.put(Murmur3HashFunction.hash((String)(curNode.getId() + i)), curNode);
                        }
                    }
                }
                LOG.info("All nodes with known version: {}", this.nodeVersions);
                this.rebuildCirclesForRealtimeAD();
                if (!this.dataMigrator.isMigrated() && this.circles.size() > 0) {
                    Optional<DiscoveryNode> owningNode = this.getOwningNodeWithHighestVersion(DEFAULT_HASH_RING_MODEL_ID);
                    String localNodeId = localNode.getId();
                    if (owningNode.isPresent() && localNodeId.equals(owningNode.get().getId())) {
                        this.dataMigrator.migrateData();
                    } else {
                        this.dataMigrator.skipMigration();
                    }
                }
                this.buildHashRingSemaphore.release();
                this.hashRingInited.set(true);
                actionListener.onResponse((Object)true);
            }, e -> {
                this.buildHashRingSemaphore.release();
                actionListener.onFailure(e);
                LOG.error("Fail to get node info to build hash ring", (Throwable)e);
            }));
        }
        catch (Exception e2) {
            LOG.error("Failed to build circles", (Throwable)e2);
            this.buildHashRingSemaphore.release();
            actionListener.onFailure(e2);
        }
    }

    private void removeNodeFromCircles(String nodeId, Version version) {
        if (version != null) {
            TreeMap<Integer, DiscoveryNode> circle = this.circles.get(version);
            ArrayList<Integer> deleted = new ArrayList<Integer>();
            for (Map.Entry<Integer, DiscoveryNode> entry : circle.entrySet()) {
                if (!entry.getValue().getId().equals(nodeId)) continue;
                deleted.add(entry.getKey());
            }
            if (deleted.size() == circle.size()) {
                this.circles.remove(version);
            } else {
                for (Integer key : deleted) {
                    circle.remove(key);
                }
            }
        }
    }

    private void rebuildCirclesForRealtimeAD() {
        block3: {
            Boolean poll;
            if (!this.eligibleToRebuildCirclesForRealtimeAD()) break block3;
            LOG.info("Rebuild hash ring for realtime with cooldown, nodeChangeEvents size {}", (Object)this.nodeChangeEvents.size());
            int size = this.nodeChangeEvents.size();
            TreeMap newCircles = new TreeMap();
            for (Map.Entry<Version, TreeMap<Integer, DiscoveryNode>> entry : this.circles.entrySet()) {
                newCircles.put(entry.getKey(), new TreeMap(entry.getValue()));
            }
            this.circlesForRealtimeAD = newCircles;
            this.lastUpdateForRealtimeAD = this.clock.millis();
            LOG.info("Build version hash ring successfully");
            String localNodeId = this.clusterService.localNode().getId();
            Set<String> modelIds = this.modelManager.getAllModelIds();
            for (String modelId : modelIds) {
                Optional<DiscoveryNode> node = this.getOwningNodeWithSameLocalVersionForRealtime(modelId);
                if (!node.isPresent() || node.get().getId().equals(localNodeId)) continue;
                LOG.info("Remove model {}", (Object)modelId);
                this.modelManager.stopModel(SingleStreamModelIdMapper.getConfigIdForModelId(modelId), modelId, (ActionListener<Void>)ActionListener.wrap(r -> LOG.info("Stopped model [{}] with response [{}]", (Object)modelId, r), e -> LOG.error("Fail to stop model " + modelId, (Throwable)e)));
            }
            while (size-- > 0 && (poll = this.nodeChangeEvents.poll()) != null) {
            }
        }
    }

    public boolean eligibleToRebuildCirclesForRealtimeAD() {
        if (this.nodeChangeEvents.isEmpty() && !this.circlesForRealtimeAD.isEmpty()) {
            return false;
        }
        if (this.clock.millis() - this.lastUpdateForRealtimeAD <= this.coolDownPeriodForRealtimeAD.getMillis()) {
            LOG.debug(COOLDOWN_MSG);
            return false;
        }
        return true;
    }

    public Optional<DiscoveryNode> getOwningNodeWithHighestVersion(String modelId) {
        int modelHash = Murmur3HashFunction.hash((String)modelId);
        Map.Entry<Version, TreeMap<Integer, DiscoveryNode>> versionTreeMapEntry = this.circles.lastEntry();
        if (versionTreeMapEntry == null) {
            return Optional.empty();
        }
        TreeMap<Integer, DiscoveryNode> versionCircle = versionTreeMapEntry.getValue();
        Map.Entry<Integer, DiscoveryNode> entry = versionCircle.higherEntry(modelHash);
        return Optional.ofNullable(Optional.ofNullable(entry).orElse(versionCircle.firstEntry())).map(x -> (DiscoveryNode)x.getValue());
    }

    public <T> void buildAndGetOwningNodeWithSameLocalVersion(String modelId, Consumer<Optional<DiscoveryNode>> function, ActionListener<T> listener) {
        this.buildCircles((ActionListener<Boolean>)ActionListener.wrap(r -> {
            DiscoveryNode localNode = this.clusterService.localNode();
            Version version = this.nodeVersions.containsKey(localNode.getId()) ? this.getVersion(localNode.getId()) : Version.CURRENT;
            Optional<DiscoveryNode> owningNode = this.getOwningNodeWithSameVersionDirectly(modelId, version, false);
            function.accept(owningNode);
        }, e -> listener.onFailure(e)));
    }

    public Optional<DiscoveryNode> getOwningNodeWithSameLocalVersionForRealtime(String modelId) {
        try {
            DiscoveryNode localNode = this.clusterService.localNode();
            Version version = this.nodeVersions.containsKey(localNode.getId()) ? this.getVersion(localNode.getId()) : Version.CURRENT;
            Optional<DiscoveryNode> owningNode = this.getOwningNodeWithSameVersionDirectly(modelId, version, true);
            this.buildCirclesForRealtime();
            return owningNode;
        }
        catch (Exception e) {
            LOG.error("Failed to get owning node with same local time series version", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<DiscoveryNode> getOwningNodeWithSameVersionDirectly(String modelId, Version version, boolean forRealtime) {
        TreeMap<Integer, DiscoveryNode> versionCircle;
        int modelHash = Murmur3HashFunction.hash((String)modelId);
        TreeMap<Integer, DiscoveryNode> treeMap = versionCircle = forRealtime ? this.circlesForRealtimeAD.get(version) : this.circles.get(version);
        if (versionCircle != null) {
            Map.Entry<Integer, DiscoveryNode> entry = versionCircle.higherEntry(modelHash);
            return Optional.ofNullable(Optional.ofNullable(entry).orElse(versionCircle.firstEntry())).map(x -> (DiscoveryNode)x.getValue());
        }
        return Optional.empty();
    }

    public <T> void getNodesWithSameLocalVersion(Consumer<DiscoveryNode[]> function, ActionListener<T> listener) {
        this.buildCircles((ActionListener<Boolean>)ActionListener.wrap(updated -> {
            DiscoveryNode localNode = this.clusterService.localNode();
            Version version = this.nodeVersions.containsKey(localNode.getId()) ? this.getVersion(localNode.getId()) : Version.CURRENT;
            Set<DiscoveryNode> nodes = this.getNodesWithSameVersion(version, false);
            if (!this.nodeVersions.containsKey(localNode.getId())) {
                nodes.add(localNode);
            }
            function.accept(nodes.toArray(new DiscoveryNode[0]));
        }, e -> listener.onFailure(e)));
    }

    public DiscoveryNode[] getNodesWithSameLocalVersion() {
        DiscoveryNode localNode = this.clusterService.localNode();
        Version version = this.nodeVersions.containsKey(localNode.getId()) ? this.getVersion(localNode.getId()) : Version.CURRENT;
        Set<DiscoveryNode> nodes = this.getNodesWithSameVersion(version, false);
        this.buildCirclesForRealtime();
        return nodes.toArray(new DiscoveryNode[0]);
    }

    public Set<DiscoveryNode> getNodesWithSameVersion(Version version, boolean forRealtime) {
        TreeMap<Integer, DiscoveryNode> circle = forRealtime ? this.circlesForRealtimeAD.get(version) : this.circles.get(version);
        HashSet nodeIds = new HashSet();
        HashSet<DiscoveryNode> nodes = new HashSet<DiscoveryNode>();
        if (circle == null) {
            return nodes;
        }
        circle.entrySet().stream().forEach(e -> {
            DiscoveryNode discoveryNode = (DiscoveryNode)e.getValue();
            if (!nodeIds.contains(discoveryNode.getId())) {
                nodeIds.add(discoveryNode.getId());
                nodes.add(discoveryNode);
            }
        });
        return nodes;
    }

    public Version getVersion(String nodeId) {
        TimeSeriesNodeInfo nodeInfo = this.nodeVersions.get(nodeId);
        return nodeInfo == null ? null : nodeInfo.getVersion();
    }

    public Optional<DiscoveryNode> getNodeByAddress(TransportAddress address) {
        DiscoveryNode[] allNodes;
        if (address == null) {
            return Optional.of(this.clusterService.localNode());
        }
        String ipAddress = this.getIpAddress(address);
        for (DiscoveryNode node : allNodes = this.nodeFilter.getAllNodes()) {
            if (!this.getIpAddress(node.getAddress()).equals(ipAddress)) continue;
            return Optional.ofNullable(node);
        }
        return Optional.empty();
    }

    private String getIpAddress(TransportAddress address) {
        return address.toString().split(":")[0];
    }

    public <T> void getAllEligibleDataNodesWithKnownVersion(Consumer<DiscoveryNode[]> function, ActionListener<T> listener) {
        this.buildCircles((ActionListener<Boolean>)ActionListener.wrap(r -> {
            DiscoveryNode[] eligibleDataNodes = this.nodeFilter.getEligibleDataNodes();
            ArrayList<DiscoveryNode> allNodes = new ArrayList<DiscoveryNode>();
            for (DiscoveryNode node : eligibleDataNodes) {
                if (!this.nodeVersions.containsKey(node.getId())) continue;
                allNodes.add(node);
            }
            function.accept(allNodes.toArray(new DiscoveryNode[0]));
        }, e -> listener.onFailure(e)));
    }

    public void addNodeChangeEvent() {
        this.nodeChangeEvents.add(true);
    }
}

