/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.intel.qat.QatZipper;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.opensearch.index.codec.customcodecs.Lucene99QatStoredFieldsFormat;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.mapper.MapperService;

public abstract class Lucene99QatCodec
extends FilterCodec {
    public static final Setting<QatZipper.Mode> INDEX_CODEC_QAT_MODE_SETTING = new Setting("index.codec.qatmode", "auto", s -> {
        switch (s) {
            case "auto": {
                return QatZipper.Mode.AUTO;
            }
            case "hardware": {
                return QatZipper.Mode.HARDWARE;
            }
        }
        throw new IllegalArgumentException("Unknown value for [index.codec.qatmode] must be one of [auto, hardware] but was: " + s);
    }, new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic});
    public static final QatZipper.Mode DEFAULT_QAT_MODE = (QatZipper.Mode)INDEX_CODEC_QAT_MODE_SETTING.getDefault(Settings.EMPTY);
    public static final int DEFAULT_COMPRESSION_LEVEL = (Integer)EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING.getDefault(Settings.EMPTY);
    public static final Mode DEFAULT_COMPRESSION_MODE = Mode.QAT_LZ4;
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene99QatCodec(Mode mode) {
        this(mode, DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene99QatCodec(Mode mode, int compressionLevel) {
        super(mode.getCodec(), (Codec)new Lucene99Codec());
        this.storedFieldsFormat = new Lucene99QatStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene99QatCodec(Mode mode, int compressionLevel, Supplier<QatZipper.Mode> supplier) {
        super(mode.getCodec(), (Codec)new Lucene99Codec());
        this.storedFieldsFormat = new Lucene99QatStoredFieldsFormat(mode, compressionLevel, supplier);
    }

    public Lucene99QatCodec(Mode mode, int compressionLevel, MapperService mapperService, Logger logger) {
        super(mode.getCodec(), (Codec)new PerFieldMappingPostingFormatCodec(Lucene99Codec.Mode.BEST_SPEED, mapperService, logger));
        this.storedFieldsFormat = new Lucene99QatStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene99QatCodec(Mode mode, int compressionLevel, MapperService mapperService, Logger logger, Supplier<QatZipper.Mode> supplier) {
        super(mode.getCodec(), (Codec)new PerFieldMappingPostingFormatCodec(Lucene99Codec.Mode.BEST_SPEED, mapperService, logger));
        this.storedFieldsFormat = new Lucene99QatStoredFieldsFormat(mode, compressionLevel, supplier);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static enum Mode {
        QAT_LZ4("QATLZ499", Set.of("qat_lz4")),
        QAT_DEFLATE("QATDEFLATE99", Set.of("qat_deflate"));

        private final String codec;
        private final Set<String> aliases;

        private Mode(String codec, Set<String> aliases) {
            this.codec = codec;
            this.aliases = aliases;
        }

        public String getCodec() {
            return this.codec;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

