/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/commons/alerting/action/AcknowledgeAlertRequest;", "Lorg/opensearch/action/ActionRequest;", "monitorId", "", "alertIds", "", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "(Ljava/lang/String;Ljava/util/List;Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getAlertIds", "()Ljava/util/List;", "getMonitorId", "()Ljava/lang/String;", "getRefreshPolicy", "()Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "common-utils"})
public final class AcknowledgeAlertRequest
extends ActionRequest {
    @NotNull
    private final String monitorId;
    @NotNull
    private final List<String> alertIds;
    @NotNull
    private final WriteRequest.RefreshPolicy refreshPolicy;

    @NotNull
    public final String getMonitorId() {
        return this.monitorId;
    }

    @NotNull
    public final List<String> getAlertIds() {
        return this.alertIds;
    }

    @NotNull
    public final WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public AcknowledgeAlertRequest(@NotNull String monitorId, @NotNull List<String> alertIds, @NotNull WriteRequest.RefreshPolicy refreshPolicy) {
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter(alertIds, (String)"alertIds");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        this.monitorId = monitorId;
        this.alertIds = alertIds;
        this.refreshPolicy = refreshPolicy;
    }

    public AcknowledgeAlertRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        List<String> list = Collections.unmodifiableList(sin.readStringList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(sin.readStringList())");
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)sin);
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"readFrom(sin)");
        this(string, list, refreshPolicy);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.monitorId);
        out.writeStringCollection((Collection)this.alertIds);
        this.refreshPolicy.writeTo(out);
    }
}

