/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndexStats;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Table;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.index.IndexSettings;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;

@ToolAnnotation(value="CatIndexTool")
public class CatIndexTool
implements Tool {
    public static final String TYPE = "CatIndexTool";
    private static final String DEFAULT_DESCRIPTION = String.join((CharSequence)" ", "This tool gets index information from the OpenSearch cluster.", "It takes 2 optional arguments named `index` which is a comma-delimited list of one or more indices to get information from (default is an empty list meaning all indices),", "and `local` which means whether to return information from the local node only instead of the cluster manager node (default is false).", "The tool returns the indices information, including `health`, `status`, `index`, `uuid`, `pri`, `rep`, `docs.count`, `docs.deleted`, `store.size`, `pri.store. size `, `pri.store.size`, `pri.store`.");
    private String name = "CatIndexTool";
    private String description = DEFAULT_DESCRIPTION;
    private String version;
    private Client client;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;
    private ClusterService clusterService;

    public CatIndexTool(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.outputParser = new Parser<Object, Object>(){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        List indexList = parameters.containsKey("indices") ? (List)StringUtils.gson.fromJson(parameters.get("indices"), List.class) : Collections.emptyList();
        final String[] indices = indexList.toArray(Strings.EMPTY_ARRAY);
        IndicesOptions indicesOptions = IndicesOptions.strictExpand();
        final boolean local = parameters.containsKey("local") ? Boolean.parseBoolean("local") : false;
        final TimeValue clusterManagerNodeTimeout = ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
        final boolean includeUnloadedSegments = Boolean.parseBoolean(parameters.get("include_unloaded_segments"));
        final ActionListener internalListener = ActionListener.notifyOnce((ActionListener)ActionListener.wrap(table -> {
            if (table.getRows().isEmpty()) {
                String empty = "There were no results searching the indices parameter [" + (String)parameters.get("indices") + "].";
                listener.onResponse((Object)empty);
                return;
            }
            StringBuilder sb = new StringBuilder(table.getHeaders().stream().map(c -> c.value.toString()).collect(Collectors.joining(",", "", "\n")));
            for (List row : table.getRows()) {
                sb.append(row.stream().map(c -> c.value == null ? null : c.value.toString()).collect(Collectors.joining(",", "", "\n")));
            }
            String response = sb.toString();
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)));
        this.sendGetSettingsRequest(indices, indicesOptions, local, clusterManagerNodeTimeout, this.client, new ActionListener<GetSettingsResponse>(){

            public void onResponse(GetSettingsResponse getSettingsResponse) {
                GroupedActionListener<ActionResponse> groupedListener = CatIndexTool.this.createGroupedListener(4, (ActionListener<Table>)internalListener);
                groupedListener.onResponse((Object)getSettingsResponse);
                IndicesOptions subRequestIndicesOptions = IndicesOptions.lenientExpandHidden();
                CatIndexTool.this.sendIndicesStatsRequest(indices, subRequestIndicesOptions, includeUnloadedSegments, CatIndexTool.this.client, (ActionListener<IndicesStatsResponse>)ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
                CatIndexTool.this.sendClusterStateRequest(indices, subRequestIndicesOptions, local, clusterManagerNodeTimeout, CatIndexTool.this.client, (ActionListener<ClusterStateResponse>)ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
                CatIndexTool.this.sendClusterHealthRequest(indices, subRequestIndicesOptions, local, clusterManagerNodeTimeout, CatIndexTool.this.client, (ActionListener<ClusterHealthResponse>)ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
            }

            public void onFailure(Exception e) {
                internalListener.onFailure(e);
            }
        });
    }

    public String getType() {
        return TYPE;
    }

    private void sendGetSettingsRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, Client client, ActionListener<GetSettingsResponse> listener) {
        GetSettingsRequest request = new GetSettingsRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        request.names(new String[]{IndexSettings.INDEX_SEARCH_THROTTLED.getKey()});
        client.admin().indices().getSettings(request, listener);
    }

    private void sendClusterStateRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, Client client, ActionListener<ClusterStateResponse> listener) {
        ClusterStateRequest request = new ClusterStateRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        client.admin().cluster().state(request, listener);
    }

    private void sendClusterHealthRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, Client client, ActionListener<ClusterHealthResponse> listener) {
        ClusterHealthRequest request = new ClusterHealthRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        client.admin().cluster().health(request, listener);
    }

    private void sendIndicesStatsRequest(String[] indices, IndicesOptions indicesOptions, boolean includeUnloadedSegments, Client client, ActionListener<IndicesStatsResponse> listener) {
        IndicesStatsRequest request = new IndicesStatsRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.all();
        request.includeUnloadedSegments(includeUnloadedSegments);
        client.admin().indices().stats(request, listener);
    }

    private GroupedActionListener<ActionResponse> createGroupedListener(int size, final ActionListener<Table> listener) {
        return new GroupedActionListener((ActionListener)new ActionListener<Collection<ActionResponse>>(){

            public void onResponse(Collection<ActionResponse> responses) {
                try {
                    GetSettingsResponse settingsResponse = CatIndexTool.extractResponse(responses, GetSettingsResponse.class);
                    Map<String, Settings> indicesSettings = StreamSupport.stream(Spliterators.spliterator(settingsResponse.getIndexToSettings().entrySet(), 0), false).collect(Collectors.toMap(cursor -> (String)cursor.getKey(), cursor -> (Settings)cursor.getValue()));
                    ClusterStateResponse stateResponse = CatIndexTool.extractResponse(responses, ClusterStateResponse.class);
                    Map<String, IndexMetadata> indicesStates = StreamSupport.stream(stateResponse.getState().getMetadata().spliterator(), false).collect(Collectors.toMap(indexMetadata -> indexMetadata.getIndex().getName(), Function.identity()));
                    ClusterHealthResponse healthResponse = CatIndexTool.extractResponse(responses, ClusterHealthResponse.class);
                    Map indicesHealths = healthResponse.getIndices();
                    IndicesStatsResponse statsResponse = CatIndexTool.extractResponse(responses, IndicesStatsResponse.class);
                    Map indicesStats = statsResponse.getIndices();
                    Table responseTable = CatIndexTool.this.buildTable(indicesSettings, indicesHealths, indicesStats, indicesStates);
                    listener.onResponse((Object)responseTable);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, size);
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && !parameters.isEmpty();
    }

    private Table getTableWithHeader() {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"row", "alias:r;desc:row number");
        table.addCell((Object)"health", "alias:h;desc:current health status");
        table.addCell((Object)"status", "alias:s;desc:open/close status");
        table.addCell((Object)"index", "alias:i,idx;desc:index name");
        table.addCell((Object)"uuid", "alias:id,uuid;desc:index uuid");
        table.addCell((Object)"pri(number of primary shards)", "alias:p,shards.primary,shardsPrimary;text-align:right;desc:number of primary shards");
        table.addCell((Object)"rep(number of replica shards)", "alias:r,shards.replica,shardsReplica;text-align:right;desc:number of replica shards");
        table.addCell((Object)"docs.count(number of available documents)", "alias:dc,docsCount;text-align:right;desc:available docs");
        table.addCell((Object)"docs.deleted(number of deleted documents)", "alias:dd,docsDeleted;text-align:right;desc:deleted docs");
        table.addCell((Object)"store.size(store size of primary and replica shards)", "sibling:pri;alias:ss,storeSize;text-align:right;desc:store size of primaries & replicas");
        table.addCell((Object)"pri.store.size(store size of primary shards)", "text-align:right;desc:store size of primaries");
        table.endHeaders();
        return table;
    }

    private Table buildTable(Map<String, Settings> indicesSettings, Map<String, ClusterIndexHealth> indicesHealths, Map<String, IndexStats> indicesStats, Map<String, IndexMetadata> indicesMetadatas) {
        Table table = this.getTableWithHeader();
        AtomicInteger rowNum = new AtomicInteger(0);
        indicesSettings.forEach((indexName, settings) -> {
            CommonStats totalStats;
            CommonStats primaryStats;
            if (!indicesMetadatas.containsKey(indexName)) {
                return;
            }
            IndexMetadata indexMetadata = (IndexMetadata)indicesMetadatas.get(indexName);
            IndexMetadata.State indexState = indexMetadata.getState();
            IndexStats indexStats = (IndexStats)indicesStats.get(indexName);
            ClusterIndexHealth indexHealth = (ClusterIndexHealth)indicesHealths.get(indexName);
            String health = indexHealth != null ? indexHealth.getStatus().toString().toLowerCase(Locale.ROOT) : (indexStats != null ? "red*" : "");
            if (indexStats == null || indexState == IndexMetadata.State.CLOSE) {
                primaryStats = new CommonStats();
                totalStats = new CommonStats();
            } else {
                primaryStats = indexStats.getPrimaries();
                totalStats = indexStats.getTotal();
            }
            table.startRow();
            table.addCell((Object)rowNum.addAndGet(1));
            table.addCell((Object)health);
            table.addCell((Object)indexState.toString().toLowerCase(Locale.ROOT));
            table.addCell(indexName);
            table.addCell((Object)indexMetadata.getIndexUUID());
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfShards()));
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfReplicas()));
            table.addCell(primaryStats.getDocs() == null ? null : Long.valueOf(primaryStats.getDocs().getCount()));
            table.addCell(primaryStats.getDocs() == null ? null : Long.valueOf(primaryStats.getDocs().getDeleted()));
            table.addCell(totalStats.getStore() == null ? null : totalStats.getStore().size());
            table.addCell(primaryStats.getStore() == null ? null : primaryStats.getStore().size());
            table.endRow();
        });
        return table;
    }

    private static <A extends ActionResponse> A extractResponse(Collection<? extends ActionResponse> responses, Class<A> c) {
        return (A)responses.stream().filter(c::isInstance).findFirst().get();
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    public static class Factory
    implements Tool.Factory<CatIndexTool> {
        private Client client;
        private ClusterService clusterService;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<CatIndexTool> clazz = CatIndexTool.class;
            synchronized (CatIndexTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, ClusterService clusterService) {
            this.client = client;
            this.clusterService = clusterService;
        }

        public CatIndexTool create(Map<String, Object> map) {
            return new CatIndexTool(this.client, this.clusterService);
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return CatIndexTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

