/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.common.Nullable;
import org.opensearch.common.ValidationException;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.KNNVectorIndexFieldData;
import org.opensearch.knn.index.KnnCircuitBreakerException;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.LegacyFieldMapper;
import org.opensearch.knn.index.mapper.LuceneFieldMapper;
import org.opensearch.knn.index.mapper.MethodFieldMapper;
import org.opensearch.knn.index.mapper.ModelFieldMapper;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public abstract class KNNVectorFieldMapper
extends ParametrizedFieldMapper {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNVectorFieldMapper.class);
    public static final String CONTENT_TYPE = "knn_vector";
    public static final String KNN_FIELD = "knn_field";
    protected Version indexCreatedVersion;
    protected Explicit<Boolean> ignoreMalformed;
    protected boolean stored;
    protected boolean hasDocValues;
    protected Integer dimension;
    protected VectorDataType vectorDataType;
    protected ModelDao modelDao;
    protected KNNMethodContext knnMethod;
    protected String modelId;

    private static KNNVectorFieldMapper toType(FieldMapper in) {
        return (KNNVectorFieldMapper)in;
    }

    public KNNVectorFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, Version indexCreatedVersion) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.stored = stored;
        this.hasDocValues = hasDocValues;
        this.dimension = mappedFieldType.getDimension();
        this.vectorDataType = mappedFieldType.getVectorDataType();
        this.updateEngineStats();
        this.indexCreatedVersion = indexCreatedVersion;
    }

    public KNNVectorFieldMapper clone() {
        return (KNNVectorFieldMapper)super.clone();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        this.parseCreateField(context, this.fieldType().getDimension(), this.fieldType().getSpaceType(), this.getMethodComponentContext(this.fieldType().getKnnMethodContext()), this.fieldType().getVectorDataType());
    }

    private MethodComponentContext getMethodComponentContext(KNNMethodContext knnMethodContext) {
        if (Objects.isNull(knnMethodContext)) {
            return null;
        }
        return knnMethodContext.getMethodComponentContext();
    }

    protected List<Field> getFieldsForFloatVector(float[] array, FieldType fieldType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new VectorField(this.name(), array, (IndexableFieldType)fieldType));
        if (this.stored) {
            fields.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForFloatVector(this.name(), array));
        }
        return fields;
    }

    protected List<Field> getFieldsForByteVector(byte[] array, FieldType fieldType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new VectorField(this.name(), array, (IndexableFieldType)fieldType));
        if (this.stored) {
            fields.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForByteVector(this.name(), array));
        }
        return fields;
    }

    protected void parseCreateField(ParseContext context, int dimension, SpaceType spaceType, MethodComponentContext methodComponentContext, VectorDataType vectorDataType) throws IOException {
        this.validateIfKNNPluginEnabled();
        this.validateIfCircuitBreakerIsNotTriggered();
        spaceType.validateVectorDataType(vectorDataType);
        if (VectorDataType.BINARY == vectorDataType) {
            Optional<byte[]> bytesArrayOptional = this.getBytesFromContext(context, dimension, vectorDataType);
            if (bytesArrayOptional.isEmpty()) {
                return;
            }
            byte[] array = bytesArrayOptional.get();
            spaceType.validateVector(array);
            context.doc().addAll(this.getFieldsForByteVector(array, this.fieldType));
        } else if (VectorDataType.BYTE == vectorDataType) {
            Optional<byte[]> bytesArrayOptional = this.getBytesFromContext(context, dimension, vectorDataType);
            if (bytesArrayOptional.isEmpty()) {
                return;
            }
            byte[] array = bytesArrayOptional.get();
            spaceType.validateVector(array);
            context.doc().addAll(this.getFieldsForByteVector(array, this.fieldType));
        } else if (VectorDataType.FLOAT == vectorDataType) {
            Optional<float[]> floatsArrayOptional = this.getFloatsFromContext(context, dimension, methodComponentContext);
            if (floatsArrayOptional.isEmpty()) {
                return;
            }
            float[] array = floatsArrayOptional.get();
            spaceType.validateVector(array);
            context.doc().addAll(this.getFieldsForFloatVector(array, this.fieldType));
        } else {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot parse context for unsupported values provided for field [%s]", "data_type"));
        }
        context.path().remove();
    }

    protected boolean isFaissSQfp16(MethodComponentContext methodComponentContext) {
        if (Objects.isNull(methodComponentContext)) {
            return false;
        }
        if (methodComponentContext.getParameters().size() == 0) {
            return false;
        }
        Map<String, Object> methodComponentParams = methodComponentContext.getParameters();
        if (!methodComponentParams.containsKey("encoder")) {
            return false;
        }
        if (!(methodComponentParams.get("encoder") instanceof MethodComponentContext)) {
            return false;
        }
        MethodComponentContext encoderMethodComponentContext = (MethodComponentContext)methodComponentParams.get("encoder");
        return "sq".equals(encoderMethodComponentContext.getName()) && "fp16".equals(encoderMethodComponentContext.getParameters().getOrDefault("type", "fp16"));
    }

    protected boolean isFaissSQClipToFP16RangeEnabled(MethodComponentContext methodComponentContext) {
        if (Objects.nonNull(methodComponentContext)) {
            return (Boolean)methodComponentContext.getParameters().getOrDefault("clip", false);
        }
        return false;
    }

    void validateIfCircuitBreakerIsNotTriggered() {
        if (KNNSettings.isCircuitBreakerTriggered()) {
            throw new KnnCircuitBreakerException("Parsing the created knn vector fields prior to indexing has failed as the circuit breaker triggered.  This indicates that the cluster is low on memory resources and cannot index more documents at the moment. Check _plugins/_knn/stats for the circuit breaker status.");
        }
    }

    void validateIfKNNPluginEnabled() {
        if (!KNNSettings.isKNNPluginEnabled()) {
            throw new IllegalStateException("KNN plugin is disabled. To enable update knn.plugin.enabled setting to true");
        }
    }

    Optional<byte[]> getBytesFromContext(ParseContext context, int dimension, VectorDataType dataType) throws IOException {
        float value;
        context.path().add(this.simpleName());
        ArrayList<Byte> vector = new ArrayList<Byte>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = context.parser().floatValue();
                KNNValidationUtil.validateByteVectorValue(value, dataType);
                vector.add((byte)value);
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = context.parser().floatValue();
            KNNValidationUtil.validateByteVectorValue(value, dataType);
            vector.add((byte)value);
            context.parser().nextToken();
        } else if (token == XContentParser.Token.VALUE_NULL) {
            context.path().remove();
            return Optional.empty();
        }
        KNNValidationUtil.validateVectorDimension(dimension, vector.size(), dataType);
        byte[] array = new byte[vector.size()];
        int i = 0;
        for (Byte f : vector) {
            array[i++] = f;
        }
        return Optional.of(array);
    }

    Optional<float[]> getFloatsFromContext(ParseContext context, int dimension, MethodComponentContext methodComponentContext) throws IOException {
        float value;
        context.path().add(this.simpleName());
        boolean isFaissSQfp16Flag = this.isFaissSQfp16(methodComponentContext);
        boolean clipVectorValueToFP16RangeFlag = false;
        if (isFaissSQfp16Flag) {
            clipVectorValueToFP16RangeFlag = this.isFaissSQClipToFP16RangeEnabled((MethodComponentContext)methodComponentContext.getParameters().get("encoder"));
        }
        ArrayList<Float> vector = new ArrayList<Float>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = context.parser().floatValue();
                if (isFaissSQfp16Flag) {
                    if (clipVectorValueToFP16RangeFlag) {
                        value = KNNVectorFieldMapperUtil.clipVectorValueToFP16Range(value);
                    } else {
                        KNNVectorFieldMapperUtil.validateFP16VectorValue(value);
                    }
                } else {
                    KNNValidationUtil.validateFloatVectorValue(value);
                }
                vector.add(Float.valueOf(value));
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = context.parser().floatValue();
            if (isFaissSQfp16Flag) {
                if (clipVectorValueToFP16RangeFlag) {
                    value = KNNVectorFieldMapperUtil.clipVectorValueToFP16Range(value);
                } else {
                    KNNVectorFieldMapperUtil.validateFP16VectorValue(value);
                }
            } else {
                KNNValidationUtil.validateFloatVectorValue(value);
            }
            vector.add(Float.valueOf(value));
            context.parser().nextToken();
        } else if (token == XContentParser.Token.VALUE_NULL) {
            context.path().remove();
            return Optional.empty();
        }
        KNNValidationUtil.validateVectorDimension(dimension, vector.size(), this.vectorDataType);
        float[] array = new float[vector.size()];
        int i = 0;
        for (Float f : vector) {
            array[i++] = f.floatValue();
        }
        return Optional.of(array);
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.modelDao, this.indexCreatedVersion).init((FieldMapper)this);
    }

    public final boolean parsesArrayValue() {
        return true;
    }

    public KNNVectorFieldType fieldType() {
        return (KNNVectorFieldType)super.fieldType();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Boolean)this.ignoreMalformed.value());
        }
    }

    void updateEngineStats() {
    }

    public static class KNNVectorFieldType
    extends MappedFieldType {
        int dimension;
        String modelId;
        KNNMethodContext knnMethodContext;
        VectorDataType vectorDataType;
        SpaceType spaceType;

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension, VectorDataType vectorDataType, SpaceType spaceType) {
            this(name, meta, dimension, null, null, vectorDataType, spaceType);
        }

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension, KNNMethodContext knnMethodContext) {
            this(name, meta, dimension, knnMethodContext, null, KNNConstants.DEFAULT_VECTOR_DATA_TYPE_FIELD, knnMethodContext.getSpaceType());
        }

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension, KNNMethodContext knnMethodContext, String modelId) {
            this(name, meta, dimension, knnMethodContext, modelId, KNNConstants.DEFAULT_VECTOR_DATA_TYPE_FIELD, null);
        }

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension, KNNMethodContext knnMethodContext, VectorDataType vectorDataType) {
            this(name, meta, dimension, knnMethodContext, null, vectorDataType, knnMethodContext.getSpaceType());
        }

        public KNNVectorFieldType(String name, Map<String, String> meta, int dimension, @Nullable KNNMethodContext knnMethodContext, @Nullable String modelId, VectorDataType vectorDataType, @Nullable SpaceType spaceType) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.dimension = dimension;
            this.modelId = modelId;
            this.knnMethodContext = knnMethodContext;
            this.vectorDataType = vectorDataType;
            this.spaceType = spaceType;
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("KNN Vector do not support fields search");
        }

        public String typeName() {
            return KNNVectorFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, String.format(Locale.ROOT, "KNN vector do not support exact searching, use KNN queries instead: [%s]", this.name()), new Object[0]);
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new KNNVectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES, this.vectorDataType);
        }

        public Object valueForDisplay(Object value) {
            return KNNVectorFieldMapperUtil.deserializeStoredVector((BytesRef)value, this.vectorDataType);
        }

        @Generated
        public int getDimension() {
            return this.dimension;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public KNNMethodContext getKnnMethodContext() {
            return this.knnMethodContext;
        }

        @Generated
        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        @Generated
        public SpaceType getSpaceType() {
            return this.spaceType;
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected Boolean ignoreMalformed;
        protected final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> KNNVectorFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        protected final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> KNNVectorFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        protected final ParametrizedFieldMapper.Parameter<Integer> dimension = new ParametrizedFieldMapper.Parameter("dimension", false, () -> -1, (n, c, o) -> {
            int value;
            if (o == null) {
                throw new IllegalArgumentException("Dimension cannot be null");
            }
            try {
                value = XContentMapValues.nodeIntegerValue((Object)o);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to parse [dimension] from provided value [%s] for vector [%s]", o, this.name));
            }
            if (value <= 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value must be greater than 0 for vector: %s", this.name));
            }
            return value;
        }, m -> KNNVectorFieldMapper.toType((FieldMapper)m).dimension);
        protected final ParametrizedFieldMapper.Parameter<VectorDataType> vectorDataType = new ParametrizedFieldMapper.Parameter("data_type", false, () -> KNNConstants.DEFAULT_VECTOR_DATA_TYPE_FIELD, (n, c, o) -> VectorDataType.get((String)o), m -> KNNVectorFieldMapper.toType((FieldMapper)m).vectorDataType);
        protected final ParametrizedFieldMapper.Parameter<String> modelId = ParametrizedFieldMapper.Parameter.stringParam((String)"model_id", (boolean)false, m -> KNNVectorFieldMapper.toType((FieldMapper)m).modelId, null);
        protected final ParametrizedFieldMapper.Parameter<KNNMethodContext> knnMethodContext = new ParametrizedFieldMapper.Parameter("method", false, () -> null, (n, c, o) -> KNNMethodContext.parse(o), m -> KNNVectorFieldMapper.toType((FieldMapper)m).knnMethod).setSerializer((b, n, v) -> {
            b.startObject(n);
            v.toXContent(b, ToXContent.EMPTY_PARAMS);
            b.endObject();
        }, m -> m.getMethodComponentContext().getName()).setValidator(v -> {
            ValidationException methodValidation;
            if (v == null) {
                return;
            }
            ValidationException validationException = null;
            if (v.isTrainingRequired()) {
                validationException = new ValidationException();
                validationException.addValidationError(String.format(Locale.ROOT, "\"%s\" requires training.", "method"));
            }
            if ((methodValidation = v.validate()) != null) {
                validationException = validationException == null ? new ValidationException() : validationException;
                validationException.addValidationErrors((Iterable)methodValidation.validationErrors());
            }
            if (validationException != null) {
                throw validationException;
            }
        });
        protected final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        protected String spaceType;
        protected String m;
        protected String efConstruction;
        protected ModelDao modelDao;
        protected Version indexCreatedVersion;

        public Builder(String name, ModelDao modelDao, Version indexCreatedVersion) {
            super(name);
            this.modelDao = modelDao;
            this.indexCreatedVersion = indexCreatedVersion;
        }

        public Builder(String name, String spaceType, String m2, String efConstruction, Version indexCreatedVersion) {
            super(name);
            this.spaceType = spaceType;
            this.m = m2;
            this.efConstruction = efConstruction;
            this.indexCreatedVersion = indexCreatedVersion;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.hasDocValues, this.dimension, this.vectorDataType, this.meta, this.knnMethodContext, this.modelId);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit((Object)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings())), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public KNNVectorFieldMapper build(Mapper.BuilderContext context) {
            KNNMethodContext knnMethodContext = (KNNMethodContext)this.knnMethodContext.getValue();
            this.setDefaultSpaceType(knnMethodContext, (VectorDataType)((Object)this.vectorDataType.getValue()));
            this.validateSpaceType(knnMethodContext, (VectorDataType)((Object)this.vectorDataType.getValue()));
            this.validateDimensions(knnMethodContext, (VectorDataType)((Object)this.vectorDataType.getValue()));
            this.validateEncoder(knnMethodContext, (VectorDataType)((Object)this.vectorDataType.getValue()));
            FieldMapper.MultiFields multiFieldsBuilder = this.multiFieldsBuilder.build((Mapper.Builder)this, context);
            FieldMapper.CopyTo copyToBuilder = this.copyTo.build();
            Explicit<Boolean> ignoreMalformed = this.ignoreMalformed(context);
            Map metaValue = (Map)this.meta.getValue();
            if (knnMethodContext != null) {
                KNNVectorFieldMapperUtil.validateVectorDataType(knnMethodContext, (VectorDataType)((Object)this.vectorDataType.getValue()));
                knnMethodContext.getMethodComponentContext().setIndexVersion(this.indexCreatedVersion);
                KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(this.buildFullName(context), (Map<String, String>)metaValue, (int)((Integer)this.dimension.getValue()), knnMethodContext, (VectorDataType)((Object)this.vectorDataType.getValue()));
                if (knnMethodContext.getKnnEngine() == KNNEngine.LUCENE) {
                    log.debug(String.format(Locale.ROOT, "Use [LuceneFieldMapper] mapper for field [%s]", this.name));
                    LuceneFieldMapper.CreateLuceneFieldMapperInput createLuceneFieldMapperInput = LuceneFieldMapper.CreateLuceneFieldMapperInput.builder().name(this.name).mappedFieldType(mappedFieldType).multiFields(multiFieldsBuilder).copyTo(copyToBuilder).ignoreMalformed(ignoreMalformed).stored((Boolean)this.stored.get()).hasDocValues((Boolean)this.hasDocValues.get()).vectorDataType((VectorDataType)((Object)this.vectorDataType.getValue())).knnMethodContext(knnMethodContext).build();
                    return new LuceneFieldMapper(createLuceneFieldMapperInput);
                }
                return new MethodFieldMapper(this.name, mappedFieldType, multiFieldsBuilder, copyToBuilder, ignoreMalformed, (boolean)((Boolean)this.stored.get()), (boolean)((Boolean)this.hasDocValues.get()), knnMethodContext);
            }
            String modelIdAsString = (String)this.modelId.get();
            if (modelIdAsString != null) {
                return new ModelFieldMapper(this.name, new KNNVectorFieldType(this.buildFullName(context), (Map<String, String>)metaValue, -1, knnMethodContext, modelIdAsString), multiFieldsBuilder, copyToBuilder, ignoreMalformed, (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), this.modelDao, modelIdAsString, this.indexCreatedVersion);
            }
            if (this.spaceType == null) {
                this.spaceType = LegacyFieldMapper.getSpaceType(context.indexSettings(), (VectorDataType)((Object)this.vectorDataType.getValue()));
            }
            if (this.m == null) {
                this.m = LegacyFieldMapper.getM(context.indexSettings());
            }
            if (this.efConstruction == null) {
                this.efConstruction = LegacyFieldMapper.getEfConstruction(context.indexSettings(), this.indexCreatedVersion);
            }
            KNNVectorFieldMapperUtil.validateVectorDataTypeWithKnnIndexSetting(context.indexSettings().getAsBoolean("index.knn", Boolean.valueOf(false)), this.vectorDataType);
            return new LegacyFieldMapper(this.name, new KNNVectorFieldType(this.buildFullName(context), (Map<String, String>)metaValue, (int)((Integer)this.dimension.getValue()), (VectorDataType)((Object)this.vectorDataType.getValue()), SpaceType.getSpace(this.spaceType)), multiFieldsBuilder, copyToBuilder, ignoreMalformed, (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), this.spaceType, this.m, this.efConstruction, this.indexCreatedVersion);
        }

        private void validateEncoder(KNNMethodContext knnMethodContext, VectorDataType vectorDataType) {
            if (knnMethodContext == null) {
                return;
            }
            if (VectorDataType.FLOAT == vectorDataType) {
                return;
            }
            if (knnMethodContext.getMethodComponentContext() == null) {
                return;
            }
            if (knnMethodContext.getMethodComponentContext().getParameters() == null) {
                return;
            }
            if (knnMethodContext.getMethodComponentContext().getParameters().get("encoder") == null) {
                return;
            }
            if (!(knnMethodContext.getMethodComponentContext().getParameters().get("encoder") instanceof MethodComponentContext)) {
                return;
            }
            MethodComponentContext encoderMethodComponentContext = (MethodComponentContext)knnMethodContext.getMethodComponentContext().getParameters().get("encoder");
            if (!"flat".equals(encoderMethodComponentContext.getName())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s data type does not support %s encoder", vectorDataType.getValue(), encoderMethodComponentContext.getName()));
            }
        }

        private void setDefaultSpaceType(KNNMethodContext knnMethodContext, VectorDataType vectorDataType) {
            if (knnMethodContext == null) {
                return;
            }
            if (SpaceType.UNDEFINED == knnMethodContext.getSpaceType()) {
                if (VectorDataType.BINARY == vectorDataType) {
                    knnMethodContext.setSpaceType(SpaceType.DEFAULT_BINARY);
                } else {
                    knnMethodContext.setSpaceType(SpaceType.DEFAULT);
                }
            }
        }

        private void validateSpaceType(KNNMethodContext knnMethodContext, VectorDataType vectorDataType) {
            if (knnMethodContext == null) {
                return;
            }
            knnMethodContext.getSpaceType().validateVectorDataType(vectorDataType);
        }

        private KNNEngine validateDimensions(KNNMethodContext knnMethodContext, VectorDataType dataType) {
            KNNEngine knnEngine = knnMethodContext != null ? knnMethodContext.getKnnEngine() : KNNEngine.DEFAULT;
            if ((Integer)this.dimension.getValue() > KNNEngine.getMaxDimensionByEngine(knnEngine)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value cannot be greater than %s for vector: %s", KNNEngine.getMaxDimensionByEngine(knnEngine), this.name));
            }
            if (VectorDataType.BINARY == dataType && (Integer)this.dimension.getValue() % 8 != 0) {
                throw new IllegalArgumentException("Dimension should be multiply of 8 for binary vector data type");
            }
            return knnEngine;
        }
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setDocValuesType(DocValuesType.BINARY);
            FIELD_TYPE.putAttribute(KNNVectorFieldMapper.KNN_FIELD, "true");
            FIELD_TYPE.freeze();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private Supplier<ModelDao> modelDaoSupplier;

        public TypeParser(Supplier<ModelDao> modelDaoSupplier) {
            this.modelDaoSupplier = modelDaoSupplier;
        }

        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.modelDaoSupplier.get(), parserContext.indexVersionCreated());
            builder.parse(name, parserContext, node);
            if (builder.knnMethodContext.get() != null && builder.modelId.get() != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Method and model can not be both specified in the mapping: %s", name));
            }
            if ((Integer)builder.dimension.getValue() == -1 && builder.modelId.get() == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value missing for vector: %s", name));
            }
            return builder;
        }
    }
}

