/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.common.TriFunction;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.Parameter;
import org.opensearch.knn.index.util.IndexHyperParametersUtil;
import org.opensearch.knn.training.VectorSpaceInfo;
import org.opensearch.knn.validation.ParameterValidator;

public class MethodComponent {
    private String name;
    private Map<String, Parameter<?>> parameters;
    private BiFunction<MethodComponent, MethodComponentContext, Map<String, Object>> mapGenerator;
    private TriFunction<MethodComponent, MethodComponentContext, Integer, Long> overheadInKBEstimator;
    private final boolean requiresTraining;

    private MethodComponent(Builder builder) {
        this.name = builder.name;
        this.parameters = builder.parameters;
        this.mapGenerator = builder.mapGenerator;
        this.overheadInKBEstimator = builder.overheadInKBEstimator;
        this.requiresTraining = builder.requiresTraining;
    }

    public Map<String, Object> getAsMap(MethodComponentContext methodComponentContext) {
        if (this.mapGenerator == null) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("name", methodComponentContext.getName());
            parameterMap.put("parameters", MethodComponent.getParameterMapWithDefaultsAdded(methodComponentContext, this));
            return parameterMap;
        }
        return this.mapGenerator.apply(this, methodComponentContext);
    }

    public ValidationException validate(MethodComponentContext methodComponentContext) {
        Map<String, Object> providedParameters = methodComponentContext.getParameters();
        return ParameterValidator.validateParameters(this.parameters, providedParameters);
    }

    public ValidationException validateWithData(MethodComponentContext methodComponentContext, VectorSpaceInfo vectorSpaceInfo) {
        Map<String, Object> providedParameters = methodComponentContext.getParameters();
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (providedParameters == null) {
            return null;
        }
        for (Map.Entry<String, Object> parameter : providedParameters.entrySet()) {
            if (!this.parameters.containsKey(parameter.getKey())) {
                errorMessages.add(String.format("Invalid parameter for method \"%s\".", this.getName()));
                continue;
            }
            ValidationException parameterValidation = this.parameters.get(parameter.getKey()).validateWithData(parameter.getValue(), vectorSpaceInfo);
            if (parameterValidation == null) continue;
            errorMessages.addAll(parameterValidation.validationErrors());
        }
        if (errorMessages.isEmpty()) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        validationException.addValidationErrors(errorMessages);
        return validationException;
    }

    public boolean isTrainingRequired(MethodComponentContext methodComponentContext) {
        if (this.requiresTraining) {
            return true;
        }
        Map<String, Object> providedParameters = methodComponentContext.getParameters();
        if (providedParameters == null || providedParameters.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Object> providedParameter : providedParameters.entrySet()) {
            MethodComponentContext parameterMethodComponentContext;
            MethodComponent methodComponent;
            Parameter<?> parameter = this.parameters.get(providedParameter.getKey());
            if (!(parameter instanceof Parameter.MethodComponentContextParameter)) continue;
            Parameter.MethodComponentContextParameter methodParameter = (Parameter.MethodComponentContextParameter)parameter;
            Object providedValue = providedParameter.getValue();
            if (!(providedValue instanceof MethodComponentContext) || !(methodComponent = methodParameter.getMethodComponent((parameterMethodComponentContext = (MethodComponentContext)providedValue).getName())).isTrainingRequired(parameterMethodComponentContext)) continue;
            return true;
        }
        return false;
    }

    public int estimateOverheadInKB(MethodComponentContext methodComponentContext, int dimension) {
        long size = (Long)this.overheadInKBEstimator.apply((Object)this, (Object)methodComponentContext, (Object)dimension);
        Map<String, Object> providedParameters = methodComponentContext.getParameters();
        if (providedParameters == null || providedParameters.isEmpty()) {
            return Math.toIntExact(size);
        }
        for (Map.Entry<String, Object> providedParameter : providedParameters.entrySet()) {
            Parameter<?> parameter = this.parameters.get(providedParameter.getKey());
            if (!(parameter instanceof Parameter.MethodComponentContextParameter)) continue;
            Parameter.MethodComponentContextParameter methodParameter = (Parameter.MethodComponentContextParameter)parameter;
            Object providedValue = providedParameter.getValue();
            if (!(providedValue instanceof MethodComponentContext)) continue;
            MethodComponentContext parameterMethodComponentContext = (MethodComponentContext)providedValue;
            MethodComponent methodComponent = methodParameter.getMethodComponent(parameterMethodComponentContext.getName());
            size += (long)methodComponent.estimateOverheadInKB(parameterMethodComponentContext, dimension);
        }
        return Math.toIntExact(size);
    }

    public static Map<String, Object> getParameterMapWithDefaultsAdded(MethodComponentContext methodComponentContext, MethodComponent methodComponent) {
        HashMap<String, Object> parametersWithDefaultsMap = new HashMap<String, Object>();
        Map<String, Object> userProvidedParametersMap = methodComponentContext.getParameters();
        Version indexCreationVersion = methodComponentContext.getIndexVersion();
        for (Parameter<?> parameter : methodComponent.getParameters().values()) {
            if (methodComponentContext.getParameters().containsKey(parameter.getName())) {
                parametersWithDefaultsMap.put(parameter.getName(), userProvidedParametersMap.get(parameter.getName()));
                continue;
            }
            if (parameter.getName().equals("ef_search")) {
                parametersWithDefaultsMap.put(parameter.getName(), IndexHyperParametersUtil.getHNSWEFSearchValue(indexCreationVersion));
                continue;
            }
            if (parameter.getName().equals("ef_construction")) {
                parametersWithDefaultsMap.put(parameter.getName(), IndexHyperParametersUtil.getHNSWEFConstructionValue(indexCreationVersion));
                continue;
            }
            parametersWithDefaultsMap.put(parameter.getName(), parameter.getDefaultValue());
        }
        return parametersWithDefaultsMap;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Parameter<?>> getParameters() {
        return this.parameters;
    }

    public static class Builder {
        private String name;
        private Map<String, Parameter<?>> parameters;
        private BiFunction<MethodComponent, MethodComponentContext, Map<String, Object>> mapGenerator;
        private TriFunction<MethodComponent, MethodComponentContext, Integer, Long> overheadInKBEstimator;
        private boolean requiresTraining;

        public static Builder builder(String name) {
            return new Builder(name);
        }

        private Builder(String name) {
            this.name = name;
            this.parameters = new HashMap();
            this.mapGenerator = null;
            this.overheadInKBEstimator = (mc, mcc, d) -> 0L;
        }

        public Builder addParameter(String parameterName, Parameter<?> parameter) {
            this.parameters.put(parameterName, parameter);
            return this;
        }

        public Builder setMapGenerator(BiFunction<MethodComponent, MethodComponentContext, Map<String, Object>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            return this;
        }

        public Builder setRequiresTraining(boolean requiresTraining) {
            this.requiresTraining = requiresTraining;
            return this;
        }

        public Builder setOverheadInKBEstimator(TriFunction<MethodComponent, MethodComponentContext, Integer, Long> overheadInKBEstimator) {
            this.overheadInKBEstimator = overheadInKBEstimator;
            return this;
        }

        public MethodComponent build() {
            return new MethodComponent(this);
        }
    }
}

