/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions.configs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.ThresholdConfig;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.core.Config;
import org.opensearch.performanceanalyzer.rca.framework.core.NestedConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class QueueActionConfig {
    private static final Logger LOG = LogManager.getLogger(QueueActionConfig.class);
    private NestedConfig queueSettingsConfig;
    private SearchQueueConfig searchQueueConfig;
    private WriteQueueConfig writeQueueConfig;
    private Config<Integer> totalStepCount;
    private Map<ResourceEnum, ThresholdConfig<Integer>> thresholdConfigMap;
    private static final String TOTAL_STEP_COUNT_CONFIG_NAME = "total-step-count";
    public static final int DEFAULT_TOTAL_STEP_COUNT = 20;
    public static final int DEFAULT_SEARCH_QUEUE_UPPER_BOUND = 3000;
    public static final int DEFAULT_SEARCH_QUEUE_LOWER_BOUND = 1000;
    public static final int DEFAULT_WRITE_QUEUE_UPPER_BOUND = 1000;
    public static final int DEFAULT_WRITE_QUEUE_LOWER_BOUND = 200;

    public QueueActionConfig(RcaConf conf) {
        Map<String, Object> actionConfig = conf.getActionConfigSettings();
        this.queueSettingsConfig = new NestedConfig("queue-settings", actionConfig);
        this.searchQueueConfig = new SearchQueueConfig(this.queueSettingsConfig);
        this.writeQueueConfig = new WriteQueueConfig(this.queueSettingsConfig);
        this.totalStepCount = new Config<Integer>(TOTAL_STEP_COUNT_CONFIG_NAME, this.queueSettingsConfig.getValue(), 20, s -> s > 0, Integer.class);
        this.createThresholdConfigMap();
    }

    public int getTotalStepCount() {
        return this.totalStepCount.getValue();
    }

    public int getStepSize(ResourceEnum threadPool) {
        ThresholdConfig<Integer> threshold = this.getThresholdConfig(threadPool);
        return (int)((double)(threshold.upperBound() - threshold.lowerBound()) / (double)this.getTotalStepCount());
    }

    public ThresholdConfig<Integer> getThresholdConfig(ResourceEnum threadPool) {
        if (!this.thresholdConfigMap.containsKey((Object)threadPool)) {
            String msg = "Threshold config requested for unknown threadpool queue: " + threadPool.toString();
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return this.thresholdConfigMap.get((Object)threadPool);
    }

    private void createThresholdConfigMap() {
        HashMap<ResourceEnum, ThresholdConfig<Integer>> configMap = new HashMap<ResourceEnum, ThresholdConfig<Integer>>();
        configMap.put(ResourceEnum.SEARCH_THREADPOOL, this.searchQueueConfig);
        configMap.put(ResourceEnum.WRITE_THREADPOOL, this.writeQueueConfig);
        this.thresholdConfigMap = Collections.unmodifiableMap(configMap);
    }

    private static class SearchQueueConfig
    implements ThresholdConfig<Integer> {
        private Config<Integer> searchQueueUpperBound;
        private Config<Integer> searchQueueLowerBound;

        public SearchQueueConfig(NestedConfig queueSettingsConfig) {
            NestedConfig searchQueueConfig = new NestedConfig("search", queueSettingsConfig.getValue());
            this.searchQueueUpperBound = new Config<Integer>("upper-bound", searchQueueConfig.getValue(), 3000, s -> s >= 0, Integer.class);
            this.searchQueueLowerBound = new Config<Integer>("lower-bound", searchQueueConfig.getValue(), 1000, s -> s >= 0, Integer.class);
        }

        @Override
        public Integer upperBound() {
            return this.searchQueueUpperBound.getValue();
        }

        @Override
        public Integer lowerBound() {
            return this.searchQueueLowerBound.getValue();
        }
    }

    private static class WriteQueueConfig
    implements ThresholdConfig<Integer> {
        private Config<Integer> writeQueueUpperBound;
        private Config<Integer> writeQueueLowerBound;

        public WriteQueueConfig(NestedConfig queueSettingsConfig) {
            NestedConfig writeQueueConfig = new NestedConfig("write", queueSettingsConfig.getValue());
            this.writeQueueUpperBound = new Config<Integer>("upper-bound", writeQueueConfig.getValue(), 1000, s -> s >= 0, Integer.class);
            this.writeQueueLowerBound = new Config<Integer>("lower-bound", writeQueueConfig.getValue(), 200, s -> s >= 0, Integer.class);
        }

        @Override
        public Integer upperBound() {
            return this.writeQueueUpperBound.getValue();
        }

        @Override
        public Integer lowerBound() {
            return this.writeQueueLowerBound.getValue();
        }
    }
}

