/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import com.headius.backport9.modules.Modules;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.addons.ArrayJavaAddons;
import org.jruby.java.addons.ClassJavaAddons;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.java.addons.KernelJavaAddons;
import org.jruby.java.addons.StringJavaAddons;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.InterfaceJavaProxy;
import org.jruby.java.proxies.JavaInterfaceTemplate;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.java.util.SystemPropertiesMap;
import org.jruby.javasupport.JavaArrayUtilities;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaPackage;
import org.jruby.javasupport.JavaProxyMethods;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.ext.JavaIo;
import org.jruby.javasupport.ext.JavaLang;
import org.jruby.javasupport.ext.JavaLangReflect;
import org.jruby.javasupport.ext.JavaMath;
import org.jruby.javasupport.ext.JavaNet;
import org.jruby.javasupport.ext.JavaNio;
import org.jruby.javasupport.ext.JavaTime;
import org.jruby.javasupport.ext.JavaUtilRegex;
import org.jruby.javasupport.ext.Kernel;
import org.jruby.javasupport.ext.Module;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.NonBlockingHashMapLong;

@JRubyModule(name={"Java"})
public class Java
implements Library {
    public static final boolean NEW_STYLE_EXTENSION = Options.JI_NEWSTYLEEXTENSION.load();
    public static final boolean OBJECT_PROXY_CACHE = Options.JI_OBJECTPROXYCACHE.load();
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z0-9_]+)([A-Z])");

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        RubyModule Java2 = Java.createJavaModule(runtime2);
        runtime2.getJavaSupport().setJavaPackageClass(JavaPackage.createJavaPackageClass(runtime2, Java2));
        Kernel.define(runtime2);
        Module.define(runtime2);
        JavaLang.define(runtime2);
        JavaLangReflect.define(runtime2);
        org.jruby.javasupport.ext.JavaUtil.define(runtime2);
        JavaUtilRegex.define(runtime2);
        JavaIo.define(runtime2);
        JavaNio.define(runtime2);
        JavaNet.define(runtime2);
        JavaMath.define(runtime2);
        JavaTime.define(runtime2);
        RubyClass objectClass = (RubyClass)Java.getProxyClass(runtime2, Object.class);
        runtime2.getLoadService().load("jruby/java.rb", false);
        RubyClass ArrayJavaProxy2 = runtime2.getClass("ArrayJavaProxy");
        ArrayJavaProxy2.setSuperClass(objectClass);
        ArrayJavaProxy2.includeModule(runtime2.getEnumerable());
        RubyClassPathVariable.createClassPathVariable(runtime2);
        Java2.setConstant("JavaClass", Java.getProxyClass(runtime2, Class.class));
        Java2.deprecateConstant(runtime2, "JavaClass");
        Java2.setConstant("JavaField", Java.getProxyClass(runtime2, Field.class));
        Java2.deprecateConstant(runtime2, "JavaField");
        Java2.setConstant("JavaMethod", Java.getProxyClass(runtime2, Method.class));
        Java2.deprecateConstant(runtime2, "JavaMethod");
        Java2.setConstant("JavaConstructor", Java.getProxyClass(runtime2, Constructor.class));
        Java2.deprecateConstant(runtime2, "JavaConstructor");
        SystemPropertiesMap systemProperties = new SystemPropertiesMap();
        RubyClass proxyClass = (RubyClass)Java.getProxyClass(runtime2, SystemPropertiesMap.class);
        runtime2.getObject().setConstantQuiet("ENV_JAVA", new MapJavaProxy(runtime2, proxyClass, systemProperties));
    }

    public static RubyModule createJavaModule(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyModule Java2 = runtime2.defineModule("Java");
        Java2.defineAnnotatedMethods(Java.class);
        JavaProxyMethods.createJavaProxyMethods(context);
        JavaProxy.createJavaProxy(context);
        ArrayJavaProxyCreator.createArrayJavaProxyCreator(context);
        RubyClass _ConcreteJavaProxy = ConcreteJavaProxy.createConcreteJavaProxy(context);
        InterfaceJavaProxy.createInterfaceJavaProxy(context);
        RubyClass _ArrayJavaProxy = ArrayJavaProxy.createArrayJavaProxy(context);
        MapJavaProxy.createMapJavaProxy(runtime2);
        JavaProxyClass.createJavaProxyClasses(runtime2, Java2);
        JavaInterfaceTemplate.createJavaInterfaceTemplateModule(context);
        runtime2.defineModule("JavaUtilities").defineAnnotatedMethods(JavaUtilities.class);
        JavaArrayUtilities.createJavaArrayUtilitiesModule(runtime2);
        runtime2.getArray().defineAnnotatedMethods(ArrayJavaAddons.class);
        runtime2.getKernel().defineAnnotatedMethods(KernelJavaAddons.class);
        runtime2.getString().defineAnnotatedMethods(StringJavaAddons.class);
        runtime2.getIO().defineAnnotatedMethods(IOJavaAddons.class);
        runtime2.getClassClass().defineAnnotatedMethods(ClassJavaAddons.class);
        if (runtime2.getObject().isConstantDefined("StringIO")) {
            ((RubyClass)runtime2.getObject().getConstant("StringIO")).defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        Java2.defineConstant("JavaObject", _ConcreteJavaProxy);
        Java2.deprecateConstant(runtime2, "JavaObject");
        Java2.defineConstant("JavaArray", _ArrayJavaProxy);
        Java2.deprecateConstant(runtime2, "JavaArray");
        return Java2;
    }

    @Deprecated
    public static IRubyObject create_proxy_class(IRubyObject self2, IRubyObject name2, IRubyObject javaClass, IRubyObject module) {
        Ruby runtime2 = self2.getRuntime();
        if (!(module instanceof RubyModule)) {
            throw runtime2.newTypeError(module, runtime2.getModule());
        }
        return Java.setProxyClass(runtime2, (RubyModule)module, name2.asJavaString(), Java.resolveJavaClassArgument(runtime2, javaClass));
    }

    public static RubyModule setProxyClass(Ruby runtime2, RubyModule target2, String constName, Class<?> javaClass) throws NameError {
        RubyModule proxyClass = Java.getProxyClass(runtime2, javaClass);
        Java.setProxyClass(runtime2, target2, constName, proxyClass, true);
        return proxyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProxyClass(Ruby runtime2, RubyModule target2, String constName, RubyModule proxyClass, boolean validateConstant) {
        if (Java.constantNotSetOrDifferent(target2, constName, proxyClass)) {
            RubyModule rubyModule = target2;
            synchronized (rubyModule) {
                if (Java.constantNotSetOrDifferent(target2, constName, proxyClass)) {
                    if (validateConstant) {
                        target2.const_set(runtime2.newSymbol(constName), proxyClass);
                    } else {
                        target2.setConstant(constName, proxyClass);
                    }
                }
            }
        }
    }

    private static boolean constantNotSetOrDifferent(RubyModule target2, String constName, RubyModule proxyClass) {
        return !target2.constDefinedAt(constName) || !proxyClass.equals(target2.getConstant(constName, false));
    }

    public static IRubyObject getInstance(Ruby runtime2, Object rawJavaObject) {
        return Java.getInstance(runtime2, rawJavaObject, false);
    }

    public static IRubyObject getInstance(Ruby runtime2, Object rawJavaObject, boolean forceCache) {
        if (rawJavaObject != null) {
            RubyClass proxyClass = (RubyClass)Java.getProxyClass(runtime2, rawJavaObject.getClass());
            if (OBJECT_PROXY_CACHE || forceCache || proxyClass.getCacheProxy()) {
                return runtime2.getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, proxyClass);
            }
            return Java.allocateProxy(rawJavaObject, proxyClass);
        }
        return runtime2.getNil();
    }

    @Deprecated
    public static RubyModule getInterfaceModule(Ruby runtime2, JavaClass javaClass) {
        return Java.getInterfaceModule(runtime2, javaClass.javaClass());
    }

    public static RubyModule getInterfaceModule(Ruby runtime2, Class javaClass) {
        return Java.getProxyClass(runtime2, javaClass);
    }

    public static RubyModule get_interface_module(Ruby runtime2, IRubyObject java_class2) {
        return Java.getInterfaceModule(runtime2, Java.resolveJavaClassArgument(runtime2, java_class2));
    }

    public static RubyModule get_proxy_class(IRubyObject self2, IRubyObject java_class2) {
        Ruby runtime2 = self2.getRuntime();
        return Java.getProxyClass(runtime2, Java.resolveJavaClassArgument(runtime2, java_class2));
    }

    private static Class<?> resolveJavaClassArgument(Ruby runtime2, IRubyObject java_class2) {
        if (java_class2 instanceof RubyString) {
            return Java.getJavaClass(runtime2, java_class2.asJavaString());
        }
        if (java_class2 instanceof JavaProxy) {
            Object obj = ((JavaProxy)java_class2).getObject();
            if (obj instanceof Class) {
                return (Class)obj;
            }
            if (obj instanceof String) {
                return Java.getJavaClass(runtime2, (String)obj);
            }
            throw runtime2.newArgumentError("expected a Java class, got " + java_class2.inspect());
        }
        throw runtime2.newArgumentError("expected a Java class (or String), got " + java_class2.inspect());
    }

    public static Class<?> unwrapClassProxy(IRubyObject self2) {
        return (Class)((JavaProxy)self2).getObject();
    }

    public static RubyClass getProxyClassForObject(Ruby runtime2, Object object) {
        return (RubyClass)Java.getProxyClass(runtime2, object.getClass());
    }

    public static Class<?> resolveClassType(ThreadContext context, IRubyObject type2) throws TypeError {
        RubyModule proxyClass = Java.resolveType(context.runtime, type2);
        if (proxyClass == null) {
            throw context.runtime.newTypeError("unable to convert to type: " + type2);
        }
        return JavaUtil.getJavaClass(proxyClass);
    }

    public static RubyModule resolveType(Ruby runtime2, IRubyObject type2) {
        Class klass;
        if (type2 instanceof RubyString || type2 instanceof RubySymbol) {
            String className = type2.toString();
            klass = Java.resolveShortClassName(className);
            if (klass == null) {
                klass = Java.getJavaClass(runtime2, className);
            }
        } else {
            klass = Java.resolveClassType(type2);
            if (klass == null) {
                throw runtime2.newTypeError("expected a Java class, got: " + type2);
            }
        }
        return Java.getProxyClass(runtime2, klass);
    }

    static Class<?> resolveClassType(IRubyObject type2) {
        if (type2 instanceof JavaProxy) {
            Object wrapped = ((JavaProxy)type2).getObject();
            if (wrapped instanceof Class) {
                return (Class)wrapped;
            }
            return null;
        }
        if (type2 instanceof RubyModule) {
            return JavaUtil.getJavaClass((RubyModule)type2, null);
        }
        return null;
    }

    private static Class resolveShortClassName(String name2) {
        switch (name2) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "Boolean": 
            case "java.lang.Boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "Byte": 
            case "java.lang.Byte": {
                return Byte.class;
            }
            case "short": {
                return Short.TYPE;
            }
            case "Short": 
            case "java.lang.Short": {
                return Short.class;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "Int": 
            case "Integer": 
            case "java.lang.Integer": {
                return Integer.class;
            }
            case "long": {
                return Long.TYPE;
            }
            case "Long": 
            case "java.lang.Long": {
                return Long.class;
            }
            case "float": {
                return Float.TYPE;
            }
            case "Float": 
            case "java.lang.Float": {
                return Float.class;
            }
            case "double": {
                return Double.TYPE;
            }
            case "Double": 
            case "java.lang.Double": {
                return Double.class;
            }
            case "char": {
                return Character.TYPE;
            }
            case "Char": 
            case "Character": 
            case "java.lang.Character": {
                return Character.class;
            }
            case "object": 
            case "Object": 
            case "java.lang.Object": {
                return Object.class;
            }
            case "string": 
            case "String": 
            case "java.lang.String": {
                return String.class;
            }
            case "big_int": 
            case "big_integer": 
            case "BigInteger": {
                return BigInteger.class;
            }
            case "big_decimal": 
            case "BigDecimal": {
                return BigDecimal.class;
            }
            case "void": {
                return Void.TYPE;
            }
            case "Void": {
                return Void.class;
            }
        }
        return null;
    }

    @Deprecated
    public static RubyModule getProxyClass(Ruby runtime2, JavaClass javaClass) {
        return Java.getProxyClass(runtime2, javaClass.javaClass());
    }

    public static RubyModule getProxyClass(Ruby runtime2, Class<?> clazz) {
        return Java.getProxyClass(runtime2, clazz, Options.JI_EAGER_CONSTANTS.load());
    }

    public static RubyModule getProxyClass(Ruby runtime2, Class<?> clazz, boolean setConstant) {
        RubyModule proxy2 = runtime2.getJavaSupport().getUnfinishedProxy(clazz);
        if (proxy2 != null) {
            return proxy2;
        }
        return runtime2.getJavaSupport().getProxyClassFromCache(clazz, setConstant);
    }

    public static boolean isProxyType(RubyModule proxy2) {
        return JavaUtil.getJavaClass(proxy2, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RubyModule createProxyClassForClass(Ruby runtime2, Class<?> clazz) {
        RubyModule proxy2;
        JavaSupport javaSupport = runtime2.getJavaSupport();
        RubyClass superClass = null;
        if (clazz.isInterface()) {
            proxy2 = (RubyModule)runtime2.getJavaSupport().getJavaInterfaceTemplate().dup();
        } else {
            superClass = clazz.isArray() ? javaSupport.getArrayProxyClass() : (clazz.isPrimitive() ? javaSupport.getConcreteProxyClass() : (clazz == Object.class ? javaSupport.getConcreteProxyClass() : (RubyClass)Java.getProxyClass(runtime2, clazz.getSuperclass())));
            proxy2 = RubyClass.newClass(runtime2, superClass);
        }
        javaSupport.beginProxy(clazz, proxy2);
        try {
            if (clazz.isInterface()) {
                Java.generateInterfaceProxy(runtime2, clazz, proxy2);
            } else {
                Java.generateClassProxy(runtime2, clazz, (RubyClass)proxy2, superClass);
            }
        }
        finally {
            javaSupport.endProxy(clazz);
        }
        return proxy2;
    }

    private static void generateInterfaceProxy(Ruby runtime2, Class javaClass, RubyModule proxy2) {
        assert (javaClass.isInterface());
        Class<?>[] extended2 = javaClass.getInterfaces();
        int i2 = extended2.length;
        while (--i2 >= 0) {
            RubyModule extModule = Java.getInterfaceModule(runtime2, extended2[i2]);
            proxy2.includeModule(extModule);
        }
        Initializer.setupProxyModule(runtime2, javaClass, proxy2);
    }

    private static void generateClassProxy(Ruby runtime2, Class<?> clazz, RubyClass proxy2, RubyClass superClass) {
        if (clazz.isArray()) {
            Java.createProxyClass(runtime2, proxy2, clazz, superClass, true);
            if (clazz.getComponentType() == Byte.TYPE) {
                proxy2.defineAnnotatedMethods(ByteArrayProxyMethods.class);
            }
        } else if (clazz.isPrimitive()) {
            Java.createProxyClass(runtime2, proxy2, clazz, superClass, true);
        } else if (clazz == Object.class) {
            Java.createProxyClass(runtime2, proxy2, clazz, superClass, true);
            if (NEW_STYLE_EXTENSION) {
                proxy2.getMetaClass().defineAnnotatedMethods(NewStyleExtensionInherited.class);
            } else {
                proxy2.getMetaClass().defineAnnotatedMethods(OldStyleExtensionInherited.class);
            }
        } else {
            Java.createProxyClass(runtime2, proxy2, clazz, superClass, false);
            Class<?>[] interfaces2 = clazz.getInterfaces();
            int i2 = interfaces2.length;
            while (--i2 >= 0) {
                proxy2.includeModule(Java.getInterfaceModule(runtime2, interfaces2[i2]));
            }
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            final String clazzName = clazz.getCanonicalName();
            proxy2.getMetaClass().addMethod("inherited", new JavaMethod((RubyModule)proxy2, Visibility.PUBLIC, "inherited"){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    throw context.runtime.newTypeError("can not extend final Java class: " + clazzName);
                }
            });
        }
    }

    private static RubyClass createProxyClass(Ruby runtime2, RubyClass proxyClass, Class<?> javaClass, RubyClass superClass, boolean invokeInherited) {
        proxyClass.makeMetaClass(superClass.getMetaClass());
        if (Map.class.isAssignableFrom(javaClass)) {
            proxyClass.setAllocator(runtime2.getJavaSupport().getMapJavaProxyClass().getAllocator());
            proxyClass.defineAnnotatedMethods(MapJavaProxy.class);
            proxyClass.includeModule(runtime2.getEnumerable());
        } else {
            proxyClass.setAllocator(superClass.getAllocator());
        }
        proxyClass.defineAnnotatedMethods(JavaProxy.ClassMethods.class);
        if (invokeInherited) {
            proxyClass.inherit(superClass);
        }
        Initializer.setupProxyClass(runtime2, javaClass, proxyClass);
        return proxyClass;
    }

    @Deprecated
    public static IRubyObject concrete_proxy_inherited(IRubyObject clazz, IRubyObject subclazz) {
        return Java.invokeProxyClassInherited(clazz.getRuntime().getCurrentContext(), clazz, subclazz);
    }

    private static IRubyObject invokeProxyClassInherited(ThreadContext context, IRubyObject clazz, IRubyObject subclazz) {
        JavaSupport javaSupport = context.runtime.getJavaSupport();
        RubyClass javaProxyClass = javaSupport.getJavaProxyClass().getMetaClass();
        Helpers.invokeAs(context, javaProxyClass, clazz, "inherited", subclazz, Block.NULL_BLOCK);
        if (!(subclazz instanceof RubyClass)) {
            throw context.runtime.newTypeError(subclazz, context.runtime.getClassClass());
        }
        Java.setupJavaSubclass(context, (RubyClass)subclazz);
        return context.nil;
    }

    private static void setupJavaSubclass(ThreadContext context, RubyClass subclass) {
        subclass.setInstanceVariable("@java_proxy_class", context.nil);
        subclass.setCacheProxy(true);
        RubyClass subclassSingleton = subclass.getSingletonClass();
        subclassSingleton.addReadAttribute(context, "java_proxy_class");
        subclassSingleton.addMethod("java_interfaces", new JavaMethod.JavaMethodZero((RubyModule)subclassSingleton, Visibility.PUBLIC, "java_interfaces"){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                IRubyObject javaInterfaces = self2.getInstanceVariables().getInstanceVariable("@java_interfaces");
                if (javaInterfaces != null) {
                    return javaInterfaces.dup();
                }
                return context.nil;
            }
        });
        subclass.addMethod("__jcreate!", new JCreateMethod(subclassSingleton));
    }

    static <T extends ParameterTypes> ArrayList<T> findCallablesForArity(int arity2, T[] callables) {
        ArrayList<ParameterTypes> forArity = new ArrayList<ParameterTypes>(callables.length);
        for (int i2 = 0; i2 < callables.length; ++i2) {
            ParameterTypes found = Java.checkCallableForArity((int)arity2, callables, (int)i2);
            if (found == null) continue;
            forArity.add(found);
        }
        return forArity;
    }

    private static <T extends ParameterTypes> T checkCallableForArity(int arity2, T[] callables, int index2) {
        T callable = callables[index2];
        int callableArity = callable.getArity();
        if (callableArity == arity2) {
            return callable;
        }
        if (callable.isVarArgs() && callableArity - 1 <= arity2) {
            return callable;
        }
        return null;
    }

    static void addToJavaPackageModule(Ruby runtime2, Class<?> clazz, RubyModule proxyClass) {
        String className;
        String fullName = clazz.getName();
        if (fullName == null) {
            return;
        }
        if (fullName.indexOf(36) != -1) {
            return;
        }
        int endPackage = fullName.lastIndexOf(46);
        String packageString = endPackage < 0 ? "" : fullName.substring(0, endPackage);
        RubyModule parentModule = Java.getJavaPackageModule(runtime2, packageString);
        String string2 = className = parentModule == null ? fullName : fullName.substring(endPackage + 1);
        if (parentModule != null && (IdUtil.isConstant(className) || parentModule instanceof JavaPackage)) {
            Java.setProxyClass(runtime2, parentModule, className, proxyClass, false);
        }
    }

    public static RubyModule getJavaPackageModule(Ruby runtime2, Package pkg) {
        return Java.getJavaPackageModule(runtime2, pkg == null ? "" : pkg.getName());
    }

    public static RubyModule getJavaPackageModule(Ruby runtime2, String packageString) {
        String packageName;
        int length2 = packageString.length();
        if (length2 == 0) {
            packageName = "Default";
        } else {
            StringBuilder name2 = new StringBuilder(length2);
            int start2 = 0;
            while (start2 < length2) {
                int offset2 = packageString.indexOf(46, start2);
                if (offset2 == -1) {
                    offset2 = length2;
                }
                name2.append(Character.toUpperCase(packageString.charAt(start2))).append(packageString.substring(start2 + 1, offset2));
                start2 = offset2 + 1;
            }
            packageName = name2.toString();
        }
        RubyModule javaModule = runtime2.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(packageName);
        if (packageModule == null) {
            return Java.createPackageModule(runtime2, javaModule, packageName, packageString);
        }
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyModule createPackageModule(Ruby runtime2, RubyModule parentModule, String name2, String packageString) {
        RubyModule packageModule = JavaPackage.newPackage(runtime2, packageString, parentModule);
        RubyModule rubyModule = parentModule;
        synchronized (rubyModule) {
            IRubyObject packageAlreadySet = parentModule.fetchConstant(name2);
            if (packageAlreadySet != null) {
                return (RubyModule)packageAlreadySet;
            }
            parentModule.setConstant(name2.intern(), packageModule);
        }
        return packageModule;
    }

    private static RubyModule getPackageModule(Ruby runtime2, String name2) {
        String packageName;
        RubyModule javaModule = runtime2.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(name2);
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        if ("Default".equals(name2)) {
            packageName = "";
        } else {
            Matcher match2 = CAMEL_CASE_PACKAGE_SPLITTER.matcher(name2);
            packageName = match2.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(runtime2, javaModule, name2, packageName);
    }

    public static RubyModule get_package_module(IRubyObject self2, IRubyObject name2) {
        return Java.getPackageModule(self2.getRuntime(), name2.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject self2, IRubyObject dottedName) {
        Ruby runtime2 = self2.getRuntime();
        RubyModule module = Java.getJavaPackageModule(runtime2, dottedName.asJavaString());
        return module == null ? runtime2.getNil() : module;
    }

    static RubyModule getProxyOrPackageUnderPackage(ThreadContext context, RubyModule parentPackage, String name2, boolean cacheMethod) {
        RubyModule result2;
        block13: {
            Ruby runtime2 = context.runtime;
            if (name2.length() == 0) {
                throw runtime2.newArgumentError("empty class or package name");
            }
            String fullName = JavaPackage.buildPackageName(parentPackage, name2).toString();
            if (!Character.isUpperCase(name2.charAt(0))) {
                Java.checkJavaReservedNames(runtime2, name2, false);
                RubyModule proxyClass = Java.getProxyClassOrNull(runtime2, fullName);
                if (proxyClass != null) {
                    result2 = proxyClass;
                } else {
                    RubyModule packageModule = Java.getJavaPackageModule(runtime2, fullName);
                    if (packageModule == null) {
                        return null;
                    }
                    result2 = packageModule;
                }
            } else {
                try {
                    RubyModule javaClass = Java.getProxyClassOrNull(runtime2, fullName);
                    if (javaClass != null) {
                        result2 = javaClass;
                        break block13;
                    }
                    if (Java.allowUppercasePackageNames(runtime2)) {
                        result2 = Java.getJavaPackageModule(runtime2, fullName);
                        if (result2 == null) {
                            throw runtime2.newNameError("missing class (or package) name " + fullName, fullName);
                        }
                        break block13;
                    }
                    throw runtime2.newNameError("missing class name " + fullName, fullName);
                }
                catch (RuntimeException e) {
                    if (e instanceof RaiseException) {
                        throw e;
                    }
                    throw Java.initCause(runtime2.newNameError("missing class or uppercase package name " + fullName + " (" + e + ')', fullName, e), e);
                }
            }
        }
        if (cacheMethod) {
            Java.bindJavaPackageOrClassMethod(parentPackage, name2, result2);
        }
        return result2;
    }

    private static boolean allowUppercasePackageNames(Ruby runtime2) {
        return runtime2.getInstanceConfig().getAllowUppercasePackageNames();
    }

    private static void checkJavaReservedNames(Ruby runtime2, String name2, boolean allowPrimitives) {
        if (!allowPrimitives && Java.isPrimitiveClassName(name2)) {
            throw runtime2.newArgumentError("illegal package name component: " + name2);
        }
    }

    private static boolean isPrimitiveClassName(String name2) {
        return JavaUtil.getPrimitiveClass(name2) != null;
    }

    public static Class getJavaClass(Ruby runtime2, String className) throws RaiseException {
        return Java.getJavaClass(runtime2, className, true);
    }

    public static Class getJavaClass(Ruby runtime2, String className, boolean initialize2) throws RaiseException {
        try {
            return Java.loadJavaClass(runtime2, className, initialize2);
        }
        catch (ClassNotFoundException ex) {
            throw Java.initCause(runtime2.newNameError("Java class " + className + " not found", className, ex), ex);
        }
    }

    public static Class loadJavaClass(Ruby runtime2, String className) throws ClassNotFoundException, RaiseException {
        return Java.loadJavaClass(runtime2, className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class loadJavaClass(Ruby runtime2, String className, boolean initialize2) throws ClassNotFoundException, RaiseException {
        try {
            Class<Java> clazz = Java.class;
            synchronized (Java.class) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return runtime2.getJavaSupport().loadJavaClass(className, initialize2);
            }
        }
        catch (ExceptionInInitializerError ex) {
            throw Java.initCause(runtime2.newNameError("cannot initialize Java class " + className + ' ' + '(' + ex + ')', className, ex), ex);
        }
        catch (UnsupportedClassVersionError ex) {
            String msg = Java.getJavaVersionErrorMessage(ex);
            throw Java.initCause(runtime2.newNameError("cannot link Java class " + className + ' ' + msg, className, ex), ex);
        }
        catch (LinkageError ex) {
            throw Java.initCause(runtime2.newNameError("cannot link Java class " + className + ' ' + '(' + ex + ')', className, ex), ex);
        }
        catch (SecurityException ex) {
            throw Java.initCause(runtime2.newSecurityError(ex.getLocalizedMessage()), ex);
        }
    }

    private static String getJavaVersionErrorMessage(UnsupportedClassVersionError ex) {
        String type2 = ex.getClass().getName();
        String msg = ex.getLocalizedMessage();
        if (msg != null) {
            String unMajorMinorVersion = "unsupported major.minor version";
            int idx = msg.indexOf("unsupported major.minor version");
            if (idx > 0) {
                idx += "unsupported major.minor version".length();
                msg = (idx = Java.mapMajorMinorClassVersionToJavaVersion(msg, idx)) > 0 ? "needs Java " + idx + " (" + type2 + ": " + msg + ')' : '(' + type2 + ": " + msg + ')';
            }
        } else {
            msg = '(' + type2 + ')';
        }
        return msg;
    }

    static RaiseException initCause(RaiseException ex, Throwable cause2) {
        ex.initCause(cause2);
        return ex;
    }

    private static RubyModule getProxyClassOrNull(Ruby runtime2, String className) {
        Class clazz;
        try {
            clazz = Java.loadJavaClass(runtime2, className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return Java.getProxyClass(runtime2, clazz, true);
    }

    private static int mapMajorMinorClassVersionToJavaVersion(String msg, int offset2) {
        int end2 = msg.indexOf(46, offset2);
        if (end2 == -1) {
            end2 = msg.length();
        }
        msg = msg.substring(offset2, end2).trim();
        try {
            return Integer.parseInt(msg) - 50 + 6;
        }
        catch (RuntimeException ignore) {
            return 0;
        }
    }

    public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject self2, IRubyObject parentPackage, IRubyObject name2) {
        Ruby runtime2 = context.runtime;
        if (!(parentPackage instanceof RubyModule)) {
            throw runtime2.newTypeError(parentPackage, runtime2.getModule());
        }
        RubyModule result2 = Java.getProxyOrPackageUnderPackage(context, (RubyModule)parentPackage, name2.asJavaString(), true);
        return result2 != null ? result2 : context.nil;
    }

    private static RubyModule getTopLevelProxyOrPackage(Ruby runtime2, String name2, boolean cacheMethod) {
        RubyModule result2;
        if (name2.length() == 0) {
            throw runtime2.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(name2.charAt(0))) {
            RubyModule proxyClass = Java.getProxyClassOrNull(runtime2, name2);
            if (proxyClass != null) {
                result2 = proxyClass;
            } else {
                Java.checkJavaReservedNames(runtime2, name2, true);
                RubyModule packageModule = Java.getJavaPackageModule(runtime2, name2);
                if (packageModule == null) {
                    return null;
                }
                result2 = packageModule;
            }
        } else {
            RubyModule javaClass = Java.getProxyClassOrNull(runtime2, name2);
            result2 = javaClass != null ? javaClass : Java.getPackageModule(runtime2, name2);
        }
        if (cacheMethod) {
            Java.bindJavaPackageOrClassMethod(runtime2, name2, result2);
        }
        return result2;
    }

    private static boolean bindJavaPackageOrClassMethod(Ruby runtime2, String name2, RubyModule packageOrClass) {
        RubyModule javaPackage = runtime2.getJavaSupport().getJavaModule();
        return Java.bindJavaPackageOrClassMethod(javaPackage, name2, packageOrClass);
    }

    private static boolean bindJavaPackageOrClassMethod(RubyModule parentPackage, String name2, RubyModule packageOrClass) {
        if (parentPackage.getMetaClass().isMethodBound(name2, false)) {
            return false;
        }
        RubyClass singleton = parentPackage.getSingletonClass();
        singleton.addMethod(name2.intern(), new JavaAccessor(singleton, packageOrClass, parentPackage, name2));
        return true;
    }

    private static RubyModule getProxyUnderClass(ThreadContext context, RubyModule enclosingClass, String name2) {
        Ruby runtime2 = context.runtime;
        if (name2.length() == 0) {
            throw runtime2.newArgumentError("empty class name");
        }
        Class<?> enclosing = JavaUtil.getJavaClass(enclosingClass, null);
        if (enclosing == null) {
            return null;
        }
        String fullName = enclosing.getName() + '$' + name2;
        RubyModule result2 = Java.getProxyClassOrNull(runtime2, fullName);
        return result2;
    }

    public static IRubyObject get_inner_class(ThreadContext context, RubyModule self2, IRubyObject name2) {
        String constName = name2.asJavaString();
        RubyModule innerClass = Java.getProxyUnderClass(context, self2, constName);
        if (innerClass == null) {
            return Helpers.invokeSuper(context, (IRubyObject)self2, name2, Block.NULL_BLOCK);
        }
        return Java.cacheConstant(self2, constName, innerClass, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject const_missing(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        Ruby runtime2 = context.runtime;
        String constName = name2.asJavaString();
        RubyModule packageOrClass = Java.getTopLevelProxyOrPackage(runtime2, constName, false);
        if (packageOrClass == null) {
            return context.nil;
        }
        return Java.cacheConstant((RubyModule)self2, constName, packageOrClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyModule cacheConstant(RubyModule owner2, String constName, RubyModule packageOrClass, boolean hidden) {
        if (packageOrClass != null) {
            RubyModule rubyModule = owner2;
            synchronized (rubyModule) {
                IRubyObject alreadySet = owner2.fetchConstant(constName);
                if (alreadySet != null) {
                    return (RubyModule)alreadySet;
                }
                owner2.setConstant(constName, packageOrClass, hidden);
            }
            return packageOrClass;
        }
        return null;
    }

    @JRubyMethod(name={"method_missing"}, meta=true, required=1)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        RubyModule result2 = Java.getTopLevelProxyOrPackage(context.runtime, name2.asJavaString(), true);
        if (result2 != null) {
            return result2;
        }
        return context.nil;
    }

    @JRubyMethod(name={"method_missing"}, meta=true, rest=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        IRubyObject name2 = args2[0];
        if (args2.length > 1) {
            int count2 = args2.length - 1;
            throw context.runtime.newArgumentError("Java does not have a method `" + name2 + "' with " + count2 + " arguments");
        }
        return Java.method_missing(context, self2, name2);
    }

    public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        RubyModule result2 = Java.getTopLevelProxyOrPackage(context.runtime, name2.asJavaString(), true);
        return result2 != null ? result2 : context.nil;
    }

    @Deprecated
    public static IRubyObject wrap(Ruby runtime2, IRubyObject java_object2) {
        return Java.getInstance(runtime2, ((JavaObject)java_object2).getValue());
    }

    @Deprecated
    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        try {
            return JavaUtil.java_to_ruby(recv2.getRuntime(), object);
        }
        catch (RuntimeException e) {
            recv2.getRuntime().getJavaSupport().handleNativeException(e, null);
            return recv2.getRuntime().getNil();
        }
    }

    @Deprecated
    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.ruby_to_java(recv2, object, unusedBlock);
    }

    @Deprecated
    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.java_to_primitive(recv2, object, unusedBlock);
    }

    @JRubyMethod(required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance2(IRubyObject recv2, IRubyObject wrapper, IRubyObject interfaces2, Block block) {
        IRubyObject[] javaClasses = ((RubyArray)interfaces2).toJavaArray();
        Class[] unwrapped = new Class[javaClasses.length];
        for (int i2 = 0; i2 < javaClasses.length; ++i2) {
            Class klass = (Class)JavaUtil.unwrapJava(javaClasses[i2]);
            if (!klass.isInterface()) {
                throw recv2.getRuntime().newArgumentError("Java interface expected, got: " + klass);
            }
            unwrapped[i2] = klass;
        }
        return Java.getInstance(recv2.getRuntime(), Java.newInterfaceImpl(wrapper, unwrapped));
    }

    public static Object newInterfaceImpl(IRubyObject wrapper, Class[] interfaces2) {
        Class proxyImplClass;
        ClassLoader classLoader;
        Ruby runtime2 = wrapper.getRuntime();
        int length2 = interfaces2.length;
        switch (length2) {
            case 1: {
                interfaces2 = new Class[]{interfaces2[0], RubyObjectHolderProxy.class};
            }
            case 2: {
                interfaces2 = new Class[]{interfaces2[0], interfaces2[1], RubyObjectHolderProxy.class};
            }
        }
        interfaces2 = ArraySupport.newCopy(interfaces2, length2 + 1);
        interfaces2[length2] = RubyObjectHolderProxy.class;
        RubyClass wrapperClass = wrapper.getMetaClass();
        boolean isProc = wrapperClass.isSingleton() && wrapperClass.getRealClass() == runtime2.getProc();
        JRubyClassLoader jrubyClassLoader = runtime2.getJRubyClassLoader();
        if (RubyInstanceConfig.INTERFACES_USE_PROXY) {
            return Java.newProxyInterfaceImpl(wrapper, interfaces2, jrubyClassLoader);
        }
        int interfacesHashCode = Java.interfacesHashCode(interfaces2);
        if (isProc) {
            interfacesHashCode = 31 * interfacesHashCode + runtime2.getProc().hashCode();
            classLoader = jrubyClassLoader;
        } else {
            interfacesHashCode = 31 * interfacesHashCode + wrapperClass.getRealClass().hashCode();
            classLoader = new OneShotClassLoader(jrubyClassLoader);
        }
        String implClassName = "org.jruby.gen.InterfaceImpl" + Math.abs(interfacesHashCode);
        try {
            proxyImplClass = Class.forName(implClassName, true, jrubyClassLoader);
        }
        catch (ClassNotFoundException ex) {
            proxyImplClass = RealClassGenerator.createOldStyleImplClass(interfaces2, wrapperClass, runtime2, implClassName, classLoader);
        }
        try {
            Constructor proxyConstructor = proxyImplClass.getConstructor(IRubyObject.class);
            return proxyConstructor.newInstance(wrapper);
        }
        catch (InvocationTargetException e) {
            throw Java.mapGeneratedProxyException(runtime2, e);
        }
        catch (ReflectiveOperationException e) {
            throw Java.mapGeneratedProxyException(runtime2, e);
        }
    }

    private static Object newProxyInterfaceImpl(IRubyObject wrapper, Class[] interfaces2, ClassLoader loader) {
        return Proxy.newProxyInstance(loader, interfaces2, (InvocationHandler)new InterfaceProxyHandler(wrapper, interfaces2));
    }

    public static Class generateRealClass(RubyClass clazz) {
        Class proxyImplClass;
        block3: {
            Ruby runtime2 = clazz.getRuntime();
            Class[] interfaces2 = Java.getInterfacesFromRubyClass(clazz);
            int interfacesHashCode = Java.interfacesHashCode(interfaces2);
            interfacesHashCode = 31 * interfacesHashCode + clazz.hashCode();
            String implClassName = "org.jruby.gen.";
            implClassName = clazz.getBaseName() == null ? implClassName + "Class0x" + Integer.toHexString(System.identityHashCode(clazz)) + '_' + Math.abs(interfacesHashCode) : implClassName + StringSupport.replaceAll(clazz.getName(), "::", "$$").toString() + '_' + Math.abs(interfacesHashCode);
            try {
                proxyImplClass = Class.forName(implClassName, true, runtime2.getJRubyClassLoader());
            }
            catch (ClassNotFoundException ex) {
                Class<Object> superClass = clazz.getSuperClass().getRealClass().getReifiedClass();
                if (superClass == null) {
                    superClass = RubyObject.class;
                }
                proxyImplClass = RealClassGenerator.createRealImplClass(superClass, interfaces2, clazz, runtime2, implClassName);
                if (!NEW_STYLE_EXTENSION || RubyBasicObject.class.isAssignableFrom(proxyImplClass) || clazz.getMethods().containsKey("initialize")) break block3;
                clazz.addMethod("initialize", new DummyInitialize(clazz));
            }
        }
        clazz.setReifiedClass(proxyImplClass);
        clazz.setRubyClassAllocator(proxyImplClass);
        return proxyImplClass;
    }

    public static Constructor<? extends IRubyObject> getRealClassConstructor(Ruby runtime2, Class<? extends IRubyObject> proxyImplClass) {
        try {
            return proxyImplClass.getConstructor(Ruby.class, RubyClass.class);
        }
        catch (NoSuchMethodException e) {
            throw Java.mapGeneratedProxyException(runtime2, e);
        }
    }

    public static IRubyObject constructProxy(Ruby runtime2, Constructor<? extends IRubyObject> proxyConstructor, RubyClass clazz) {
        try {
            return proxyConstructor.newInstance(runtime2, clazz);
        }
        catch (InvocationTargetException e) {
            throw Java.mapGeneratedProxyException(runtime2, e);
        }
        catch (ReflectiveOperationException e) {
            throw Java.mapGeneratedProxyException(runtime2, e);
        }
    }

    private static RaiseException mapGeneratedProxyException(Ruby runtime2, ReflectiveOperationException e) {
        RaiseException ex = runtime2.newTypeError("Exception instantiating generated interface impl:\n" + e);
        ex.initCause(e);
        return ex;
    }

    private static RaiseException mapGeneratedProxyException(Ruby runtime2, InvocationTargetException e) {
        RaiseException ex = runtime2.newTypeError("Exception instantiating generated interface impl:\n" + e.getTargetException());
        ex.initCause(e);
        return ex;
    }

    public static IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
        Ruby runtime2 = clazz.getRuntime();
        if (clazz.getSuperClass() == runtime2.getJavaSupport().getArrayProxyClass()) {
            return new ArrayJavaProxy(runtime2, clazz, javaObject, JavaUtil.getJavaConverter(javaObject.getClass().getComponentType()));
        }
        IRubyObject proxy2 = clazz.allocate();
        if (proxy2 instanceof JavaProxy) {
            ((JavaProxy)proxy2).setObject(javaObject);
        } else {
            proxy2.dataWrapStruct(new JavaProxy(runtime2, clazz, javaObject));
        }
        return proxy2;
    }

    public static IRubyObject wrapJavaObject(Ruby runtime2, Object object) {
        return Java.allocateProxy(object, Java.getProxyClassForObject(runtime2, object));
    }

    public static Class[] getInterfacesFromRubyClass(RubyClass klass) {
        HashSet interfaces2 = new HashSet();
        while (klass != null) {
            IRubyObject maybeInterfaces = klass.getInstanceVariables().getInstanceVariable("@java_interfaces");
            if (maybeInterfaces instanceof RubyArray) {
                RubyArray moreInterfaces = (RubyArray)maybeInterfaces;
                if (!moreInterfaces.isFrozen()) {
                    moreInterfaces.setFrozen(true);
                }
                interfaces2.addAll(moreInterfaces);
            }
            klass = klass.getSuperClass();
        }
        return interfaces2.toArray(new Class[interfaces2.size()]);
    }

    private static int interfacesHashCode(Class[] a) {
        if (a == null) {
            return 0;
        }
        int result2 = 1;
        for (Class element : a) {
            result2 = 31 * result2 + (element == null ? 0 : element.hashCode());
        }
        return result2;
    }

    public static Method getFunctionalInterfaceMethod(Class<?> iface) {
        assert (iface.isInterface());
        Method single = null;
        for (Method method2 : iface.getMethods()) {
            int mod = method2.getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isAbstract(mod)) continue;
            try {
                Object.class.getMethod(method2.getName(), method2.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (single == null) {
                single = method2;
                continue;
            }
            return null;
        }
        return single;
    }

    public static <T extends AccessibleObject> boolean trySetAccessible(T member) {
        return Modules.trySetAccessible(member, Java.class);
    }

    public static <T extends AccessibleObject> boolean isAccessible(T member) {
        return Modules.isAccessible(member, Java.class);
    }

    private static final class DummyInitialize
    extends JavaMethod.JavaMethodZero {
        DummyInitialize(RubyClass clazz) {
            super((RubyModule)clazz, Visibility.PRIVATE, "initialize");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return context.nil;
        }
    }

    private static final class InterfaceProxyHandler
    implements InvocationHandler {
        final IRubyObject wrapper;
        private final String[] ifaceNames;
        private Map<Method, Class[]> parameterTypeCache;

        InterfaceProxyHandler(IRubyObject wrapper, Class[] interfaces2) {
            this.wrapper = wrapper;
            this.ifaceNames = new String[interfaces2.length];
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                this.ifaceNames[i2] = interfaces2[i2].getName();
            }
            Arrays.sort(this.ifaceNames);
        }

        @Override
        public Object invoke(Object proxy2, Method method2, Object[] nargs) throws Throwable {
            String methodName = method2.getName();
            int length2 = nargs == null ? 0 : nargs.length;
            switch (methodName) {
                case "toString": {
                    if (length2 != 0 || this.wrapper.respondsTo("toString")) break;
                    return this.proxyToString(proxy2);
                }
                case "hashCode": {
                    if (length2 != 0 || this.wrapper.respondsTo("hashCode")) break;
                    return this.proxyHashCode(proxy2);
                }
                case "equals": {
                    Class[] parameterTypes;
                    if (length2 != 1 || this.wrapper.respondsTo("equals") || (parameterTypes = this.getParameterTypes(method2))[0] != Object.class) break;
                    return this.proxyEquals(proxy2, nargs[0]);
                }
                case "__ruby_object": {
                    if (length2 != 0) break;
                    return this.wrapper;
                }
            }
            Ruby runtime2 = this.wrapper.getRuntime();
            ThreadContext context = runtime2.getCurrentContext();
            switch (length2) {
                case 0: {
                    return Helpers.invoke(context, this.wrapper, methodName).toJava(method2.getReturnType());
                }
                case 1: {
                    IRubyObject arg2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, nargs[0]);
                    return Helpers.invoke(context, this.wrapper, methodName, arg2).toJava(method2.getReturnType());
                }
            }
            IRubyObject[] args2 = JavaUtil.convertJavaArrayToRuby(runtime2, nargs);
            return Helpers.invoke(context, this.wrapper, methodName, args2).toJava(method2.getReturnType());
        }

        final String proxyToString(Object proxy2) {
            return proxy2.getClass().getName() + '{' + this + '}';
        }

        final boolean proxyEquals(Object proxy2, Object otherProxy) {
            InvocationHandler other;
            if (proxy2 == otherProxy) {
                return true;
            }
            if (otherProxy == null) {
                return false;
            }
            if (Proxy.isProxyClass(otherProxy.getClass()) && (other = Proxy.getInvocationHandler(otherProxy)) instanceof InterfaceProxyHandler) {
                InterfaceProxyHandler that = (InterfaceProxyHandler)other;
                if (this.wrapper != that.wrapper) {
                    return false;
                }
                return Arrays.equals(this.ifaceNames, that.ifaceNames);
            }
            return false;
        }

        final int proxyHashCode(Object proxy2) {
            int hash2 = 11 * this.wrapper.hashCode();
            for (String iface : this.ifaceNames) {
                hash2 = 31 * hash2 + iface.hashCode();
            }
            return hash2;
        }

        private Class[] getParameterTypes(Method method2) {
            Class[] parameterTypes;
            Map<Method, Class[]> parameterTypeCache = this.parameterTypeCache;
            if (parameterTypeCache == null) {
                this.parameterTypeCache = parameterTypeCache = new ConcurrentHashMap<Method, Class[]>(4);
            }
            if ((parameterTypes = parameterTypeCache.get(method2)) == null) {
                parameterTypes = method2.getParameterTypes();
                parameterTypeCache.put(method2, parameterTypes);
            }
            return parameterTypes;
        }
    }

    static final class ProcToInterface
    extends DynamicMethod {
        ProcToInterface(RubyClass singletonClass) {
            super((RubyModule)singletonClass, Visibility.PUBLIC, "call");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            IRubyObject[] newArgs;
            switch (args2.length) {
                case 1: {
                    newArgs = IRubyObject.NULL_ARRAY;
                    break;
                }
                case 2: {
                    newArgs = new IRubyObject[]{args2[1]};
                    break;
                }
                case 3: {
                    newArgs = new IRubyObject[]{args2[1], args2[2]};
                    break;
                }
                default: {
                    newArgs = new IRubyObject[args2.length - 1];
                    System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
                }
            }
            return ProcToInterface.callProc(context, self2, newArgs);
        }

        private static IRubyObject callProc(ThreadContext context, IRubyObject self2, IRubyObject[] procArgs) {
            if (!(self2 instanceof RubyProc)) {
                throw context.runtime.newTypeError("interface impl method_missing for block used with non-Proc object");
            }
            return ((RubyProc)self2).call(context, procArgs);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }

        final ConcreteMethod getConcreteMethod(String name2) {
            return new ConcreteMethod(name2);
        }

        final class ConcreteMethod
        extends JavaMethod {
            ConcreteMethod(String name2) {
                super(ProcToInterface.this.implementationClass, Visibility.PUBLIC, name2);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
                return ProcToInterface.callProc(context, self2, IRubyObject.NULL_ARRAY);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
                return ProcToInterface.callProc(context, self2, new IRubyObject[]{arg0});
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
                return ProcToInterface.callProc(context, self2, new IRubyObject[]{arg0, arg1});
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
                return ProcToInterface.callProc(context, self2, new IRubyObject[]{arg0, arg1, arg2});
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
                return ProcToInterface.callProc(context, self2, args2);
            }
        }
    }

    private static class JavaAccessor
    extends JavaMethod {
        private final RubyModule packageOrClass;
        private final RubyModule parentPackage;

        JavaAccessor(RubyClass singleton, RubyModule packageOrClass, RubyModule parentPackage, String name2) {
            super((RubyModule)singleton, Visibility.PUBLIC, name2);
            this.parentPackage = parentPackage;
            this.packageOrClass = packageOrClass;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 0) {
                throw JavaPackage.packageMethodArgumentMismatch(context.runtime, this.parentPackage, name2, args2.length);
            }
            return this.call(context, self2, clazz, name2);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return this.packageOrClass;
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return this.packageOrClass;
        }

        @Override
        @Deprecated
        public Arity getArity() {
            return Arity.noArguments();
        }
    }

    public static class JCreateMethod
    extends JavaMethod.JavaMethodN
    implements CallableSelector.CallableCache<JavaProxyConstructor> {
        private final NonBlockingHashMapLong<JavaProxyConstructor> cache = new NonBlockingHashMapLong(8);

        JCreateMethod(RubyModule cls) {
            super(cls, Visibility.PUBLIC, "__jcreate!");
        }

        public static int forTypes(Ruby runtime2, IRubyObject[] args2, JCtorCache cache) {
            JavaConstructor ctor = (JavaConstructor)JCreateMethod.matchConstructorIndex((ThreadContext)runtime2.getCurrentContext(), (ParameterTypes[])cache.constructors, (CallableSelector.CallableCache)cache, (int)args2.length, (IRubyObject[])args2);
            int index2 = cache.indexOf(ctor);
            if (index2 < 0) {
                throw runtime2.newArgumentError("index error finding superconstructor");
            }
            return index2;
        }

        private static JavaProxyClass getProxyClass(ThreadContext context, IRubyObject self2) {
            RubyClass metaClass = self2.getMetaClass();
            IRubyObject proxyClass = metaClass.getInstanceVariable("@java_proxy_class");
            if (proxyClass == null || proxyClass.isNil()) {
                proxyClass = JavaProxyClass.getProxyClass(context.runtime, metaClass);
                metaClass.setInstanceVariable("@java_proxy_class", proxyClass);
            }
            return (JavaProxyClass)proxyClass;
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            JavaProxyConstructor matching;
            JavaProxyConstructor[] constructors2 = JCreateMethod.getProxyClass(context, self2).getConstructors();
            switch (constructors2.length) {
                case 1: {
                    matching = this.matchConstructor0ArityOne(context, constructors2, arg0);
                    break;
                }
                default: {
                    matching = this.matchConstructorArityOne(context, constructors2, arg0);
                }
            }
            if (self2 instanceof JavaProxy) {
                return context.nil;
            }
            IRubyObject newObject2 = matching.newInstance(context.runtime, self2, arg0);
            return JavaUtilities.set_java_object(self2, self2, newObject2);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
            JavaProxyConstructor matching;
            int arity2 = args2.length;
            JavaProxyConstructor[] constructors2 = JCreateMethod.getProxyClass(context, self2).getConstructors();
            switch (constructors2.length) {
                case 1: {
                    matching = this.matchConstructor0(context, constructors2, arity2, args2);
                    break;
                }
                default: {
                    matching = this.matchConstructor(context, constructors2, arity2, args2);
                }
            }
            IRubyObject newObject2 = matching.newInstance(context.runtime, self2, args2);
            return JavaUtilities.set_java_object(self2, self2, newObject2);
        }

        private JavaProxyConstructor matchConstructor0ArityOne(ThreadContext context, JavaProxyConstructor[] constructors2, IRubyObject arg0) {
            JavaProxyConstructor forArity = (JavaProxyConstructor)Java.checkCallableForArity((int)1, (ParameterTypes[])constructors2, (int)0);
            if (forArity == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            JavaProxyConstructor matching = (JavaProxyConstructor)CallableSelector.matchingCallableArityOne((Ruby)context.runtime, (CallableSelector.CallableCache)this, (ParameterTypes[])new JavaProxyConstructor[]{forArity}, (IRubyObject)arg0);
            if (matching == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            return matching;
        }

        private JavaProxyConstructor matchConstructor0(ThreadContext context, JavaProxyConstructor[] constructors2, int arity2, IRubyObject[] args2) {
            JavaProxyConstructor forArity = (JavaProxyConstructor)Java.checkCallableForArity((int)arity2, (ParameterTypes[])constructors2, (int)0);
            if (forArity == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            JavaProxyConstructor matching = (JavaProxyConstructor)CallableSelector.matchingCallableArityN((Ruby)context.runtime, (CallableSelector.CallableCache)this, (ParameterTypes[])new JavaProxyConstructor[]{forArity}, (IRubyObject[])args2);
            if (matching == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            return matching;
        }

        private JavaProxyConstructor matchConstructorArityOne(ThreadContext context, JavaProxyConstructor[] constructors2, IRubyObject arg0) {
            ArrayList forArity = Java.findCallablesForArity((int)1, (ParameterTypes[])constructors2);
            if (forArity.size() == 0) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            JavaProxyConstructor matching = (JavaProxyConstructor)CallableSelector.matchingCallableArityOne((Ruby)context.runtime, (CallableSelector.CallableCache)this, (ParameterTypes[])forArity.toArray(new JavaProxyConstructor[forArity.size()]), (IRubyObject)arg0);
            if (matching == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            return matching;
        }

        public JavaProxyConstructor matchConstructor(ThreadContext context, JavaProxyConstructor[] constructors2, int arity2, IRubyObject ... args2) {
            ArrayList forArity = Java.findCallablesForArity((int)arity2, (ParameterTypes[])constructors2);
            if (forArity.size() == 0) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            JavaProxyConstructor matching = (JavaProxyConstructor)CallableSelector.matchingCallableArityN((Ruby)context.runtime, (CallableSelector.CallableCache)this, (ParameterTypes[])forArity.toArray(new JavaProxyConstructor[forArity.size()]), (IRubyObject[])args2);
            if (matching == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            return matching;
        }

        public static <T extends ParameterTypes> T matchConstructorIndex(ThreadContext context, T[] constructors2, CallableSelector.CallableCache<ParameterTypes> cache, int arity2, IRubyObject ... args2) {
            ArrayList forArity = Java.findCallablesForArity((int)arity2, constructors2);
            if (forArity.size() == 0) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            ParameterTypes matching = CallableSelector.matchingCallableArityN((Ruby)context.runtime, cache, (ParameterTypes[])forArity.toArray(new ParameterTypes[forArity.size()]), (IRubyObject[])args2);
            if (matching == null) {
                throw context.runtime.newArgumentError("wrong number of arguments for constructor");
            }
            return (T)matching;
        }

        @Override
        public final JavaProxyConstructor getSignature(int signatureCode) {
            return this.cache.get(signatureCode);
        }

        @Override
        public final void putSignature(int signatureCode, JavaProxyConstructor callable) {
            this.cache.put(signatureCode, callable);
        }
    }

    public static class JCtorCache
    implements CallableSelector.CallableCache<ParameterTypes> {
        private final NonBlockingHashMapLong<ParameterTypes> cache = new NonBlockingHashMapLong(8);
        public final JavaConstructor[] constructors;
        private final List<JavaConstructor> constructorList;

        public JCtorCache(JavaConstructor[] constructors2) {
            this.constructors = constructors2;
            this.constructorList = Arrays.asList(constructors2);
        }

        public int indexOf(JavaConstructor ctor) {
            return this.constructorList.indexOf(ctor);
        }

        @Override
        public final ParameterTypes getSignature(int signatureCode) {
            return this.cache.get(signatureCode);
        }

        @Override
        public final void putSignature(int signatureCode, ParameterTypes callable) {
            this.cache.put(signatureCode, callable);
        }
    }

    public static class ByteArrayProxyMethods {
        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
            ByteList bytes2 = new ByteList((byte[])((ArrayJavaProxy)self2).getObject(), ascii8bit);
            return RubyString.newStringLight(context.runtime, bytes2);
        }
    }

    public static class NewStyleExtensionInherited {
        @Deprecated
        public static IRubyObject inherited(IRubyObject self2, IRubyObject subclass) {
            return NewStyleExtensionInherited.inherited(self2.getRuntime().getCurrentContext(), self2, subclass);
        }

        @JRubyMethod
        public static IRubyObject inherited(ThreadContext context, IRubyObject self2, IRubyObject subclass) {
            if (!(subclass instanceof RubyClass)) {
                throw context.runtime.newTypeError(subclass, context.runtime.getClassClass());
            }
            JavaInterfaceTemplate.addRealImplClassNew((RubyClass)subclass);
            return context.nil;
        }
    }

    public static class OldStyleExtensionInherited {
        @Deprecated
        public static IRubyObject inherited(IRubyObject self2, IRubyObject subclass) {
            return OldStyleExtensionInherited.inherited(self2.getRuntime().getCurrentContext(), self2, subclass);
        }

        @JRubyMethod
        public static IRubyObject inherited(ThreadContext context, IRubyObject self2, IRubyObject subclass) {
            return Java.invokeProxyClassInherited(context, self2, subclass);
        }
    }
}

