/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.zip.CRC32;
import org.logstash.ackedqueue.SequencedList;
import org.logstash.ackedqueue.io.ByteBufferCleaner;
import org.logstash.ackedqueue.io.ByteBufferCleanerImpl;
import org.logstash.ackedqueue.io.IntVector;
import org.logstash.ackedqueue.io.LongVector;
import org.logstash.ackedqueue.io.MmapPageIOV2;
import org.logstash.ackedqueue.io.PageIO;

public final class MmapPageIOV1
implements PageIO {
    public static final byte VERSION_ONE = 1;
    private static final ByteBufferCleaner BUFFER_CLEANER = new ByteBufferCleanerImpl();
    private final File file;
    private final CRC32 checkSummer;
    private final IntVector offsetMap;
    private int capacity;
    private long minSeqNum = 0L;
    private int elementCount = 0;
    private int head = 0;
    private byte version = 0;
    private MappedByteBuffer buffer;

    public MmapPageIOV1(int pageNum, int capacity, Path dirPath) {
        this.capacity = capacity;
        this.offsetMap = new IntVector();
        this.checkSummer = new CRC32();
        this.file = dirPath.resolve("page." + pageNum).toFile();
    }

    @Override
    public void open(long minSeqNum, int elementCount) throws IOException {
        this.mapFile();
        this.buffer.position(0);
        this.version = this.buffer.get();
        MmapPageIOV1.validateVersion(this.version);
        this.head = 1;
        this.minSeqNum = minSeqNum;
        this.elementCount = elementCount;
        if (this.elementCount > 0) {
            long seqNum = this.buffer.getLong();
            if (seqNum != this.minSeqNum) {
                throw new IOException(String.format("first seqNum=%d is different than minSeqNum=%d", seqNum, this.minSeqNum));
            }
            this.buffer.position(this.head);
            for (int i = 0; i < this.elementCount; ++i) {
                this.readNextElement(this.minSeqNum + (long)i, false);
            }
        }
    }

    @Override
    public SequencedList<byte[]> read(long seqNum, int limit) throws IOException {
        assert (seqNum >= this.minSeqNum) : String.format("seqNum=%d < minSeqNum=%d", seqNum, this.minSeqNum);
        assert (seqNum <= this.maxSeqNum()) : String.format("seqNum=%d is > maxSeqNum=%d", seqNum, this.maxSeqNum());
        ArrayList<byte[]> elements = new ArrayList<byte[]>();
        LongVector seqNums = new LongVector(limit);
        int offset = this.offsetMap.get((int)(seqNum - this.minSeqNum));
        this.buffer.position(offset);
        for (int i = 0; i < limit; ++i) {
            long readSeqNum = this.buffer.getLong();
            assert (readSeqNum == seqNum + (long)i) : String.format("unmatched seqNum=%d to readSeqNum=%d", seqNum + (long)i, readSeqNum);
            int readLength = this.buffer.getInt();
            byte[] readBytes = new byte[readLength];
            this.buffer.get(readBytes);
            int checksum = this.buffer.getInt();
            int computedChecksum = this.checksum(readBytes);
            if (computedChecksum != checksum) {
                throw new IOException(String.format("computed checksum=%d != checksum for file=%d", computedChecksum, checksum));
            }
            elements.add(readBytes);
            seqNums.add(readSeqNum);
            if (seqNum + (long)i >= this.maxSeqNum()) break;
        }
        return new SequencedList<byte[]>(elements, seqNums);
    }

    @Override
    public void recover() {
        throw new UnsupportedOperationException("Recovering v1 pages is not supported anymore.");
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException("Creating v1 pages is not supported anymore.");
    }

    @Override
    public void deactivate() {
        this.close();
    }

    @Override
    public void activate() throws IOException {
        if (this.buffer == null) {
            try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
                this.buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.capacity);
            }
            this.buffer.load();
        }
    }

    @Override
    public void ensurePersisted() {
        throw new UnsupportedOperationException("Writing to v1 pages is not supported anymore");
    }

    @Override
    public void purge() {
        throw new UnsupportedOperationException("Purging v1 pages is not supported anymore");
    }

    @Override
    public void write(byte[] bytes, long seqNum) {
        throw new UnsupportedOperationException("Writing to v1 pages is not supported anymore");
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.force();
            BUFFER_CLEANER.clean(this.buffer);
        }
        this.buffer = null;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public long getMinSeqNum() {
        return this.minSeqNum;
    }

    @Override
    public int getElementCount() {
        return this.elementCount;
    }

    @Override
    public boolean hasSpace(int bytes) {
        return false;
    }

    @Override
    public int persistedByteCount(int byteCount) {
        return 12 + byteCount + 4;
    }

    @Override
    public int getHead() {
        return this.head;
    }

    @Override
    public boolean isCorruptedPage() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            boolean bl = raf.length() < 18L;
            return bl;
        }
    }

    private int checksum(byte[] bytes) {
        this.checkSummer.reset();
        this.checkSummer.update(bytes, 0, bytes.length);
        return (int)this.checkSummer.getValue();
    }

    private long maxSeqNum() {
        return this.minSeqNum + (long)this.elementCount - 1L;
    }

    private void mapFile() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            int pageFileCapacity;
            if (raf.length() > Integer.MAX_VALUE) {
                throw new IOException("Page file too large " + this.file);
            }
            this.capacity = pageFileCapacity = (int)raf.length();
            if (this.capacity < 18) {
                throw new IOException(String.format("Page file size is too small to hold elements", new Object[0]));
            }
            this.buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.capacity);
        }
        this.buffer.load();
    }

    private void readNextElement(long expectedSeqNum, boolean verifyChecksum) throws MmapPageIOV2.PageIOInvalidElementException {
        if (this.head + 8 + 4 > this.capacity) {
            throw new MmapPageIOV2.PageIOInvalidElementException("cannot read seqNum and length bytes past buffer capacity");
        }
        int elementOffset = this.head;
        int newHead = this.head;
        long seqNum = this.buffer.getLong();
        newHead += 8;
        if (seqNum != expectedSeqNum) {
            throw new MmapPageIOV2.PageIOInvalidElementException(String.format("Element seqNum %d is expected to be %d", seqNum, expectedSeqNum));
        }
        int length = this.buffer.getInt();
        newHead += 4;
        if (length <= 0) {
            throw new MmapPageIOV2.PageIOInvalidElementException("Element invalid length");
        }
        if (newHead + length + 4 > this.capacity) {
            throw new MmapPageIOV2.PageIOInvalidElementException("cannot read element payload and checksum past buffer capacity");
        }
        if (verifyChecksum) {
            this.checkSummer.reset();
            int prevLimit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + length);
            this.checkSummer.update(this.buffer);
            this.buffer.limit(prevLimit);
            int checksum = this.buffer.getInt();
            int computedChecksum = (int)this.checkSummer.getValue();
            if (computedChecksum != checksum) {
                throw new MmapPageIOV2.PageIOInvalidElementException("Element invalid checksum");
            }
        }
        this.offsetMap.add(elementOffset);
        this.head = newHead + length + 4;
        this.buffer.position(this.head);
    }

    private static void validateVersion(byte version) throws MmapPageIOV2.PageIOInvalidVersionException {
        if (version != 1) {
            throw new MmapPageIOV2.PageIOInvalidVersionException(String.format("Expected page version=%d but found version=%d", (byte)1, version));
        }
    }

    public String toString() {
        return "MmapPageIOV1{file=" + this.file + ", capacity=" + this.capacity + ", minSeqNum=" + this.minSeqNum + ", elementCount=" + this.elementCount + ", head=" + this.head + "}";
    }
}

