/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapFecType;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataMcs
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 8914690461479810322L;
    private static final int LENGTH = 3;
    private final boolean bandwidthKnown;
    private final boolean mcsIndexKnown;
    private final boolean guardIntervalKnown;
    private final boolean htFormatKnown;
    private final boolean fecTypeKnown;
    private final boolean stbcKnown;
    private final boolean nessKnown;
    private final boolean nessMsb;
    private final Bandwidth bandwidth;
    private final boolean shortGuardInterval;
    private final HtFormat htFormat;
    private final RadiotapFecType fecType;
    private final byte numStbcStreams;
    private final boolean nessLsb;
    private final byte mcsRateIndex;

    public static RadiotapDataMcs newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataMcs(rawData, offset, length);
    }

    private RadiotapDataMcs(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 3) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapMcs (").append(3).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.bandwidthKnown = (rawData[offset] & 1) != 0;
        this.mcsIndexKnown = (rawData[offset] & 2) != 0;
        this.guardIntervalKnown = (rawData[offset] & 4) != 0;
        this.htFormatKnown = (rawData[offset] & 8) != 0;
        this.fecTypeKnown = (rawData[offset] & 0x10) != 0;
        this.stbcKnown = (rawData[offset] & 0x20) != 0;
        this.nessKnown = (rawData[offset] & 0x40) != 0;
        this.nessMsb = (rawData[offset] & 0x80) != 0;
        switch (rawData[offset + 1] & 3) {
            case 0: {
                this.bandwidth = Bandwidth.BW_20;
                break;
            }
            case 1: {
                this.bandwidth = Bandwidth.BW_40;
                break;
            }
            case 2: {
                this.bandwidth = Bandwidth.BW_20L;
                break;
            }
            case 3: {
                this.bandwidth = Bandwidth.BW_20U;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here.");
            }
        }
        this.shortGuardInterval = (rawData[offset + 1] & 4) != 0;
        switch (rawData[offset + 1] & 8) {
            case 0: {
                this.htFormat = HtFormat.MIXED;
                break;
            }
            default: {
                this.htFormat = HtFormat.GREENFIELD;
            }
        }
        switch (rawData[offset + 1] & 0x10) {
            case 0: {
                this.fecType = RadiotapFecType.BCC;
                break;
            }
            default: {
                this.fecType = RadiotapFecType.LDPC;
            }
        }
        this.numStbcStreams = (byte)((rawData[offset + 1] & 0x60) >> 5);
        this.nessLsb = (rawData[offset + 1] & 0x80) != 0;
        this.mcsRateIndex = rawData[offset + 2];
    }

    private RadiotapDataMcs(Builder builder2) {
        if (builder2 == null || builder2.bandwidth == null || builder2.htFormat == null || builder2.fecType == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.bandwidth: ").append((Object)builder2.bandwidth).append(" builder.htFormat: ").append((Object)builder2.htFormat).append(" builder.fecType: ").append((Object)builder2.fecType);
            throw new NullPointerException(sb.toString());
        }
        if ((builder2.numStbcStreams & 0xFC) != 0) {
            throw new IllegalArgumentException("(builder.numStbcStreams & 0xFC) must be 0. builder.numStbcStreams: " + builder2.numStbcStreams);
        }
        this.bandwidthKnown = builder2.bandwidthKnown;
        this.mcsIndexKnown = builder2.mcsIndexKnown;
        this.guardIntervalKnown = builder2.guardIntervalKnown;
        this.htFormatKnown = builder2.htFormatKnown;
        this.fecTypeKnown = builder2.fecTypeKnown;
        this.stbcKnown = builder2.stbcKnown;
        this.nessKnown = builder2.nessKnown;
        this.nessMsb = builder2.nessMsb;
        this.bandwidth = builder2.bandwidth;
        this.shortGuardInterval = builder2.shortGuardInterval;
        this.htFormat = builder2.htFormat;
        this.fecType = builder2.fecType;
        this.numStbcStreams = builder2.numStbcStreams;
        this.nessLsb = builder2.nessLsb;
        this.mcsRateIndex = builder2.mcsRateIndex;
    }

    public boolean isBandwidthKnown() {
        return this.bandwidthKnown;
    }

    public boolean isMcsIndexKnown() {
        return this.mcsIndexKnown;
    }

    public boolean isGuardIntervalKnown() {
        return this.guardIntervalKnown;
    }

    public boolean isHtFormatKnown() {
        return this.htFormatKnown;
    }

    public boolean isFecTypeKnown() {
        return this.fecTypeKnown;
    }

    public boolean isStbcKnown() {
        return this.stbcKnown;
    }

    public boolean isNessKnown() {
        return this.nessKnown;
    }

    public boolean getNessMsb() {
        return this.nessMsb;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public boolean isShortGuardInterval() {
        return this.shortGuardInterval;
    }

    public HtFormat getHtFormat() {
        return this.htFormat;
    }

    public RadiotapFecType getFecType() {
        return this.fecType;
    }

    public byte getNumStbcStreams() {
        return this.numStbcStreams;
    }

    public int getNumStbcStreamsAsInt() {
        return this.numStbcStreams;
    }

    public boolean getNessLsb() {
        return this.nessLsb;
    }

    public byte getMcsRateIndex() {
        return this.mcsRateIndex;
    }

    public int getMcsRateIndexAsInt() {
        return this.mcsRateIndex & 0xFF;
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[3];
        if (this.bandwidthKnown) {
            data[0] = (byte)(data[0] | 1);
        }
        if (this.mcsIndexKnown) {
            data[0] = (byte)(data[0] | 2);
        }
        if (this.guardIntervalKnown) {
            data[0] = (byte)(data[0] | 4);
        }
        if (this.htFormatKnown) {
            data[0] = (byte)(data[0] | 8);
        }
        if (this.fecTypeKnown) {
            data[0] = (byte)(data[0] | 0x10);
        }
        if (this.stbcKnown) {
            data[0] = (byte)(data[0] | 0x20);
        }
        if (this.nessKnown) {
            data[0] = (byte)(data[0] | 0x40);
        }
        if (this.nessMsb) {
            data[0] = (byte)(data[0] | 0x80);
        }
        data[1] = (byte)this.bandwidth.value;
        if (this.shortGuardInterval) {
            data[1] = (byte)(data[1] | 4);
        }
        if (this.htFormat == HtFormat.GREENFIELD) {
            data[1] = (byte)(data[1] | 8);
        }
        if (this.fecType == RadiotapFecType.LDPC) {
            data[1] = (byte)(data[1] | 0x10);
        }
        data[1] = (byte)(data[1] | this.numStbcStreams << 5);
        if (this.nessLsb) {
            data[1] = (byte)(data[1] | 0x80);
        }
        data[2] = this.mcsRateIndex;
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("MCS: ").append(ls).append(indent).append("  bandwidth known: ").append(this.bandwidthKnown).append(ls).append(indent).append("  MCS index known: ").append(this.mcsIndexKnown).append(ls).append(indent).append("  guard interval known: ").append(this.guardIntervalKnown).append(ls).append(indent).append("  HT format known: ").append(this.htFormatKnown).append(ls).append(indent).append("  FEC type known: ").append(this.fecTypeKnown).append(ls).append(indent).append("  STBC known: ").append(this.stbcKnown).append(ls).append(indent).append("  Ness known: ").append(this.nessKnown).append(ls).append(indent).append("  Ness data known: ").append(this.nessMsb).append(ls).append(indent).append("  bandwidth: ").append((Object)this.bandwidth).append(ls).append(indent).append("  short guard interval: ").append(this.shortGuardInterval).append(ls).append(indent).append("  HT format: ").append((Object)this.htFormat).append(ls).append(indent).append("  FEC type: ").append((Object)this.fecType).append(ls).append(indent).append("  Number of STBC streams: ").append(this.numStbcStreams).append(ls).append(indent).append("  Ness: ").append(this.nessLsb).append(ls).append(indent).append("  MCS rate index: ").append(this.getMcsRateIndexAsInt()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bandwidth.hashCode();
        result = 31 * result + (this.bandwidthKnown ? 1231 : 1237);
        result = 31 * result + this.fecType.hashCode();
        result = 31 * result + (this.fecTypeKnown ? 1231 : 1237);
        result = 31 * result + (this.guardIntervalKnown ? 1231 : 1237);
        result = 31 * result + this.htFormat.hashCode();
        result = 31 * result + (this.htFormatKnown ? 1231 : 1237);
        result = 31 * result + (this.mcsIndexKnown ? 1231 : 1237);
        result = 31 * result + this.mcsRateIndex;
        result = 31 * result + (this.nessLsb ? 1231 : 1237);
        result = 31 * result + (this.nessMsb ? 1231 : 1237);
        result = 31 * result + (this.nessKnown ? 1231 : 1237);
        result = 31 * result + this.numStbcStreams;
        result = 31 * result + (this.shortGuardInterval ? 1231 : 1237);
        result = 31 * result + (this.stbcKnown ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataMcs other = (RadiotapDataMcs)obj;
        if (this.bandwidth != other.bandwidth) {
            return false;
        }
        if (this.bandwidthKnown != other.bandwidthKnown) {
            return false;
        }
        if (this.fecType != other.fecType) {
            return false;
        }
        if (this.fecTypeKnown != other.fecTypeKnown) {
            return false;
        }
        if (this.guardIntervalKnown != other.guardIntervalKnown) {
            return false;
        }
        if (this.htFormat != other.htFormat) {
            return false;
        }
        if (this.htFormatKnown != other.htFormatKnown) {
            return false;
        }
        if (this.mcsIndexKnown != other.mcsIndexKnown) {
            return false;
        }
        if (this.mcsRateIndex != other.mcsRateIndex) {
            return false;
        }
        if (this.nessLsb != other.nessLsb) {
            return false;
        }
        if (this.nessMsb != other.nessMsb) {
            return false;
        }
        if (this.nessKnown != other.nessKnown) {
            return false;
        }
        if (this.numStbcStreams != other.numStbcStreams) {
            return false;
        }
        if (this.shortGuardInterval != other.shortGuardInterval) {
            return false;
        }
        return this.stbcKnown == other.stbcKnown;
    }

    public static enum HtFormat {
        MIXED(0),
        GREENFIELD(1);

        private final int value;

        private HtFormat(int value2) {
            this.value = value2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Bandwidth {
        BW_20(0, "20"),
        BW_40(1, "40"),
        BW_20L(2, "20L"),
        BW_20U(3, "20U");

        private final int value;
        private final String name;

        private Bandwidth(int value2, String name) {
            this.value = value2;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }
    }

    public static final class Builder {
        private boolean bandwidthKnown;
        private boolean mcsIndexKnown;
        private boolean guardIntervalKnown;
        private boolean htFormatKnown;
        private boolean fecTypeKnown;
        private boolean stbcKnown;
        private boolean nessKnown;
        private boolean nessMsb;
        private Bandwidth bandwidth;
        private boolean shortGuardInterval;
        private HtFormat htFormat;
        private RadiotapFecType fecType;
        private byte numStbcStreams;
        private boolean nessLsb;
        private byte mcsRateIndex;

        public Builder() {
        }

        private Builder(RadiotapDataMcs obj) {
            this.bandwidthKnown = obj.bandwidthKnown;
            this.mcsIndexKnown = obj.mcsIndexKnown;
            this.guardIntervalKnown = obj.guardIntervalKnown;
            this.htFormatKnown = obj.htFormatKnown;
            this.fecTypeKnown = obj.fecTypeKnown;
            this.stbcKnown = obj.stbcKnown;
            this.nessKnown = obj.nessKnown;
            this.nessMsb = obj.nessMsb;
            this.bandwidth = obj.bandwidth;
            this.shortGuardInterval = obj.shortGuardInterval;
            this.htFormat = obj.htFormat;
            this.fecType = obj.fecType;
            this.numStbcStreams = obj.numStbcStreams;
            this.nessLsb = obj.nessLsb;
            this.mcsRateIndex = obj.mcsRateIndex;
        }

        public Builder bandwidthKnown(boolean bandwidthKnown) {
            this.bandwidthKnown = bandwidthKnown;
            return this;
        }

        public Builder mcsIndexKnown(boolean mcsIndexKnown) {
            this.mcsIndexKnown = mcsIndexKnown;
            return this;
        }

        public Builder guardIntervalKnown(boolean guardIntervalKnown) {
            this.guardIntervalKnown = guardIntervalKnown;
            return this;
        }

        public Builder htFormatKnown(boolean htFormatKnown) {
            this.htFormatKnown = htFormatKnown;
            return this;
        }

        public Builder fecTypeKnown(boolean fecTypeKnown) {
            this.fecTypeKnown = fecTypeKnown;
            return this;
        }

        public Builder stbcKnown(boolean stbcKnown) {
            this.stbcKnown = stbcKnown;
            return this;
        }

        public Builder nessKnown(boolean nessKnown) {
            this.nessKnown = nessKnown;
            return this;
        }

        public Builder nessMsb(boolean nessMsb) {
            this.nessMsb = nessMsb;
            return this;
        }

        public Builder bandwidth(Bandwidth bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public Builder shortGuardInterval(boolean shortGuardInterval) {
            this.shortGuardInterval = shortGuardInterval;
            return this;
        }

        public Builder htFormat(HtFormat htFormat) {
            this.htFormat = htFormat;
            return this;
        }

        public Builder fecType(RadiotapFecType fecType) {
            this.fecType = fecType;
            return this;
        }

        public Builder numStbcStreams(byte numStbcStreams) {
            this.numStbcStreams = numStbcStreams;
            return this;
        }

        public Builder nessLsb(boolean nessLsb) {
            this.nessLsb = nessLsb;
            return this;
        }

        public Builder mcsRateIndex(byte mcsRateIndex) {
            this.mcsRateIndex = mcsRateIndex;
            return this;
        }

        public RadiotapDataMcs build() {
            return new RadiotapDataMcs(this);
        }
    }
}

