/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.glassfish.jersey.servlet.ServletContainer;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigException;
import org.jitsi.metaconfig.MetaconfigLogger;
import org.jitsi.metaconfig.MetaconfigSettings;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.rest.JettyBundleActivatorConfig;
import org.jitsi.rest.JettyHelpers;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.MainKt;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.VideobridgeExpireThread;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.ice.Harvesters;
import org.jitsi.videobridge.metrics.Metrics;
import org.jitsi.videobridge.metrics.VideobridgePeriodicMetrics;
import org.jitsi.videobridge.rest.root.Application;
import org.jitsi.videobridge.stats.MucPublisher;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.util.UlimitCheck;
import org.jitsi.videobridge.version.JvbVersionService;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.videobridge.xmpp.Smack;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\b\u0010\t\u001a\u00020\u0001H\u0002\u00a8\u0006\n"}, d2={"main", "", "setupMetaconfigLogger", "setSystemPropertyDefaults", "getSystemPropertyDefaults", "", "", "startIce4j", "stopIce4j", "setupBufferPools", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/jitsi/videobridge/MainKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1#2:244\n215#3,2:245\n1855#4,2:247\n*S KotlinDebug\n*F\n+ 1 Main.kt\norg/jitsi/videobridge/MainKt\n*L\n200#1:245,2\n213#1:247,2\n*E\n"})
public final class MainKt {
    public static final void main() {
        AbstractLifeCycle abstractLifeCycle;
        Server server;
        MucPublisher mucPublisher;
        LoggerImpl logger = new LoggerImpl("org.jitsi.videobridge.Main");
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> MainKt.main$lambda$0(logger, arg_0, arg_1));
        MainKt.setupMetaconfigLogger();
        MainKt.setSystemPropertyDefaults();
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.JavaUtilLog");
        Metrics.INSTANCE.start();
        JitsiConfig.Companion.reloadNewConfig();
        logger.info("Starting jitsi-videobridge version " + JvbVersionService.Companion.getInstance().getCurrentVersion());
        UlimitCheck.printUlimits();
        MainKt.startIce4j();
        MainKt.setupBufferPools();
        Harvesters.Companion.init();
        Smack.INSTANCE.initialize();
        PacketQueue.setEnableStatisticsDefault(true);
        try {
            DtlsConfig.Companion.getConfig().getCipherSuites();
        }
        catch (ConfigException ce) {
            logger.error("Dtls configuration error: " + ce);
            System.exit(78);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        XmppConnection $this$main_u24lambda_u241 = ce = new XmppConnection();
        boolean bl = false;
        $this$main_u24lambda_u241.start();
        XmppConnection xmppConnection = ce;
        ShutdownServiceImpl shutdownService = new ShutdownServiceImpl();
        Videobridge videobridge = new Videobridge(xmppConnection, shutdownService, JvbVersionService.Companion.getInstance().getCurrentVersion(), Clock.systemUTC());
        VideobridgeExpireThread videobridgeExpireThread = new VideobridgeExpireThread(videobridge);
        Metrics.INSTANCE.getMetricsUpdater().addUpdateTask(() -> MainKt.main$lambda$2(videobridge));
        JvbHealthChecker jvbHealthChecker = videobridge.getJvbHealthChecker();
        Intrinsics.checkNotNullExpressionValue(jvbHealthChecker, "getJvbHealthChecker(...)");
        JvbHealthChecker healthChecker2 = jvbHealthChecker;
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        MucPublisher $this$main_u24lambda_u243 = mucPublisher = new MucPublisher(scheduledExecutorService, XmppClientConnectionConfig.config.getPresenceInterval(), xmppConnection);
        boolean bl2 = false;
        $this$main_u24lambda_u243.start();
        MucPublisher presencePublisher = mucPublisher;
        JettyBundleActivatorConfig publicServerConfig = new JettyBundleActivatorConfig("org.jitsi.videobridge.rest", "videobridge.http-servers.public");
        if (JettyHelpers.isEnabled(publicServerConfig)) {
            Server server2;
            logger.info("Starting public http server");
            ColibriWebSocketService websocketService = new ColibriWebSocketService(publicServerConfig.isTls());
            ColibriWebSocketServiceSupplierKt.singleton().setColibriWebSocketService(websocketService);
            Server it = server2 = JettyHelpers.createServer(publicServerConfig);
            boolean bl3 = false;
            websocketService.registerServlet(JettyHelpers.getServletContextHandler(it), videobridge);
            it.start();
            server = server2;
        } else {
            logger.info("Not starting public http server");
            server = null;
        }
        Server publicHttpServer = server;
        JettyBundleActivatorConfig privateServerConfig = new JettyBundleActivatorConfig("org.jitsi.videobridge.rest.private", "videobridge.http-servers.private");
        if (JettyHelpers.isEnabled(privateServerConfig)) {
            Server bl3;
            logger.info("Starting private http server");
            Application restApp = new Application(videobridge, xmppConnection, JvbVersionService.Companion.getInstance().getCurrentVersion(), healthChecker2);
            Server it = bl3 = JettyHelpers.createServer(privateServerConfig);
            boolean bl4 = false;
            JettyHelpers.getServletContextHandler(it).addServlet(new ServletHolder(new ServletContainer(restApp)), "/*");
            JettyHelpers.enableCors$default(JettyHelpers.getServletContextHandler(it), null, 1, null);
            it.start();
            abstractLifeCycle = bl3;
        } else {
            logger.info("Not starting private http server");
            abstractLifeCycle = null;
        }
        AbstractLifeCycle privateHttpServer = abstractLifeCycle;
        shutdownService.waitForShutdown();
        logger.info("Bridge shutting down");
        healthChecker2.stop();
        presencePublisher.stop();
        xmppConnection.stop();
        try {
            Server server3 = publicHttpServer;
            if (server3 != null) {
                server3.stop();
            }
            AbstractLifeCycle abstractLifeCycle2 = privateHttpServer;
            if (abstractLifeCycle2 != null) {
                abstractLifeCycle2.stop();
            }
        }
        catch (Throwable t2) {
            logger.error("Error shutting down http servers", t2);
        }
        videobridgeExpireThread.stop();
        videobridge.stop();
        MainKt.stopIce4j();
        Metrics.INSTANCE.stop();
        TaskPools.SCHEDULED_POOL.shutdownNow();
        TaskPools.CPU_POOL.shutdownNow();
        TaskPools.IO_POOL.shutdownNow();
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void setupMetaconfigLogger() {
        LoggerImpl configLogger = new LoggerImpl("org.jitsi.config");
        MetaconfigSettings.Companion.setLogger(new MetaconfigLogger(configLogger){
            final /* synthetic */ LoggerImpl $configLogger;
            {
                this.$configLogger = $configLogger;
            }

            public void warn(Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                this.$configLogger.warn(() -> setupMetaconfigLogger.1.warn$lambda$0(block));
            }

            public void error(Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                this.$configLogger.error(() -> setupMetaconfigLogger.1.error$lambda$1(block));
            }

            public void debug(Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                this.$configLogger.debug(() -> setupMetaconfigLogger.1.debug$lambda$2(block));
            }

            private static final String warn$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke();
            }

            private static final String error$lambda$1(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke();
            }

            private static final String debug$lambda$2(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (String)$tmp0.invoke();
            }
        });
    }

    private static final void setSystemPropertyDefaults() {
        Map<String, String> defaults;
        Map<String, String> $this$forEach$iv = defaults = MainKt.getSystemPropertyDefaults();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, value2);
        }
    }

    private static final Map<String, String> getSystemPropertyDefaults() {
        Map defaults;
        block1: {
            List<String> ice4jPropNames;
            defaults = new LinkedHashMap();
            ConfigurationService cfg = JitsiConfig.Companion.getSipCommunicatorProps();
            List<String> list = ice4jPropNames = cfg.getPropertyNamesByPrefix("org.ice4j", false);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String value2;
                String key = (String)element$iv;
                boolean bl = false;
                if (cfg.getString(key) == null) continue;
                boolean bl2 = false;
                Intrinsics.checkNotNull(key);
                defaults.put(key, value2);
            }
        }
        return defaults;
    }

    private static final void startIce4j() {
        ThreadsKt.thread$default(true, false, null, null, 0, MainKt::startIce4j$lambda$9, 30, null);
    }

    private static final void stopIce4j() {
        Harvesters.Companion.close();
    }

    private static final void setupBufferPools() {
        BufferPool.Companion.setGetArray(MainKt::setupBufferPools$lambda$10);
        BufferPool.Companion.setReturnArray(MainKt::setupBufferPools$lambda$11);
        org.jitsi.nlj.util.BufferPool.Companion.setGetBuffer(MainKt::setupBufferPools$lambda$12);
        org.jitsi.nlj.util.BufferPool.Companion.setReturnBuffer(MainKt::setupBufferPools$lambda$13);
    }

    public static /* synthetic */ void main(String[] args2) {
        MainKt.main();
    }

    private static final void main$lambda$0(LoggerImpl $logger, Thread thread2, Throwable exception) {
        Intrinsics.checkNotNullParameter($logger, "$logger");
        $logger.error("An uncaught exception occurred in thread=" + thread2, exception);
    }

    private static final Unit main$lambda$2(Videobridge $videobridge) {
        Intrinsics.checkNotNullParameter($videobridge, "$videobridge");
        VideobridgePeriodicMetrics.INSTANCE.update($videobridge);
        return Unit.INSTANCE;
    }

    private static final Unit startIce4j$lambda$9() {
        MappingCandidateHarvesters.initialize();
        return Unit.INSTANCE;
    }

    private static final byte[] setupBufferPools$lambda$10(int it) {
        return ByteBufferPool.getBuffer(it);
    }

    private static final Unit setupBufferPools$lambda$11(byte[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ByteBufferPool.returnBuffer(it);
        return Unit.INSTANCE;
    }

    private static final byte[] setupBufferPools$lambda$12(int it) {
        return ByteBufferPool.getBuffer(it);
    }

    private static final Unit setupBufferPools$lambda$13(byte[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ByteBufferPool.returnBuffer(it);
        return Unit.INSTANCE;
    }
}

