/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.stream.AbstractTask;
import java.util.stream.Node;
import java.util.stream.PipelineHelper;
import java.util.stream.Sink;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.TerminalOp;
import java.util.stream.TerminalSink;

final class ForEachOps {
    private ForEachOps() {
    }

    public static <T> TerminalOp<T, Void> makeRef(Consumer<? super T> consumer, boolean bl) {
        Objects.requireNonNull(consumer);
        return new ForEachOp.OfRef<T>(consumer, bl);
    }

    public static TerminalOp<Integer, Void> makeInt(IntConsumer intConsumer, boolean bl) {
        Objects.requireNonNull(intConsumer);
        return new ForEachOp.OfInt(intConsumer, bl);
    }

    public static TerminalOp<Long, Void> makeLong(LongConsumer longConsumer, boolean bl) {
        Objects.requireNonNull(longConsumer);
        return new ForEachOp.OfLong(longConsumer, bl);
    }

    public static TerminalOp<Double, Void> makeDouble(DoubleConsumer doubleConsumer, boolean bl) {
        Objects.requireNonNull(doubleConsumer);
        return new ForEachOp.OfDouble(doubleConsumer, bl);
    }

    static final class ForEachOrderedTask<S, T>
    extends CountedCompleter<Void> {
        private final PipelineHelper<T> helper;
        private Spliterator<S> spliterator;
        private final long targetSize;
        private final ConcurrentHashMap<ForEachOrderedTask<S, T>, ForEachOrderedTask<S, T>> completionMap;
        private final Sink<T> action;
        private final ForEachOrderedTask<S, T> leftPredecessor;
        private Node<T> node;

        protected ForEachOrderedTask(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator, Sink<T> sink) {
            super(null);
            this.helper = pipelineHelper;
            this.spliterator = spliterator;
            this.targetSize = AbstractTask.suggestTargetSize(spliterator.estimateSize());
            this.completionMap = new ConcurrentHashMap(Math.max(16, AbstractTask.getLeafTarget() << 1));
            this.action = sink;
            this.leftPredecessor = null;
        }

        ForEachOrderedTask(ForEachOrderedTask<S, T> forEachOrderedTask, Spliterator<S> spliterator, ForEachOrderedTask<S, T> forEachOrderedTask2) {
            super(forEachOrderedTask);
            this.helper = forEachOrderedTask.helper;
            this.spliterator = spliterator;
            this.targetSize = forEachOrderedTask.targetSize;
            this.completionMap = forEachOrderedTask.completionMap;
            this.action = forEachOrderedTask.action;
            this.leftPredecessor = forEachOrderedTask2;
        }

        @Override
        public final void compute() {
            ForEachOrderedTask.doCompute(this);
        }

        private static <S, T> void doCompute(ForEachOrderedTask<S, T> object) {
            Object object2;
            Object object3;
            Spliterator<S> spliterator;
            Spliterator<S> spliterator2 = ((ForEachOrderedTask)object).spliterator;
            long l = ((ForEachOrderedTask)object).targetSize;
            boolean bl = false;
            while (spliterator2.estimateSize() > l && (spliterator = spliterator2.trySplit()) != null) {
                Object object4;
                object3 = new ForEachOrderedTask<S, T>(object, spliterator, ((ForEachOrderedTask)object).leftPredecessor);
                object2 = new ForEachOrderedTask<S, T>(object, spliterator2, object3);
                ((CountedCompleter)object).addToPendingCount(1);
                ((CountedCompleter)object2).addToPendingCount(1);
                ((ForEachOrderedTask)object).completionMap.put((ForEachOrderedTask<S, T>)object3, (ForEachOrderedTask<S, T>)object2);
                if (((ForEachOrderedTask)object).leftPredecessor != null) {
                    ((CountedCompleter)object3).addToPendingCount(1);
                    if (((ForEachOrderedTask)object).completionMap.replace(((ForEachOrderedTask)object).leftPredecessor, (ForEachOrderedTask<S, T>)object, (ForEachOrderedTask<S, T>)object3)) {
                        ((CountedCompleter)object).addToPendingCount(-1);
                    } else {
                        ((CountedCompleter)object3).addToPendingCount(-1);
                    }
                }
                if (bl) {
                    bl = false;
                    spliterator2 = spliterator;
                    object = object3;
                    object4 = object2;
                } else {
                    bl = true;
                    object = object2;
                    object4 = object3;
                }
                ((ForkJoinTask)object4).fork();
            }
            if (((CountedCompleter)object).getPendingCount() > 0) {
                object3 = Object[]::new;
                object2 = ((ForEachOrderedTask)object).helper.makeNodeBuilder(((ForEachOrderedTask)object).helper.exactOutputSizeIfKnown(spliterator2), (IntFunction<T[]>)object3);
                ((ForEachOrderedTask)object).node = ((ForEachOrderedTask)object).helper.wrapAndCopyInto(object2, spliterator2).build();
                ((ForEachOrderedTask)object).spliterator = null;
            }
            ((CountedCompleter)object).tryComplete();
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            if (this.node != null) {
                this.node.forEach(this.action);
                this.node = null;
            } else if (this.spliterator != null) {
                this.helper.wrapAndCopyInto(this.action, this.spliterator);
                this.spliterator = null;
            }
            ForEachOrderedTask<S, T> forEachOrderedTask = this.completionMap.remove(this);
            if (forEachOrderedTask != null) {
                forEachOrderedTask.tryComplete();
            }
        }
    }

    static final class ForEachTask<S, T>
    extends CountedCompleter<Void> {
        private Spliterator<S> spliterator;
        private final Sink<S> sink;
        private final PipelineHelper<T> helper;
        private long targetSize;

        ForEachTask(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator, Sink<S> sink) {
            super(null);
            this.sink = sink;
            this.helper = pipelineHelper;
            this.spliterator = spliterator;
            this.targetSize = 0L;
        }

        ForEachTask(ForEachTask<S, T> forEachTask, Spliterator<S> spliterator) {
            super(forEachTask);
            this.spliterator = spliterator;
            this.sink = forEachTask.sink;
            this.targetSize = forEachTask.targetSize;
            this.helper = forEachTask.helper;
        }

        @Override
        public void compute() {
            Spliterator<S> spliterator = this.spliterator;
            long l = spliterator.estimateSize();
            long l2 = this.targetSize;
            if (l2 == 0L) {
                this.targetSize = l2 = AbstractTask.suggestTargetSize(l);
            }
            boolean bl = StreamOpFlag.SHORT_CIRCUIT.isKnown(this.helper.getStreamAndOpFlags());
            boolean bl2 = false;
            Sink<S> sink = this.sink;
            ForEachTask forEachTask = this;
            while (!bl || !sink.cancellationRequested()) {
                ForEachTask forEachTask2;
                Spliterator<S> spliterator2;
                if (l <= l2 || (spliterator2 = spliterator.trySplit()) == null) {
                    forEachTask.helper.copyInto(sink, spliterator);
                    break;
                }
                ForEachTask forEachTask3 = new ForEachTask(forEachTask, spliterator2);
                forEachTask.addToPendingCount(1);
                if (bl2) {
                    bl2 = false;
                    spliterator = spliterator2;
                    forEachTask2 = forEachTask;
                    forEachTask = forEachTask3;
                } else {
                    bl2 = true;
                    forEachTask2 = forEachTask3;
                }
                forEachTask2.fork();
                l = spliterator.estimateSize();
            }
            forEachTask.spliterator = null;
            forEachTask.propagateCompletion();
        }
    }

    static abstract class ForEachOp<T>
    implements TerminalOp<T, Void>,
    TerminalSink<T, Void> {
        private final boolean ordered;

        protected ForEachOp(boolean bl) {
            this.ordered = bl;
        }

        @Override
        public int getOpFlags() {
            return this.ordered ? 0 : StreamOpFlag.NOT_ORDERED;
        }

        @Override
        public <S> Void evaluateSequential(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator) {
            return pipelineHelper.wrapAndCopyInto(this, spliterator).get();
        }

        @Override
        public <S> Void evaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator) {
            if (this.ordered) {
                new ForEachOrderedTask<S, T>(pipelineHelper, spliterator, this).invoke();
            } else {
                new ForEachTask<S, T>(pipelineHelper, spliterator, pipelineHelper.wrapSink(this)).invoke();
            }
            return null;
        }

        @Override
        public Void get() {
            return null;
        }

        static final class OfDouble
        extends ForEachOp<Double>
        implements Sink.OfDouble {
            final DoubleConsumer consumer;

            OfDouble(DoubleConsumer doubleConsumer, boolean bl) {
                super(bl);
                this.consumer = doubleConsumer;
            }

            @Override
            public StreamShape inputShape() {
                return StreamShape.DOUBLE_VALUE;
            }

            @Override
            public void accept(double d) {
                this.consumer.accept(d);
            }
        }

        static final class OfLong
        extends ForEachOp<Long>
        implements Sink.OfLong {
            final LongConsumer consumer;

            OfLong(LongConsumer longConsumer, boolean bl) {
                super(bl);
                this.consumer = longConsumer;
            }

            @Override
            public StreamShape inputShape() {
                return StreamShape.LONG_VALUE;
            }

            @Override
            public void accept(long l) {
                this.consumer.accept(l);
            }
        }

        static final class OfInt
        extends ForEachOp<Integer>
        implements Sink.OfInt {
            final IntConsumer consumer;

            OfInt(IntConsumer intConsumer, boolean bl) {
                super(bl);
                this.consumer = intConsumer;
            }

            @Override
            public StreamShape inputShape() {
                return StreamShape.INT_VALUE;
            }

            @Override
            public void accept(int n) {
                this.consumer.accept(n);
            }
        }

        static final class OfRef<T>
        extends ForEachOp<T> {
            final Consumer<? super T> consumer;

            OfRef(Consumer<? super T> consumer, boolean bl) {
                super(bl);
                this.consumer = consumer;
            }

            @Override
            public void accept(T t) {
                this.consumer.accept(t);
            }
        }
    }
}

