/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor.paste;

import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Producer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.images.editor.paste.MarkdownFileDropHandler;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/images/editor/paste/FileLinkPasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPasteEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPastePossible", "performPaste", "", "intellij.markdown.images"})
public final class FileLinkPasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Producer producer = (Producer)dataContext.getData(PasteAction.TRANSFERABLE_PROVIDER);
        if (producer == null) {
            return;
        }
        Producer transferableProvider = producer;
        Transferable transferable = (Transferable)transferableProvider.produce();
        if (transferable == null) {
            return;
        }
        Transferable transferable2 = transferable;
        List list2 = FileCopyPasteUtil.getFiles((Transferable)transferable2);
        if (list2 == null || (list2 = CollectionsKt.asSequence((Iterable)list2)) == null) {
            return;
        }
        List files = list2;
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor3);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
        PsiFile file = psiFile;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String content2 = MarkdownFileDropHandler.Manager.INSTANCE.buildTextContent((Sequence<? extends Path>)files, file);
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(project2, document2, editor3, content2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $content;
            {
                this.$project = $project;
                this.$document = $document;
                this.$editor = $editor;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                MarkdownFileDropHandler.Manager.INSTANCE.handleReadOnlyModificationException(this.$project, this.$document, (Function0<Unit>)((Function0)new Function0<Unit>(this.$project, this.$editor, this.$document, this.$content){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ String $content;
                    {
                        this.$project = $project;
                        this.$editor = $editor;
                        this.$document = $document;
                        this.$content = $content;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void project$iv;
                        Project project = this.$project;
                        Editor editor2 = this.$editor;
                        Document document = this.$document;
                        String string = this.$content;
                        String name$iv = null;
                        Object groupId$iv = null;
                        boolean $i$f$executeCommand = false;
                        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(editor2, document, string){
                            final /* synthetic */ Editor $editor$inlined;
                            final /* synthetic */ Document $document$inlined;
                            final /* synthetic */ String $content$inlined;
                            {
                                this.$editor$inlined = editor2;
                                this.$document$inlined = document;
                                this.$content$inlined = string;
                            }

                            public final void run() {
                                boolean bl = false;
                                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                                EditorUtilKt.runForEachCaret(caretModel, true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.$document$inlined, this.$content$inlined){
                                    final /* synthetic */ Document $document;
                                    final /* synthetic */ String $content;
                                    {
                                        this.$document = $document;
                                        this.$content = $content;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Caret caret) {
                                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                                        int offset = caret.getOffset();
                                        this.$document.insertString(offset, (CharSequence)this.$content);
                                        caret.moveToOffset(offset + this.$content.length());
                                    }
                                }));
                            }
                        }, name$iv, groupId$iv);
                    }
                }));
            }
        }));
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getEnableFileDrop()) {
            return false;
        }
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        FileType fileType2 = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        if (MarkdownLanguageUtilsKt.isMarkdownType(fileType2)) {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
            return CopyPasteManager.getInstance().areDataFlavorsAvailable(dataFlavorArray);
        }
        return false;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

