/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetDependencyModel.DefaultGradleSourceSetDependencyModel;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.DefaultGradleTaskModel;
import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelFetchAction;
import com.intellij.gradle.toolingExtension.impl.telemetry.GradleTracingContext;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemOperationDescriptor;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMapper;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.DeprecatedGradleVersionIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultGradleLightBuild;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;
import org.jetbrains.plugins.gradle.model.GradleLightProject;
import org.jetbrains.plugins.gradle.model.GradleSourceSetDependencyModel;
import org.jetbrains.plugins.gradle.model.GradleSourceSetModel;
import org.jetbrains.plugins.gradle.model.GradleTaskModel;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleWrapperHelper;
import org.jetbrains.plugins.gradle.service.modelAction.GradleIdeaModelHolder;
import org.jetbrains.plugins.gradle.service.modelAction.GradleModelFetchActionRunner;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.BaseResolverExtension;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleBuildSrcProjectsResolver;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradlePreviewCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverIndicator;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingInfo;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.syncAction.GradleModelFetchActionResultHandler;
import org.jetbrains.plugins.gradle.service.syncAction.GradleProjectResolverResultHandler;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;
import org.jetbrains.plugins.gradle.util.telemetry.GradleDaemonOpenTelemetryUtil;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolver.class);
    @NotNull
    private final GradleExecutionHelper myHelper;
    @NotNull
    private final GradleLibraryNamesMixer myLibraryNamesMixer;
    @NotNull
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap;
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<MultiMap<ExternalSystemSourceType, String>> GRADLE_OUTPUTS = Key.create((String)"gradleOutputs");
    private static final Key<File> GRADLE_HOME_DIR = Key.create((String)"gradleHomeDir");

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        if (helper == null) {
            GradleProjectResolver.$$$reportNull$$$0(0);
        }
        this.myLibraryNamesMixer = new GradleLibraryNamesMixer();
        this.myCancellationMap = MultiMap.createConcurrent();
        this.myHelper = helper;
    }

    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId syncTaskId, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings2, @Nullable ProjectResolverPolicy resolverPolicy, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (syncTaskId == null) {
            GradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(3);
        }
        GradlePartialResolverPolicy gradleResolverPolicy = null;
        if (resolverPolicy != null) {
            if (resolverPolicy instanceof GradlePartialResolverPolicy) {
                gradleResolverPolicy = (GradlePartialResolverPolicy)resolverPolicy;
            } else {
                throw new ExternalSystemException("Unsupported project resolver policy: " + resolverPolicy.getClass().getName());
            }
        }
        GradleProjectResolverIndicator projectResolverIndicator = new GradleProjectResolverIndicator(ProgressManager.getInstance().getProgressIndicator(), GradleConnector.newCancellationTokenSource());
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(syncTaskId, projectPath, settings2, listener2, gradleResolverPolicy, projectResolverIndicator, false);
        GradleProjectResolverResultHandler resolverResultHandler = new GradleProjectResolverResultHandler(resolverContext);
        return this.computeCancellable(resolverContext, () -> {
            if (isPreviewMode) {
                return GradlePreviewCustomizer.Companion.getCustomizer(resolverContext).resolvePreviewProjectInfo(resolverContext);
            }
            resolverResultHandler.onResolveProjectInfoStarted();
            return this.resolveProjectInfo(resolverContext);
        });
    }

    @Nullable
    private DataNode<ProjectData> resolveProjectInfo(@NotNull DefaultProjectResolverContext resolverContext) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(4);
        }
        long activityId = resolverContext.getExternalSystemTaskId().getId();
        GradleExecutionSettings settings2 = resolverContext.getSettings();
        ExternalSystemSyncActionsCollector.logSyncStarted((Project)resolverContext.getExternalSystemTaskId().findProject(), (long)activityId, (settings2 != null && settings2.isParallelModelFetch() ? 1 : 0) != 0);
        Span gradleExecutionSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleExecution").startSpan();
        try {
            DataNode<ProjectData> dataNode;
            block12: {
                Scope ignore = gradleExecutionSpan.makeCurrent();
                try {
                    if (resolverContext.getSettings() != null) {
                        GradleWrapperHelper.ensureInstalledWrapper(resolverContext.getExternalSystemTaskId(), resolverContext.getProjectPath(), resolverContext.getSettings(), resolverContext.getListener(), resolverContext.getCancellationToken());
                    }
                    GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(resolverContext);
                    Function<ProjectConnection, DataNode<ProjectData>> projectDataFunction = this.getProjectDataFunction(resolverContext, projectResolverChain);
                    DataNode<ProjectData> projectDataNode = this.myHelper.execute(resolverContext.getProjectPath(), resolverContext.getSettings(), resolverContext.getExternalSystemTaskId(), resolverContext.getListener(), resolverContext.getCancellationToken(), projectDataFunction);
                    String gradleVersion2 = resolverContext.getProjectGradleVersion();
                    if (gradleVersion2 != null && GradleVersionUtil.isGradleOlderThan((String)gradleVersion2, (String)"8.0")) {
                        String gradleHome2 = (String)ObjectUtils.doIfNotNull((Object)((File)resolverContext.getUserData(GRADLE_HOME_DIR)), it -> it.getPath());
                        new GradleBuildSrcProjectsResolver(this, resolverContext, gradleHome2, projectResolverChain).discoverAndAppendTo(projectDataNode);
                    }
                    dataNode = projectDataNode;
                    if (ignore == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return dataNode;
        }
        finally {
            gradleExecutionSpan.end();
        }
    }

    @NotNull
    protected Function<ProjectConnection, DataNode<ProjectData>> getProjectDataFunction(@NotNull DefaultProjectResolverContext resolverContext, @NotNull GradleProjectResolverExtension projectResolverChain) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(5);
        }
        if (projectResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(6);
        }
        return new ProjectConnectionDataNodeFunction(resolverContext, projectResolverChain);
    }

    @NotNull
    GradleExecutionHelper getHelper() {
        GradleExecutionHelper gradleExecutionHelper = this.myHelper;
        if (gradleExecutionHelper == null) {
            GradleProjectResolver.$$$reportNull$$$0(7);
        }
        return gradleExecutionHelper;
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(9);
        }
        for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
            cancellationTokenSource.cancel();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R computeCancellable(@NotNull DefaultProjectResolverContext resolverContext, @NotNull Supplier<R> action) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(10);
        }
        if (action == null) {
            GradleProjectResolver.$$$reportNull$$$0(11);
        }
        ExternalSystemTaskId taskId = resolverContext.getExternalSystemTaskId();
        CancellationTokenSource cancellationTokenSource = resolverContext.getCancellationTokenSource();
        this.myCancellationMap.putValue((Object)taskId, (Object)cancellationTokenSource);
        try {
            R r = resolverContext.computeCancellable(action);
            return r;
        }
        finally {
            this.myCancellationMap.remove((Object)taskId, (Object)cancellationTokenSource);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull DefaultProjectResolverContext resolverContext, @NotNull GradleProjectResolverExtension projectResolverChain) throws IllegalArgumentException, IllegalStateException {
        DataNode<ProjectData> dataNode;
        Scope ignore;
        Span projectResolversSpan;
        int projectResolversErrorsCount;
        long projectResolversStartTime;
        long activityId;
        block35: {
            BuildEnvironment buildEnvironment;
            if (resolverContext == null) {
                GradleProjectResolver.$$$reportNull$$$0(12);
            }
            if (projectResolverChain == null) {
                GradleProjectResolver.$$$reportNull$$$0(13);
            }
            if ((buildEnvironment = GradleExecutionHelper.getBuildEnvironment(resolverContext.getConnection(), resolverContext.getExternalSystemTaskId(), resolverContext.getListener(), resolverContext.getCancellationToken(), resolverContext.getSettings())) != null) {
                resolverContext.setBuildEnvironment(buildEnvironment);
            }
            GradleModelFetchAction buildAction = new GradleModelFetchAction();
            GradleExecutionSettings executionSettings = resolverContext.getSettings();
            if (executionSettings == null) {
                executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false);
            }
            GradleProjectResolver.configureExecutionArgumentsAndVmOptions(executionSettings, resolverContext);
            HashSet toolingExtensionClasses = new HashSet();
            for (GradleProjectResolverExtension resolverExtension = projectResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
                resolverExtension.setProjectResolverContext(resolverContext);
                resolverExtension.preImportCheck();
                buildAction.addTargetTypes(resolverExtension.getTargetTypes());
                try {
                    buildAction.addProjectImportModelProviders(resolverExtension.getModelProviders());
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
                try {
                    toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
                    continue;
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
            GradleInitScriptUtil.attachTargetPathMapperInitScript(executionSettings);
            Path initScript = GradleInitScriptUtil.createMainInitScript(resolverContext.isBuildSrcProject(), toolingExtensionClasses);
            executionSettings.withArguments(new String[]{"--init-script", initScript.toString()});
            if (!executionSettings.isDownloadSources()) {
                Path initScriptPath = GradleInitScriptUtil.createIdeaPluginConfiguratorInitScript();
                executionSettings.prependArguments(new String[]{"--init-script", initScriptPath.toString()});
            }
            TargetEnvironmentConfigurationProvider environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)executionSettings);
            PathMapper pathMapper = (PathMapper)ObjectUtils.doIfNotNull((Object)environmentConfigurationProvider, it -> it.getPathMapper());
            GradleIdeaModelHolder models = new GradleIdeaModelHolder(pathMapper, buildEnvironment);
            resolverContext.setModels(models);
            ProgressManager.checkCanceled();
            activityId = resolverContext.getExternalSystemTaskId().getId();
            long gradleCallStartTime = System.currentTimeMillis();
            ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.GRADLE_CALL);
            int gradleCallErrorsCount = 0;
            Span gradleCallSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleCall").startSpan();
            if (GradleDaemonOpenTelemetryUtil.isDaemonTracingEnabled()) {
                GradleTracingContext gradleDaemonObservabilityContext = GradleProjectResolver.getActionTelemetryContext(gradleCallSpan);
                buildAction.setTracingContext(gradleDaemonObservabilityContext);
            }
            try (Scope ignore2 = gradleCallSpan.makeCurrent();){
                GradleModelFetchActionResultHandler modelFetchActionResultHandler = new GradleModelFetchActionResultHandler(resolverContext);
                GradleModelFetchActionRunner.runAndTraceBuildAction(resolverContext, executionSettings, buildAction, modelFetchActionResultHandler);
                GradleVersion gradleVersion2 = (GradleVersion)ObjectUtils.doIfNotNull((Object)resolverContext.getProjectGradleVersion(), it -> GradleVersion.version((String)it));
                if (gradleVersion2 != null && GradleJvmSupportMatrix.isGradleDeprecatedByIdea(gradleVersion2)) {
                    String projectPath = resolverContext.getProjectPath();
                    DeprecatedGradleVersionIssue issue = new DeprecatedGradleVersionIssue(gradleVersion2, projectPath);
                    resolverContext.report(MessageEvent.Kind.WARNING, (BuildIssue)issue);
                }
            }
            catch (Throwable t) {
                gradleCallSpan.setAttribute("error.count", (long)(++gradleCallErrorsCount));
                gradleCallSpan.recordException(t);
                gradleCallSpan.setStatus(StatusCode.ERROR);
                throw t;
            }
            finally {
                long gradleCallTimeInMs = System.currentTimeMillis() - gradleCallStartTime;
                ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.GRADLE_CALL, (long)gradleCallTimeInMs, (int)gradleCallErrorsCount);
                gradleCallSpan.end();
            }
            ProgressManager.checkCanceled();
            projectResolversStartTime = System.currentTimeMillis();
            ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS);
            projectResolversErrorsCount = 0;
            projectResolversSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleProjectResolverDataProcessing").startSpan();
            ignore = projectResolversSpan.makeCurrent();
            GradleProjectResolver.extractExternalProjectModels(models);
            dataNode = this.convertData(executionSettings, resolverContext, projectResolverChain);
            if (ignore == null) break block35;
            ignore.close();
        }
        long projectResolversTimeInMs = System.currentTimeMillis() - projectResolversStartTime;
        LOG.debug(String.format("Project data resolved in %d ms", projectResolversTimeInMs));
        ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS, (long)projectResolversTimeInMs, (int)projectResolversErrorsCount);
        projectResolversSpan.end();
        DataNode<ProjectData> dataNode2 = dataNode;
        if (dataNode2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(14);
        }
        return dataNode2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ++projectResolversErrorsCount;
                        projectResolversSpan.recordException(t);
                        projectResolversSpan.setStatus(StatusCode.ERROR);
                        throw t;
                    }
                }
                catch (Throwable throwable3) {
                    long projectResolversTimeInMs2 = System.currentTimeMillis() - projectResolversStartTime;
                    LOG.debug(String.format("Project data resolved in %d ms", projectResolversTimeInMs2));
                    ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS, (long)projectResolversTimeInMs2, (int)projectResolversErrorsCount);
                    projectResolversSpan.end();
                    throw throwable3;
                }
            }
        }
    }

    @NotNull
    private DataNode<ProjectData> convertData(@NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverContext, @NotNull GradleProjectResolverExtension tracedResolverChain) {
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(16);
        }
        if (tracedResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(17);
        }
        long activityId = resolverContext.getExternalSystemTaskId().getId();
        String projectPath = resolverContext.getProjectPath();
        String projectName = resolverContext.getRootBuild().getName();
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectPath, projectPath);
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        DataNode descriptorDataNode = new DataNode(ExternalSystemOperationDescriptor.OPERATION_DESCRIPTOR_KEY, (Object)new ExternalSystemOperationDescriptor(activityId), projectDataNode);
        projectDataNode.addChild(descriptorDataNode);
        Set<? extends IdeaModule> gradleModules = GradleProjectResolver.extractCollectedModules(resolverContext, (DataNode<ProjectData>)projectDataNode, tracedResolverChain);
        Collection<IdeaModule> includedModules = GradleProjectResolver.exposeCompositeBuild(resolverContext, (DataNode<ProjectData>)projectDataNode);
        HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap = new HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>>();
        HashMap sourceSetsMap = new HashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, sourceSetsMap);
        Map moduleOutputsMap = CollectionFactory.createFilePathMap();
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        ArtifactMappingService artifactsMap = resolverContext.getArtifactsMap();
        for (Object gradleModule : ContainerUtil.concat(gradleModules, includedModules)) {
            ProgressManager.checkCanceled();
            DataNode<ModuleData> moduleDataNode = GradleProjectResolver.createModuleData((IdeaModule)gradleModule, tracedResolverChain, (DataNode<ProjectData>)projectDataNode);
            if (moduleDataNode == null) continue;
            String mainModuleId = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)resolverContext, (IdeaModule)gradleModule);
            if (moduleMap.containsKey(mainModuleId)) {
                throw new IllegalStateException("Attempt to add module with already existing id [" + mainModuleId + "]\n new module: " + (IdeaModule)gradleModule + "\n existing module: " + ((Pair)moduleMap.get((Object)mainModuleId)).second);
            }
            moduleMap.put(mainModuleId, (Pair<DataNode<ModuleData>, IdeaModule>)Pair.create(moduleDataNode, (Object)gradleModule));
        }
        executionSettings.getExecutionWorkspace().setModuleIdIndex(moduleMap);
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            GradleBuildScriptClasspathModel buildScriptClasspathModel;
            DataNode moduleDataNode = (DataNode)pair.first;
            IdeaModule ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = (GradleBuildScriptClasspathModel)resolverContext.getExtraProject(ideaModule, GradleBuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            tracedResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            tracedResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!resolverContext.isBuildSrcProject()) {
                tracedResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            }
            SmartList modules = new SmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile2 : moduleData.getArtifacts()) {
                    artifactsMap.storeModuleId(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile2.getPath()), moduleData.getId());
                }
            }
            GradleSourceSetModel sourceSetModel = resolverContext.getProjectModel((ProjectModel)ideaModule, GradleSourceSetModel.class);
            if (sourceSetModel == null) continue;
            sourceSetModel.getAdditionalArtifacts().forEach(artifactFile -> {
                String path = ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getPath());
                ModuleMappingInfo mapping = artifactsMap.getModuleMapping(path);
                if (mapping != null && "base-gradle".equals(mapping.getOwnerId())) {
                    artifactsMap.markArtifactPath(path, true);
                }
            });
        }
        if (gradleHomeDir == null && executionSettings.getGradleHome() != null) {
            gradleHomeDir = new File(executionSettings.getGradleHome());
        }
        resolverContext.putUserData(GRADLE_HOME_DIR, gradleHomeDir);
        ExternalSystemTelemetryUtil.runWithSpan((ProjectSystemId)GradleConstants.SYSTEM_ID, (String)"PopulateModules", __ -> {
            for (Pair pair : moduleMap.values()) {
                DataNode moduleDataNode = (DataNode)pair.first;
                IdeaModule ideaModule = (IdeaModule)pair.second;
                tracedResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
                tracedResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            }
        });
        GradleProjectResolver.mergeSourceSetContentRoots(moduleMap, resolverContext);
        if (resolverContext.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeLibraryAndModuleDependencyData(resolverContext, (DataNode<ProjectData>)projectDataNode, resolverContext.getGradleUserHome(), gradleHomeDir);
        }
        GradleProjectResolver.processBuildSrcModules(resolverContext, (DataNode<ProjectData>)projectDataNode);
        for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
            resolver.resolveFinished((DataNode<ProjectData>)projectDataNode);
        }
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, null);
        projectDataNode.putUserData(MODULES_OUTPUTS, null);
        Collection libraries = ExternalSystemApiUtil.getChildren((DataNode)projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        DataNode dataNode = projectDataNode;
        if (dataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(18);
        }
        return dataNode;
    }

    @Nullable
    private static DataNode<ModuleData> createModuleData(@Nullable IdeaModule gradleModule, @NotNull GradleProjectResolverExtension resolverChain, @NotNull DataNode<ProjectData> projectDataNode) {
        String moduleName;
        if (resolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(20);
        }
        if (gradleModule == null) {
            return null;
        }
        if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Importing module data: %s", gradleModule));
        }
        if ((moduleName = gradleModule.getName()) == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        return resolverChain.createModule(gradleModule, projectDataNode);
    }

    @NotNull
    private static Set<? extends IdeaModule> extractCollectedModules(@NotNull DefaultProjectResolverContext resolverContext, @NotNull DataNode<ProjectData> projectDataNode, @NotNull GradleProjectResolverExtension resolverChain) {
        IdeaProject ideaProject;
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (resolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(23);
        }
        if ((ideaProject = resolverContext.getRootModel(IdeaProject.class)) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                GradleProjectResolver.$$$reportNull$$$0(24);
            }
            return set;
        }
        resolverChain.populateProjectExtraModels(ideaProject, projectDataNode);
        DomainObjectSet modules = ideaProject.getModules();
        if (modules == null || modules.isEmpty()) {
            throw new IllegalStateException("No modules found for the target project: " + ideaProject);
        }
        DomainObjectSet domainObjectSet = modules;
        if (domainObjectSet == null) {
            GradleProjectResolver.$$$reportNull$$$0(25);
        }
        return domainObjectSet;
    }

    private static void processBuildSrcModules(DefaultProjectResolverContext ctx, DataNode<ProjectData> projectDataNode) {
        DataNode compositeNode = ExternalSystemApiUtil.find(projectDataNode, CompositeBuildData.KEY);
        if (compositeNode == null) {
            return;
        }
        GradleBuildSrcProjectsResolver.Index index = GradleBuildSrcProjectsResolver.prepareIndexes(projectDataNode);
        CompositeBuildData compositeBuildData = (CompositeBuildData)compositeNode.getData();
        for (BuildParticipant participant : compositeBuildData.getCompositeParticipants()) {
            if (!participant.getRootProjectName().endsWith("buildSrc")) continue;
            Set<String> buildSrcProjectPaths = participant.getProjects();
            @NotNull Collection buildClasspathNodes = index.buildClasspathNodesMap().get((Object)Path.of(participant.getRootPath(), new String[0]).getParent());
            @NotNull HashMap<String, DataNode<? extends ModuleData>> buildSrcModules = new HashMap<String, DataNode<? extends ModuleData>>();
            AtomicReference buildSrcModuleNode = new AtomicReference();
            ExternalSystemApiUtil.findAll(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE).stream().filter(node -> buildSrcProjectPaths.contains(((ModuleData)node.getData()).getLinkedExternalProjectPath())).forEach(node -> {
                buildSrcModules.put(((ModuleData)node.getData()).getId(), (DataNode<? extends ModuleData>)node);
                GradleModuleDataKt.setBuildSrcModule((ModuleData)node.getData());
                ExternalSystemApiUtil.findAll((DataNode)node, GradleSourceSetData.KEY).forEach(sourceSetNode -> buildSrcModules.put(((GradleSourceSetData)((Object)((Object)((Object)sourceSetNode.getData())))).getId(), (DataNode<? extends ModuleData>)sourceSetNode));
                if (participant.getRootPath().equals(((ModuleData)node.getData()).getLinkedExternalProjectPath())) {
                    if (ctx.isResolveModulePerSourceSet()) {
                        buildSrcModuleNode.set(ExternalSystemApiUtil.findChild((DataNode)node, GradleSourceSetData.KEY, sourceSetNode -> ((GradleSourceSetData)((Object)((Object)((Object)sourceSetNode.getData())))).getExternalName().endsWith(":main")));
                    } else {
                        buildSrcModuleNode.set(node);
                    }
                }
            });
            GradleBuildSrcProjectsResolver.addBuildSrcToBuildScriptClasspathData(buildClasspathNodes, buildSrcModules, (DataNode<? extends ModuleData>)((DataNode)buildSrcModuleNode.get()));
        }
    }

    private static void configureExecutionArgumentsAndVmOptions(@NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverContext) {
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(26);
        }
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(27);
        }
        executionSettings.withArgument("-Didea.gradle.download.sources=" + executionSettings.isDownloadSources());
        executionSettings.withArgument("-Didea.sync.active=true");
        if (resolverContext.isResolveModulePerSourceSet()) {
            executionSettings.withArgument("-Didea.resolveSourceSetDependencies=true");
        }
        if (executionSettings.isParallelModelFetch()) {
            executionSettings.withArgument("-Didea.parallelModelFetch.enabled=true");
        }
        if (!resolverContext.isBuildSrcProject()) {
            for (GradleBuildParticipant buildParticipant : executionSettings.getExecutionWorkspace().getBuildParticipants()) {
                executionSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
        }
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        GradleProjectResolverUtil.createProjectResolvers(resolverContext).forEachOrdered(extension -> {
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                ParametersList parametersList = new ParametersList();
                for (Pair<String, String> jvmArg : extension.getExtraJvmArgs()) {
                    parametersList.addProperty((String)jvmArg.first, (String)jvmArg.second);
                }
                executionSettings.withVmOptions(parametersList.getParameters());
            }
            executionSettings.withArguments(extension.getExtraCommandLineArgs());
        });
    }

    @NotNull
    private static Collection<IdeaModule> exposeCompositeBuild(@NotNull DefaultProjectResolverContext resolverContext, @NotNull DataNode<ProjectData> projectDataNode) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(28);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(29);
        }
        if (resolverContext.getSettings() != null && !resolverContext.getSettings().getExecutionWorkspace().getBuildParticipants().isEmpty()) {
            List<IdeaModule> list2 = Collections.emptyList();
            if (list2 == null) {
                GradleProjectResolver.$$$reportNull$$$0(30);
            }
            return list2;
        }
        SmartList gradleIncludedModules = new SmartList();
        Collection<? extends GradleLightBuild> includedBuilds = resolverContext.getNestedBuilds();
        if (!includedBuilds.isEmpty()) {
            ProjectData projectData = (ProjectData)projectDataNode.getData();
            CompositeBuildData compositeBuildData = new CompositeBuildData(projectData.getLinkedExternalProjectPath());
            for (GradleLightBuild gradleLightBuild : includedBuilds) {
                if (gradleLightBuild.getProjects().isEmpty()) continue;
                IdeaProject ideaProject = resolverContext.getBuildModel((BuildModel)gradleLightBuild, IdeaProject.class);
                if (ideaProject != null) {
                    gradleIncludedModules.addAll(ideaProject.getModules());
                }
                String rootProjectName = gradleLightBuild.getName();
                BuildParticipant buildParticipant = new BuildParticipant();
                String projectPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleLightBuild.getBuildIdentifier().getRootDir().getPath());
                String parentPath = gradleLightBuild.getParentBuildIdentifier() != null ? ExternalSystemApiUtil.toCanonicalPath((String)gradleLightBuild.getParentBuildIdentifier().getRootDir().getPath()) : null;
                buildParticipant.setRootProjectName(rootProjectName);
                buildParticipant.setRootPath(projectPath);
                buildParticipant.setParentRootPath(parentPath);
                if (ideaProject != null) {
                    for (IdeaModule module : ideaProject.getModules()) {
                        String modulePath = ExternalSystemApiUtil.toCanonicalPath((String)module.getGradleProject().getProjectDirectory().getPath());
                        buildParticipant.getProjects().add(modulePath);
                    }
                }
                compositeBuildData.getCompositeParticipants().add(buildParticipant);
            }
            projectDataNode.createChild(CompositeBuildData.KEY, (Object)compositeBuildData);
        }
        SmartList smartList = gradleIncludedModules;
        if (smartList == null) {
            GradleProjectResolver.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    private static void mergeLibraryAndModuleDependencyData(@NotNull ProjectResolverContext context, @NotNull DataNode<ProjectData> projectDataNode, @NotNull File gradleUserHomeDir, @Nullable File gradleHomeDir) {
        if (context == null) {
            GradleProjectResolver.$$$reportNull$$$0(32);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(33);
        }
        if (gradleUserHomeDir == null) {
            GradleProjectResolver.$$$reportNull$$$0(34);
        }
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        ArtifactMappingService artifactsMap = context.getArtifactsMap();
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(context, gradleUserHomeDir, gradleHomeDir, sourceSetMap, moduleOutputsMap, artifactsMap);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run((DataNode<LibraryDependencyData>)libraryDependencyDataNode);
        }
    }

    private static void extractExternalProjectModels(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(35);
        }
        GradleProjectResolver.replicateBuildModelHierarchyInExternalProjectHierarchy(models);
        GradleProjectResolver.replicateProjectModelHierarchyInExternalProjectHierarchy(models);
        GradleProjectResolver.associateSourceSetModelsWithExternalProjects(models);
        GradleProjectResolver.associateSourceSetDependencyModelsWithSourceSetModels(models);
        GradleProjectResolver.associateTaskModelsWithExternalProjects(models);
    }

    private static void replicateBuildModelHierarchyInExternalProjectHierarchy(@NotNull GradleIdeaModelHolder models) {
        GradleLightBuild rootBuildModel;
        GradleLightProject rootProjectModel;
        DefaultExternalProject rootExternalProject;
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(36);
        }
        if ((rootExternalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)(rootProjectModel = (rootBuildModel = models.getRootBuild()).getRootProject()), ExternalProject.class)) == null) {
            return;
        }
        for (GradleLightBuild nestedBuildModel : models.getNestedBuilds()) {
            GradleLightProject projectModel = nestedBuildModel.getRootProject();
            DefaultExternalProject externalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)projectModel, ExternalProject.class);
            if (externalProject == null) continue;
            rootExternalProject.addChildProject(externalProject);
        }
    }

    private static void replicateProjectModelHierarchyInExternalProjectHierarchy(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(37);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            DefaultGradleLightBuild.replicateModelHierarchy((Object)buildModel.getRootProject(), it -> (DefaultExternalProject)models.getProjectModel((ProjectModel)it, ExternalProject.class), GradleLightProject::getChildProjects, DefaultExternalProject::addChildProject);
        }
    }

    private static void associateSourceSetModelsWithExternalProjects(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(38);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            for (GradleLightProject projectModel : buildModel.getProjects()) {
                DefaultExternalProject externalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)projectModel, ExternalProject.class);
                DefaultGradleSourceSetModel sourceSetModel = (DefaultGradleSourceSetModel)models.getProjectModel((ProjectModel)projectModel, GradleSourceSetModel.class);
                if (externalProject == null || sourceSetModel == null) continue;
                externalProject.setSourceSetModel(sourceSetModel);
            }
        }
    }

    private static void associateSourceSetDependencyModelsWithSourceSetModels(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(39);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            for (GradleLightProject projectModel : buildModel.getProjects()) {
                DefaultGradleSourceSetModel sourceSetModel = (DefaultGradleSourceSetModel)models.getProjectModel((ProjectModel)projectModel, GradleSourceSetModel.class);
                DefaultGradleSourceSetDependencyModel sourceSetDependencyModel = (DefaultGradleSourceSetDependencyModel)models.getProjectModel((ProjectModel)projectModel, GradleSourceSetDependencyModel.class);
                if (sourceSetModel == null || sourceSetDependencyModel == null) continue;
                Map sourceSets = sourceSetModel.getSourceSets();
                Map dependencies = sourceSetDependencyModel.getDependencies();
                LinkedHashSet sourceSetNames = new LinkedHashSet(sourceSets.keySet());
                sourceSetNames.retainAll(dependencies.keySet());
                for (String sourceSetName : sourceSetNames) {
                    DefaultExternalSourceSet sourceSet = (DefaultExternalSourceSet)sourceSets.get(sourceSetName);
                    Collection sourceSetDependencies = (Collection)dependencies.get(sourceSetName);
                    sourceSet.setDependencies(sourceSetDependencies);
                }
            }
        }
    }

    private static void associateTaskModelsWithExternalProjects(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(40);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            for (GradleLightProject projectModel : buildModel.getProjects()) {
                DefaultExternalProject externalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)projectModel, ExternalProject.class);
                DefaultGradleTaskModel taskModel = (DefaultGradleTaskModel)models.getProjectModel((ProjectModel)projectModel, GradleTaskModel.class);
                if (externalProject == null || taskModel == null) continue;
                externalProject.setTaskModel(taskModel);
            }
        }
    }

    private static void mergeSourceSetContentRoots(@NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap, @NotNull ProjectResolverContext resolverContext) {
        DataNode moduleNode;
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(41);
        }
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(42);
        }
        HashMap<String, Counter> weightMap = new HashMap<String, Counter>();
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                    weightMap.computeIfAbsent(file.getPath(), __ -> new Counter()).increment();
                }
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                HashSet<String> set = new HashSet<String>();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                        set.add(file.getPath());
                    }
                }
                for (String path : set) {
                    weightMap.computeIfAbsent(path, __ -> new Counter()).increment();
                }
            }
        }
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            ExternalProject externalProject = resolverContext.getExtraProject((IdeaModule)pair.second, ExternalProject.class);
            if (externalProject == null) continue;
            GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)moduleNode);
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)sourceSetNode);
            }
        }
    }

    private static void mergeModuleContentRoots(@NotNull Map<String, Counter> weightMap, @NotNull ExternalProject externalProject, @NotNull DataNode<? extends ModuleData> moduleNode) {
        if (weightMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(43);
        }
        if (externalProject == null) {
            GradleProjectResolver.$$$reportNull$$$0(44);
        }
        if (moduleNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(45);
        }
        File buildDir = externalProject.getBuildDir();
        MultiMap sourceSetRoots = MultiMap.create();
        Collection contentRootNodes = ExternalSystemApiUtil.findAll(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootNodes.size() <= 1) {
            return;
        }
        for (DataNode contentRootNode : contentRootNodes) {
            File root = new File(((ContentRootData)contentRootNode.getData()).getRootPath());
            if (FileUtil.isAncestor((File)buildDir, (File)root, (boolean)true)) continue;
            while (weightMap.containsKey(root.getParent()) && weightMap.get((Object)root.getParent()).count <= 1) {
                root = root.getParentFile();
            }
            ContentRootData mergedContentRoot = null;
            String rootPath = ExternalSystemApiUtil.toCanonicalPath((String)root.getPath());
            HashSet paths = new HashSet(sourceSetRoots.keySet());
            for (String path : paths) {
                if (FileUtil.isAncestor((String)rootPath, (String)path, (boolean)true)) {
                    Collection values = sourceSetRoots.remove((Object)path);
                    if (values != null) {
                        sourceSetRoots.putValues((Object)rootPath, values);
                    }
                } else if (FileUtil.isAncestor((String)path, (String)rootPath, (boolean)false)) {
                    Collection contentRoots = sourceSetRoots.get((Object)path);
                    for (ContentRootData rootData : contentRoots) {
                        if (!StringUtil.equals((CharSequence)rootData.getRootPath(), (CharSequence)path)) continue;
                        mergedContentRoot = rootData;
                        break;
                    }
                    if (mergedContentRoot != null) break;
                    mergedContentRoot = (ContentRootData)contentRoots.iterator().next();
                    break;
                }
                if (sourceSetRoots.size() != 1) continue;
                break;
            }
            if (mergedContentRoot == null) {
                mergedContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, root.getPath());
                sourceSetRoots.putValue((Object)mergedContentRoot.getRootPath(), (Object)mergedContentRoot);
            }
            for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                ContentRootData rootData;
                rootData = ((ContentRootData)contentRootNode.getData()).getPaths(externalSystemSourceType).iterator();
                while (rootData.hasNext()) {
                    ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)rootData.next();
                    mergedContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                }
            }
            contentRootNode.clear(true);
        }
        for (Map.Entry entry : sourceSetRoots.entrySet()) {
            String rootPath = (String)entry.getKey();
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootPath);
            for (ContentRootData rootData : (Collection)entry.getValue()) {
                for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                    Collection roots = rootData.getPaths(externalSystemSourceType);
                    for (ContentRootData.SourceRoot sourceRoot : roots) {
                        ideContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                    }
                }
            }
            moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private static Throwable extractCause(Throwable e) {
        if (e instanceof BuildActionFailureException) {
            return GradleProjectResolver.extractCause(e.getCause());
        }
        Class<?> exceptionClass = e.getClass();
        if (exceptionClass.getName().equals(ProjectConfigurationException.class.getName())) {
            try {
                List causes = (List)exceptionClass.getMethod("getCauses", new Class[0]).invoke((Object)e, new Object[0]);
                return (Throwable)causes.get(0);
            }
            catch (Throwable ignore) {
                return e;
            }
        }
        return e;
    }

    @ApiStatus.Experimental
    public static GradleProjectResolverExtension createProjectResolverChain() {
        return GradleProjectResolver.createProjectResolverChain(null);
    }

    @NotNull
    private static GradleProjectResolverExtension createProjectResolverChain(@Nullable DefaultProjectResolverContext resolverContext) {
        GradleProjectResolverExtension firstResolver;
        Predicate<GradleProjectResolverExtension> extensionsFilter = resolverContext == null ? __ -> true : (resolverContext.getPolicy() == null ? __ -> true : resolverContext.getPolicy().getExtensionsFilter());
        Stream<GradleProjectResolverExtension> extensions = GradleProjectResolverUtil.createProjectResolvers(resolverContext).filter(extensionsFilter.or(BaseResolverExtension.class::isInstance));
        ArrayDeque deque = new ArrayDeque();
        extensions.forEachOrdered(extension -> {
            GradleProjectResolverExtension previous = (GradleProjectResolverExtension)deque.peekLast();
            if (previous != null) {
                previous.setNext((GradleProjectResolverExtension)extension);
                if (previous.getNext() != extension) {
                    throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                }
            }
            deque.add(extension);
        });
        GradleProjectResolverExtension resolverExtension = firstResolver = (GradleProjectResolverExtension)deque.peekFirst();
        assert (resolverExtension != null);
        while (resolverExtension.getNext() != null) {
            resolverExtension = resolverExtension.getNext();
        }
        if (!(resolverExtension instanceof BaseResolverExtension)) {
            throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
        }
        AbstractProjectResolverExtension chainWrapper = new AbstractProjectResolverExtension(){

            @Override
            @NotNull
            public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
                if (error == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (projectPath == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemException friendlyError = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
                ExternalSystemException externalSystemException = new BaseProjectImportErrorHandler().checkErrorsWithoutQuickFixes(buildEnvironment, error, projectPath, buildFilePath, friendlyError);
                if (externalSystemException == null) {
                    1.$$$reportNull$$$0(2);
                }
                return externalSystemException;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUserFriendlyError";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUserFriendlyError";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
        chainWrapper.setNext(firstResolver);
        AbstractProjectResolverExtension abstractProjectResolverExtension = chainWrapper;
        if (abstractProjectResolverExtension == null) {
            GradleProjectResolver.$$$reportNull$$$0(46);
        }
        return abstractProjectResolverExtension;
    }

    @NotNull
    private static GradleTracingContext getActionTelemetryContext(@NotNull Span span) {
        if (span == null) {
            GradleProjectResolver.$$$reportNull$$$0(47);
        }
        GradleTracingContext context = new GradleTracingContext();
        GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator().inject(Context.current().with((ImplicitContextKeyed)span), (Object)context, GradleTracingContext.SETTER);
        GradleTracingContext gradleTracingContext = context;
        if (gradleTracingContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(48);
        }
        return gradleTracingContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14, 18, 24, 25, 30, 31, 46, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: 
            case 21: 
            case 27: 
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 7: 
            case 14: 
            case 18: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracedResolverChain";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverChain";
                break;
            }
            case 20: 
            case 22: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleUserHomeDir";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weightMap";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProjectInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertData";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCollectedModules";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "exposeCompositeBuild";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectResolverChain";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTelemetryContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDataFunction";
                break;
            }
            case 7: 
            case 14: 
            case 18: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 46: 
            case 48: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeCancellable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProjectInfo";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createModuleData";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractCollectedModules";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "configureExecutionArgumentsAndVmOptions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "exposeCompositeBuild";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mergeLibraryAndModuleDependencyData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "extractExternalProjectModels";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replicateBuildModelHierarchyInExternalProjectHierarchy";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "replicateProjectModelHierarchyInExternalProjectHierarchy";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "associateSourceSetModelsWithExternalProjects";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "associateSourceSetDependencyModelsWithSourceSetModels";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "associateTaskModelsWithExternalProjects";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRoots";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mergeModuleContentRoots";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getActionTelemetryContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 14, 18, 24, 25, 30, 31, 46, 48 -> new IllegalStateException(string2);
        };
    }

    private final class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        @NotNull
        private final DefaultProjectResolverContext myResolverContext;

        private ProjectConnectionDataNodeFunction(@NotNull DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain) {
            if (resolverContext == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(0);
            }
            if (projectResolverChain == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(1);
            }
            this.myResolverContext = resolverContext;
            this.myProjectResolverChain = projectResolverChain;
        }

        @NotNull
        public DataNode<ProjectData> fun(@NotNull ProjectConnection connection) {
            if (connection == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(2);
            }
            ExternalSystemTaskId taskId = this.myResolverContext.getExternalSystemTaskId();
            long activityId = taskId.getId();
            DataNode dataNode = GradleProjectResolver.this.computeCancellable(this.myResolverContext, () -> {
                try {
                    this.myResolverContext.setConnection(connection);
                    return GradleProjectResolver.this.doResolveProjectInfo(this.myResolverContext, this.myProjectResolverChain);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.info("Gradle project resolve error", (Throwable)e);
                    ExternalSystemException esException = (ExternalSystemException)((Object)((Object)ExceptionUtil.findCause((Throwable)e, ExternalSystemException.class)));
                    if (esException != null && esException != e) {
                        LOG.info("\nCaused by: " + esException.getOriginalReason());
                    }
                    ExternalSystemSyncActionsCollector.logError((Project)taskId.findProject(), (long)activityId, (Throwable)GradleProjectResolver.extractCause(e));
                    ExternalSystemSyncActionsCollector.logSyncFinished((Project)taskId.findProject(), (long)activityId, (boolean)false);
                    throw this.myProjectResolverChain.getUserFriendlyError(this.myResolverContext.getBuildEnvironment(), e, this.myResolverContext.getProjectPath(), null);
                }
            });
            if (dataNode == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(3);
            }
            return dataNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolverContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectResolverChain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class Counter {
        int count;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }
}

