/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesFile;", "", "()V", "findAndMergeProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleProperties;", "possiblePropertiesFiles", "", "Ljava/nio/file/Path;", "getGradleHomePropertiesPath", "getGradleProjectPropertiesPath", "kotlin.jvm.PlatformType", "projectPath", "getGradleServiceDirectoryPath", "project", "Lcom/intellij/openapi/project/Project;", "serviceDirectoryStr", "", "getPossiblePropertiesFiles", "getProperties", "loadGradleProperties", "propertiesPath", "mergeGradleProperties", "most", "other", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradlePropertiesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n2206#2,7:106\n1#3:113\n*S KotlinDebug\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n*L\n38#1:106,7\n*E\n"})
public final class GradlePropertiesFile {
    @NotNull
    public static final GradlePropertiesFile INSTANCE = new GradlePropertiesFile();

    private GradlePropertiesFile() {
    }

    @JvmStatic
    @NotNull
    public static final GradleProperties getProperties(@NotNull Project project2, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return INSTANCE.findAndMergeProperties(INSTANCE.getPossiblePropertiesFiles(project2, projectPath));
    }

    @NotNull
    public final GradleProperties getProperties(@Nullable String serviceDirectoryStr, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.findAndMergeProperties(this.getPossiblePropertiesFiles(serviceDirectoryStr, projectPath));
    }

    /*
     * WARNING - void declaration
     */
    private final GradleProperties findAndMergeProperties(List<? extends Path> possiblePropertiesFiles) {
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possiblePropertiesFiles), (Function1)findAndMergeProperties.1.INSTANCE), (Function1)((Function1)new Function1<Path, GradleProperties>((Object)this){

            @NotNull
            public final GradleProperties invoke(@NotNull Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GradlePropertiesFile.access$loadGradleProperties((GradlePropertiesFile)this.receiver, p0);
            }
        }));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            GradleProperties gradleProperties = (GradleProperties)iterator$iv.next();
            GradleProperties p0 = (GradleProperties)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.mergeGradleProperties(p0, (GradleProperties)p1);
        }
        return (GradleProperties)accumulator$iv;
    }

    private final List<Path> getPossiblePropertiesFiles(Project project2, Path projectPath) {
        Object[] objectArray = new Path[]{this.getGradleServiceDirectoryPath(project2), this.getGradleHomePropertiesPath(), this.getGradleProjectPropertiesPath(projectPath)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final List<Path> getPossiblePropertiesFiles(String serviceDirectoryStr, Path projectPath) {
        Object[] objectArray = new Path[]{this.getGradleServiceDirectoryPath(serviceDirectoryStr), this.getGradleHomePropertiesPath(), this.getGradleProjectPropertiesPath(projectPath)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final Path getGradleServiceDirectoryPath(Project project2) {
        String string2 = GradleLocalSettings.getInstance(project2).getGradleUserHome();
        if (string2 == null) {
            return null;
        }
        String gradleUserHome2 = string2;
        String[] stringArray = new String[]{"gradle.properties"};
        return Paths.get(gradleUserHome2, stringArray);
    }

    private final Path getGradleServiceDirectoryPath(String serviceDirectoryStr) {
        Path path;
        String string2 = serviceDirectoryStr;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String[] stringArray = new String[]{"gradle.properties"};
            path = Paths.get(serviceDirectoryStr, stringArray);
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final Path getGradleHomePropertiesPath() {
        String gradleUserHome2 = Environment.Companion.getVariable("GRADLE_USER_HOME");
        if (gradleUserHome2 != null) {
            String[] stringArray = new String[]{"gradle.properties"};
            return Paths.get(gradleUserHome2, stringArray);
        }
        String userHome = Environment.Companion.getProperty("user.home");
        if (userHome != null) {
            String[] stringArray = new String[]{".gradle", "gradle.properties"};
            return Paths.get(userHome, stringArray);
        }
        return null;
    }

    private final Path getGradleProjectPropertiesPath(Path projectPath) {
        return projectPath.resolve("gradle.properties");
    }

    private final GradleProperties loadGradleProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return GradleProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        return new GradlePropertiesImpl(PropertyKt.getStringProperty(properties2, "org.gradle.java.home", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.logging.level", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.parallel", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.unsafe.isolated-projects", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.jvmargs", propertiesPath));
    }

    private final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        GradleProperties gradleProperties;
        if (most instanceof GradleProperties.EMPTY) {
            gradleProperties = other;
        } else if (other instanceof GradleProperties.EMPTY) {
            gradleProperties = most;
        } else {
            Property<String> property2;
            Property<Boolean> property3;
            Property<Boolean> property4;
            Property<String> property5;
            Property<String> property6 = most.getJavaHomeProperty();
            if (property6 == null) {
                property6 = other.getJavaHomeProperty();
            }
            if ((property5 = most.getGradleLoggingLevel()) == null) {
                property5 = other.getGradleLoggingLevel();
            }
            if ((property4 = most.getParallel()) == null) {
                property4 = other.getParallel();
            }
            if ((property3 = most.getIsolatedProjects()) == null) {
                property3 = other.getIsolatedProjects();
            }
            if ((property2 = most.getJvmOptions()) == null) {
                property2 = other.getJvmOptions();
            }
            gradleProperties = new GradlePropertiesImpl(property6, property5, property4, property3, property2);
        }
        return gradleProperties;
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(GradlePropertiesFile $this, Path propertiesPath) {
        return $this.loadGradleProperties(propertiesPath);
    }
}

