/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.autolink;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/autolink/GradleUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/NonNls;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLinkedProject", "externalProjectPath", "", "linkAndLoadProjectAsync", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.gradle"})
public final class GradleUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId;

    public GradleUnlinkedProjectAware() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        this.systemId = projectSystemId;
    }

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean isBuildFile(@NotNull Project project2, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return GradleConstants.KNOWN_GRADLE_FILES.contains(buildFile.getName());
    }

    public boolean isLinkedProject(@NotNull Project project2, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        GradleSettings gradleSettings = GradleSettings.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        GradleProjectSettings projectSettings = (GradleProjectSettings)gradleSettings2.getLinkedProjectSettings(externalProjectPath2);
        return projectSettings != null;
    }

    public void subscribe(@NotNull Project project2, @NotNull ExternalSystemProjectLinkListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        GradleSettings gradleSettings = GradleSettings.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        gradleSettings2.subscribe((ExternalSystemSettingsListener<GradleProjectSettings>)((ExternalSystemSettingsListener)new GradleSettingsListener(listener2){
            final /* synthetic */ ExternalSystemProjectLinkListener $listener;
            {
                this.$listener = $listener;
            }

            /*
             * WARNING - void declaration
             */
            public void onProjectsLinked(@NotNull Collection<? extends GradleProjectSettings> settings2) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(settings2, (String)"settings");
                Iterable iterable = settings2;
                ExternalSystemProjectLinkListener externalSystemProjectLinkListener = this.$listener;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    GradleProjectSettings it = (GradleProjectSettings)((Object)element$iv);
                    boolean bl = false;
                    String string2 = it.getExternalProjectPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalProjectPath(...)");
                    externalSystemProjectLinkListener.onProjectLinked(string2);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(linkedProjectPaths, (String)"linkedProjectPaths");
                Iterable iterable = linkedProjectPaths;
                ExternalSystemProjectLinkListener externalSystemProjectLinkListener = this.$listener;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    externalSystemProjectLinkListener.onProjectUnlinked(it);
                }
            }
        }), parentDisposable);
    }

    @Nullable
    public Object linkAndLoadProjectAsync(@NotNull Project project2, @NotNull String externalProjectPath2, @NotNull Continuation<? super Unit> $completion) {
        Object object = GradleProjectImportUtil.linkAndSyncGradleProject(project2, externalProjectPath2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

