/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\fJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*J\u0006\u0010,\u001a\u00020*J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R.\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/Map;)V", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getFields", "()Ljava/util/Map;", "upValues", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getUpValues", "superWrapperClass", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "getKotlinName", "", "declaringClassName", "methodName", "getIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "method", "Ljava/lang/reflect/Method;", "getEqualsFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getHashCodeFunction", "getToStringFunction", "createToStringIrCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "toString", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Common.kt\norg/jetbrains/kotlin/ir/interpreter/state/Common\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,67:1\n669#2,11:68\n350#3,12:79\n350#3,12:91\n350#3,12:103\n*S KotlinDebug\n*F\n+ 1 Common.kt\norg/jetbrains/kotlin/ir/interpreter/state/Common\n*L\n40#1:68,11\n48#1:79,12\n52#1:91,12\n56#1:103,12\n*E\n"})
public final class Common
implements Complex,
StateWithClosure {
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final Map<IrSymbol, Variable> upValues;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;

    private Common(IrClass irClass, Map<IrSymbol, State> fields) {
        this.irClass = irClass;
        this.fields = fields;
        this.upValues = new LinkedHashMap();
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public Map<IrSymbol, Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    public Common(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this(irClass, new LinkedHashMap());
    }

    private final String getKotlinName(String declaringClassName, String methodName) {
        return Intrinsics.areEqual((Object)declaringClassName, (Object)"java.lang.CharSequence") && Intrinsics.areEqual((Object)methodName, (Object)"charAt") ? "get" : methodName;
    }

    @Nullable
    public final IrFunction getIrFunction(@NotNull Method method) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            String string = method.getDeclaringClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String methodName = this.getKotlinName(string, string2);
            Iterable $this$singleOrNull$iv = this.getIrClass().getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrDeclarationWithName && Intrinsics.areEqual((Object)((IrDeclarationWithName)it).getName().asString(), (Object)methodName))) continue;
                if (found$iv) {
                    v2 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrDeclaration declaration = v2;
        return declaration instanceof IrProperty ? (IrFunction)((IrProperty)declaration).getGetter() : (declaration instanceof IrFunction ? (IrFunction)declaration : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunction getEqualsFunction() {
        void var3_3;
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(this.getIrClass());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!IrUtilsKt.isEquals(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return IrFakeOverrideUtilsKt.getTarget((IrSimpleFunction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunction getHashCodeFunction() {
        void var3_3;
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(this.getIrClass());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!IrUtilsKt.isHashCode(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return IrFakeOverrideUtilsKt.getTarget((IrSimpleFunction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunction getToStringFunction() {
        void var3_3;
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(this.getIrClass());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!IrUtilsKt.isToString(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return IrFakeOverrideUtilsKt.getTarget((IrSimpleFunction)var3_3);
    }

    @NotNull
    public final IrCall createToStringIrCall() {
        return IrTreeBuildUtilsKt.createCall$default(this.getToStringFunction(), null, 1, null);
    }

    @NotNull
    public String toString() {
        return "Common(obj='" + UtilsKt.getFqName(this.getIrClass()) + "', values=" + this.getFields() + ')';
    }
}

