/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public final class ResultsToFileProcessor {
    private static final Logger LOG = Logger.getInstance(ResultsToFileProcessor.class);

    public static void writeMetricsToJson(Path jsonPath, String name, @Nullable Integer value, @Nullable Long startTime) {
        String stringToWrite;
        if (value != null && startTime != null) {
            stringToWrite = String.format("{\"%s_count\":%d,\"%1$s_time\":%d}", name, value, System.currentTimeMillis() - startTime);
        } else if (startTime != null) {
            stringToWrite = String.format("{\"%s_time\":%d}", name, System.currentTimeMillis() - startTime);
        } else if (value != null) {
            stringToWrite = String.format("{\"%s_count\":%d}", name, value);
        } else {
            LOG.error("value or startTime has to be provided");
            return;
        }
        try {
            File file = jsonPath.toFile();
            if (file.length() != 0L) {
                String fileContent = String.valueOf(FileUtil.loadFileText((File)file)).replace("\n", "").replace("\t", "");
                stringToWrite = new String(fileContent.substring(0, fileContent.length() - 1) + stringToWrite.replace("{", ","));
            }
            FileUtil.writeToFile((File)file, (String)stringToWrite);
        }
        catch (IOException ex) {
            LOG.error("Could not create json file " + jsonPath + " with the performance metrics.");
        }
    }
}

