/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.commands.PerformanceCommand;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.DataDumper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CompletionCommand
extends PerformanceCommand {
    public static final String NAME = "doComplete";
    public static final String PREFIX = "%doComplete";
    public static final String SPAN_NAME = "completion";
    private static final String DUMP_COMPLETION_ITEMS_DIR = "completion.command.report.dir";
    private static final Logger LOG = Logger.getInstance(CompletionCommand.class);

    public CompletionCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            CompletionCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    private CompletionType getCompletionType() {
        String completionTypeArg;
        switch (completionTypeArg = this.getArgument(0)) {
            case "SMART": {
                LOG.info(String.format("'%s' was passed as argument, so SMART completion will be used", completionTypeArg));
                return CompletionType.SMART;
            }
        }
        LOG.info(String.format("'%s' was passed as argument, so BASIC completion will be used", completionTypeArg));
        return CompletionType.BASIC;
    }

    private String getArgument(int index) {
        String[] completionArgs = this.extractCommandArgument(PREFIX).trim().toUpperCase().split(" ");
        if (completionArgs.length > index) {
            return completionArgs[index];
        }
        return "";
    }

    @Override
    protected String getName() {
        return NAME;
    }

    public Editor getEditor(PlaybackContext context) {
        return FileEditorManager.getInstance((Project)context.getProject()).getSelectedTextEditor();
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            CompletionCommand.$$$reportNull$$$0(1);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        final Disposable listenerDisposable = Disposer.newDisposable();
        final Ref span = new Ref();
        final Ref scope = new Ref();
        final Ref completionTimeStarted = new Ref();
        final AtomicBoolean lookupListenerInited = new AtomicBoolean(false);
        ApplicationManager.getApplication().getMessageBus().connect(listenerDisposable).subscribe(CompletionPhaseListener.TOPIC, (Object)new CompletionPhaseListener(){

            public void completionPhaseChanged(boolean isCompletionRunning) {
                Editor editor2 = CompletionCommand.this.getEditor(context);
                LookupEx lookup = LookupManager.getActiveLookup((Editor)editor2);
                if (lookup != null && !lookupListenerInited.get()) {
                    lookup.addLookupListener(new LookupListener(){

                        public void firstElementShown() {
                            ((Span)span.get()).setAttribute("firstElementShown", System.currentTimeMillis() - (Long)completionTimeStarted.get());
                        }
                    });
                    lookupListenerInited.set(true);
                }
                if (!(isCompletionRunning || CompletionServiceImpl.isPhase((Class[])new Class[]{CompletionPhase.CommittingDocuments.class}) || span.isNull())) {
                    if (CompletionServiceImpl.getCurrentCompletionProgressIndicator() == null) {
                        String description = "CompletionServiceImpl.getCurrentCompletionProgressIndicator() is null on " + CompletionServiceImpl.getCompletionPhase();
                        ((Span)span.get()).setStatus(StatusCode.ERROR, description);
                        actionCallback.reject(description);
                    } else {
                        List items = CompletionServiceImpl.getCurrentCompletionProgressIndicator().getLookup().getItems();
                        int size = items.size();
                        ((Span)span.get()).setAttribute("number", (long)size);
                        ((Span)span.get()).end();
                        ((Scope)scope.get()).close();
                        context.message("Number of elements: " + size, CompletionCommand.this.getLine());
                        Path dir = CompletionCommand.getCompletionItemsDir();
                        if (dir != null) {
                            CompletionCommand.this.dumpCompletionVariants(items, dir);
                        }
                        actionCallback.setDone();
                    }
                    Disposer.dispose((Disposable)listenerDisposable);
                }
            }
        });
        ApplicationManager.getApplication().invokeLater(Context.current().wrap(() -> {
            Project project = context.getProject();
            Editor editor2 = this.getEditor(context);
            span.set((Object)this.startSpan(SPAN_NAME));
            scope.set((Object)((Span)span.get()).makeCurrent());
            completionTimeStarted.set((Object)System.currentTimeMillis());
            new CodeCompletionHandlerBase(this.getCompletionType(), true, false, true).invokeCompletion(project, editor2);
        }));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            CompletionCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @Nullable
    public static Path getCompletionItemsDir() {
        String property = System.getProperty(DUMP_COMPLETION_ITEMS_DIR);
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        return null;
    }

    private void dumpCompletionVariants(List<LookupElement> item, @NotNull Path reportPath) {
        if (reportPath == null) {
            CompletionCommand.$$$reportNull$$$0(3);
        }
        File dir = reportPath.toFile();
        dir.mkdirs();
        File file = new File(dir, this.createTestReportFilename());
        CompletionItemsReport report = new CompletionItemsReport(ContainerUtil.map(item, CompletionVariant::fromLookUp));
        DataDumper.dump(report, file.toPath());
    }

    @NotNull
    private String createTestReportFilename() {
        String string = "completion-" + this.getCompletionType() + "-" + System.currentTimeMillis() + (this.isWarmupMode() != false ? "_warmup" : "") + ".txt";
        if (string == null) {
            CompletionCommand.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/CompletionCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/CompletionCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestReportFilename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dumpCompletionVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static final class CompletionItemsReport {
        public final int totalNumber;
        public final List<CompletionVariant> items;

        @JsonCreator
        public CompletionItemsReport(@JsonProperty(value="items") @NotNull List<CompletionVariant> items) {
            if (items == null) {
                CompletionItemsReport.$$$reportNull$$$0(0);
            }
            this.totalNumber = items.size();
            this.items = items;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/performancePlugin/commands/CompletionCommand$CompletionItemsReport", "<init>"));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class CompletionVariant {
        @JsonProperty
        private final String name;

        @JsonCreator
        private CompletionVariant(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static CompletionVariant fromLookUp(LookupElement element2) {
            return new CompletionVariant(element2.getLookupString());
        }
    }
}

