/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalSettingsLoading;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;
import org.jetbrains.jps.model.serialization.impl.JpsSerializationViaWorkspaceModel;

public final class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull String projectPath, @Nullable String optionsPath, boolean loadUnloadedModules) throws IOException {
        JpsSerializationViaWorkspaceModel serializationViaWorkspaceModel;
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(0);
        }
        if ((serializationViaWorkspaceModel = JpsSerializationViaWorkspaceModel.getInstance()) != null) {
            JpsModel jpsModel = serializationViaWorkspaceModel.loadModel(projectPath, optionsPath, loadUnloadedModules);
            if (jpsModel == null) {
                JpsSerializationManagerImpl.$$$reportNull$$$0(1);
            }
            return jpsModel;
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalSettingsLoading.loadGlobalSettings(model.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model.getGlobal());
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, model.getGlobal().getPathMapper(), Paths.get(projectPath, new String[0]), loadUnloadedModules);
        JpsModel jpsModel = model;
        if (jpsModel == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(2);
        }
        return jpsModel;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables) throws IOException {
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(3);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(4);
        }
        JpsProject jpsProject = this.loadProject(projectPath, pathVariables, false);
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(5);
        }
        return jpsProject;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables, boolean loadUnloadedModules) throws IOException {
        JpsSerializationViaWorkspaceModel serializationViaWorkspaceModel;
        if (projectPath == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(6);
        }
        if (pathVariables == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(7);
        }
        if ((serializationViaWorkspaceModel = JpsSerializationViaWorkspaceModel.getInstance()) != null) {
            JpsProject jpsProject = serializationViaWorkspaceModel.loadProject(projectPath, pathVariables, loadUnloadedModules);
            if (jpsProject == null) {
                JpsSerializationManagerImpl.$$$reportNull$$$0(8);
            }
            return jpsProject;
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, JpsPathMapper.IDENTITY, Paths.get(projectPath, new String[0]), loadUnloadedModules);
        JpsProject jpsProject = model.getProject();
        if (jpsProject == null) {
            JpsSerializationManagerImpl.$$$reportNull$$$0(9);
        }
        return jpsProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/impl/JpsSerializationManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadModel";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

