/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDetails;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabProjectVirtualFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabTimelineFileType;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabToolWindowProjectViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabToolWindowViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\r\u0010\u0016\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0017H\u0016J\r\u0010\u0018\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestTimelineFile;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabProjectVirtualFile;", "connectionId", "", "project", "Lcom/intellij/openapi/project/Project;", "glProject", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mergeRequestId", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Ljava/lang/String;)V", "getMergeRequestId", "()Ljava/lang/String;", "equals", "", "other", "", "findDetails", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDetails;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "Lcom/intellij/openapi/util/NlsSafe;", "hashCode", "", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestTimelineFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestTimelineFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestTimelineFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n59#2:66\n1#3:67\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestTimelineFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestTimelineFile\n*L\n31#1:66\n*E\n"})
public final class GitLabMergeRequestTimelineFile
extends GitLabProjectVirtualFile {
    @NotNull
    private final String mergeRequestId;

    public GitLabMergeRequestTimelineFile(@NotNull String connectionId, @NotNull Project project, @NotNull GitLabProjectCoordinates glProject, @NotNull String mergeRequestId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)glProject, (String)"glProject");
        Intrinsics.checkNotNullParameter((Object)mergeRequestId, (String)"mergeRequestId");
        super(connectionId, project, glProject);
        this.mergeRequestId = mergeRequestId;
    }

    @NotNull
    public final String getMergeRequestId() {
        return this.mergeRequestId;
    }

    @NotNull
    public String getName() {
        return "!" + this.mergeRequestId;
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.mergeRequestId};
        return GitLabBundle.message("merge.request.timeline.file.name", objectArray);
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem");
        return GitLabVirtualFileSystem.getPath$default((GitLabVirtualFileSystem)complexPathVirtualFileSystem, this.getConnectionId(), this.getProject(), this.getGlProject(), this.mergeRequestId, false, 16, null);
    }

    @NotNull
    public String getPresentablePath() {
        Object object = this.findDetails();
        if (object == null || (object = ((GitLabMergeRequestDetails)object).getWebUrl()) == null) {
            object = this.getGlProject() + "/mergerequests/" + this.mergeRequestId;
        }
        return object;
    }

    @NotNull
    public FileType getFileType() {
        return GitLabTimelineFileType.Companion.getInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final GitLabMergeRequestDetails findDetails() {
        GitLabToolWindowProjectViewModel gitLabToolWindowProjectViewModel;
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.getProject();
        boolean $i$f$serviceIfCreated = false;
        GitLabToolWindowViewModel gitLabToolWindowViewModel = (GitLabToolWindowViewModel)$this$serviceIfCreated$iv.getServiceIfCreated(GitLabToolWindowViewModel.class);
        if (gitLabToolWindowViewModel == null) return null;
        StateFlow<GitLabToolWindowProjectViewModel> stateFlow = gitLabToolWindowViewModel.getProjectVm();
        if (stateFlow == null) return null;
        GitLabToolWindowProjectViewModel gitLabToolWindowProjectViewModel2 = (GitLabToolWindowProjectViewModel)stateFlow.getValue();
        if (gitLabToolWindowProjectViewModel2 == null) return null;
        GitLabToolWindowProjectViewModel it = gitLabToolWindowProjectViewModel = gitLabToolWindowProjectViewModel2;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getConnectionId(), (Object)this.getConnectionId())) return null;
        GitLabToolWindowProjectViewModel gitLabToolWindowProjectViewModel3 = gitLabToolWindowProjectViewModel;
        GitLabToolWindowProjectViewModel gitLabToolWindowProjectViewModel4 = gitLabToolWindowProjectViewModel3;
        if (gitLabToolWindowProjectViewModel4 == null) return null;
        GitLabMergeRequestDetails gitLabMergeRequestDetails = gitLabToolWindowProjectViewModel4.findMergeRequestDetails(this.mergeRequestId);
        return gitLabMergeRequestDetails;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabMergeRequestTimelineFile)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mergeRequestId, (Object)((GitLabMergeRequestTimelineFile)other).mergeRequestId);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.mergeRequestId.hashCode();
        return result2;
    }
}

