/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.GitLabProjectConnectionManager;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestTimelineFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestTimelineFileEditor;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabProjectVirtualFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "acceptRequiresReadAction", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabFileEditorProvider.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabFileEditorProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,32:1\n31#2,2:33\n*S KotlinDebug\n*F\n+ 1 GitLabFileEditorProvider.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabFileEditorProvider\n*L\n15#1:33,2\n*E\n"})
public final class GitLabFileEditorProvider
implements FileEditorProvider,
DumbAware {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof GitLabProjectVirtualFile)) return false;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitLabProjectConnectionManager> serviceClass$iv = GitLabProjectConnectionManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((GitLabProjectConnectionManager)object).getConnectionState().getValue() == null) return false;
        return true;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitLabProjectVirtualFile cfr_ignored_0 = (GitLabProjectVirtualFile)file;
        if (!(file instanceof GitLabMergeRequestTimelineFile)) {
            throw new IllegalStateException("Unsupported file type".toString());
        }
        return new GitLabMergeRequestTimelineFileEditor(project, (GitLabMergeRequestTimelineFile)file);
    }

    @NotNull
    public String getEditorTypeId() {
        return "GitLab";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

