/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinDslScriptAdditionalTask;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinGradlePluginVersion;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinExtensionReflection;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0016J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinDslScriptTaskModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "()V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "canBuild", "", "kotlinDslScriptsModelImportSupported", "gradleVersion", "reportErrorMessage", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "parseKotlinGradlePluginVersion", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinGradlePluginVersion;", "Lorg/jetbrains/kotlin/idea/gradleTooling/reflect/KotlinExtensionReflection;", "parseKotlinGradlePluginVersion$kotlin_gradle_gradle_tooling_impl", "Companion", "kotlin.gradle.gradle-tooling.impl"})
public final class KotlinDslScriptTaskModelBuilder
extends AbstractModelBuilderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = Logging.getLogger(KotlinDslScriptTaskModelBuilder.class);

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)KotlinDslScriptAdditionalTask.class.getName(), (Object)modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = project.getGradle().getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGradleVersion(...)");
        if (this.kotlinDslScriptsModelImportSupported(string)) {
            StartParameter startParameter = project.getGradle().getStartParameter();
            HashSet<String> tasks = new HashSet<String>(startParameter.getTaskNames());
            tasks.add("prepareKotlinBuildScriptModel");
            startParameter.setTaskNames((Iterable)tasks);
        }
        return null;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup((ModelBuilderService)this).withKind(Message.Kind.WARNING).withTitle("Kotlin DSL script model errors").withText("Unable to set prepareKotlinBuildScriptModel sync task.").withException(exception).reportMessage(project);
    }

    private final boolean kotlinDslScriptsModelImportSupported(String gradleVersion) {
        return GradleVersionUtil.isGradleAtLeast((String)gradleVersion, (String)"6.0");
    }

    @Nullable
    public final KotlinGradlePluginVersion parseKotlinGradlePluginVersion$kotlin_gradle_gradle_tooling_impl(@NotNull KotlinExtensionReflection $this$parseKotlinGradlePluginVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$parseKotlinGradlePluginVersion, (String)"<this>");
        String string = $this$parseKotlinGradlePluginVersion.getKotlinGradlePluginVersion();
        if (string == null) {
            return null;
        }
        KotlinGradlePluginVersion version = KotlinGradlePluginVersion.Companion.parse(string);
        if (version == null) {
            logger.warn("[sync warning] Failed to parse KotlinGradlePluginVersion: version == null");
        }
        return version;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinDslScriptTaskModelBuilder$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "kotlin.gradle.gradle-tooling.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

