/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.platform.navbar.backend.impl.ModuleNavBarItem;
import com.intellij.platform.navbar.backend.impl.OrderEntryNavBarItem;
import com.intellij.platform.navbar.backend.impl.ProjectNavBarItem;
import com.intellij.platform.navbar.backend.impl.PsiNavBarItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0000\u001a8\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162#\u0010\u0017\u001a\u001f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u0018\u00a2\u0006\u0002\u0010\u001b\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"additionalRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "adjustWithAllExtensions", "Lcom/intellij/psi/PsiElement;", "element", "compatibilityNavBarItem", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "o", "", "ext", "Lcom/intellij/ide/navigationToolbar/NavBarModelExtension;", "ensurePsiFromExtensionIsValid", "", "psi", "message", "", "clazz", "Ljava/lang/Class;", "fromOldExtensions", "T", "selector", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "parentFromOldExtensions", "item", "Lcom/intellij/platform/navbar/backend/impl/PsiNavBarItem;", "intellij.platform.navbar.backend"})
@SourceDebugExtension(value={"SMAP\nDefaultNavBarItemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNavBarItemProvider.kt\ncom/intellij/platform/navbar/backend/impl/DefaultNavBarItemProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class DefaultNavBarItemProviderKt {
    private static final PsiElement parentFromOldExtensions(PsiNavBarItem item) {
        for (NavBarModelExtension ext : NavBarModelExtension.EP_NAME.getExtensionList()) {
            try {
                PsiElement parent = ext.getParent((PsiElement)item.getData());
                if (parent == null || Intrinsics.areEqual((Object)parent, item.getData())) continue;
                DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(parent, "Extension returned invalid parent", ext.getClass());
                return parent;
            }
            catch (ProcessCanceledException pce) {
                ProgressManager.checkCanceled();
            }
        }
        return null;
    }

    @Nullable
    public static final <T> T fromOldExtensions(@NotNull Function1<? super NavBarModelExtension, ? extends T> selector) {
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        for (NavBarModelExtension ext : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Intrinsics.checkNotNull((Object)ext);
            Object selected = selector.invoke((Object)ext);
            if (selected == null) continue;
            return (T)selected;
        }
        return null;
    }

    @Nullable
    public static final PsiElement adjustWithAllExtensions(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement result = element;
        for (NavBarModelExtension ext : CollectionsKt.asReversed((List)NavBarModelExtension.EP_NAME.getExtensionList())) {
            if (ext.adjustElement(result) == null) {
                return null;
            }
            DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(result, "Invalid psi returned from " + ext.getClass() + " while adjusting", ext.getClass());
        }
        return result;
    }

    private static final Iterable<VirtualFile> additionalRoots(Project project) {
        ArrayList resultRoots = new ArrayList();
        for (NavBarModelExtension ext : NavBarModelExtension.EP_NAME.getExtensionList()) {
            resultRoots.addAll(ext.additionalRoots(project));
        }
        return resultRoots;
    }

    public static final void ensurePsiFromExtensionIsValid(@NotNull PsiElement psi, @NotNull String message, @Nullable Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            PsiUtilCore.ensureValid((PsiElement)psi);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            if (clazz != null) {
                PluginException pluginException = PluginException.createByClass((String)(message + ", psi class: " + psi.getClass().getCanonicalName()), (Throwable)t, clazz);
                Intrinsics.checkNotNullExpressionValue((Object)pluginException, (String)"createByClass(...)");
                throw (Throwable)pluginException;
            }
            throw new IllegalStateException(message + ", psi class: " + psi.getClass().getCanonicalName(), t);
        }
    }

    public static /* synthetic */ void ensurePsiFromExtensionIsValid$default(PsiElement psiElement, String string, Class clazz, int n, Object object) {
        if ((n & 4) != 0) {
            clazz = null;
        }
        DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid(psiElement, string, clazz);
    }

    @VisibleForTesting
    @Nullable
    public static final NavBarItem compatibilityNavBarItem(@NotNull Object o, @Nullable NavBarModelExtension ext) {
        NavBarItem navBarItem;
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Object object = o;
        if (object instanceof Project) {
            navBarItem = new ProjectNavBarItem((Project)o);
        } else if (object instanceof Module) {
            navBarItem = new ModuleNavBarItem((Module)o);
        } else if (object instanceof PsiElement) {
            PsiNavBarItem psiNavBarItem;
            if (ext != null && ext.normalizeChildren()) {
                PsiElement adjusted;
                PsiElement psiElement = adjusted = DefaultNavBarItemProviderKt.adjustWithAllExtensions((PsiElement)o);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    psiNavBarItem = new PsiNavBarItem(it, null);
                } else {
                    psiNavBarItem = null;
                }
            } else {
                psiNavBarItem = new PsiNavBarItem((PsiElement)o, null);
            }
            navBarItem = psiNavBarItem;
        } else {
            navBarItem = object instanceof OrderEntry ? (NavBarItem)new OrderEntryNavBarItem((OrderEntry)o) : (NavBarItem)new DefaultNavBarItem<Object>(o);
        }
        return navBarItem;
    }

    public static final /* synthetic */ Iterable access$additionalRoots(Project project) {
        return DefaultNavBarItemProviderKt.additionalRoots(project);
    }

    public static final /* synthetic */ PsiElement access$parentFromOldExtensions(PsiNavBarItem item) {
        return DefaultNavBarItemProviderKt.parentFromOldExtensions(item);
    }
}

