/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSynchronizerKt;
import com.intellij.settingsSync.SettingsSynchronizerState;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0003R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer;", "Lcom/intellij/openapi/application/ApplicationActivationListener;", "()V", "autoSyncDelay", "", "getAutoSyncDelay", "()J", "applicationActivated", "", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "applicationDeactivated", "setupSyncingByTimer", "Ljava/util/concurrent/ScheduledFuture;", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSynchronizer.kt\ncom/intellij/settingsSync/SettingsSynchronizer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,144:1\n40#2,3:145\n40#2,3:148\n40#2,3:151\n40#2,3:154\n*S KotlinDebug\n*F\n+ 1 SettingsSynchronizer.kt\ncom/intellij/settingsSync/SettingsSynchronizer\n*L\n115#1:145,3\n116#1:148,3\n125#1:151,3\n131#1:154,3\n*E\n"})
final class SettingsSynchronizer
implements ApplicationActivationListener {
    private final long getAutoSyncDelay() {
        return Registry.intValue((String)"settingsSync.autoSync.frequency.sec", (int)60);
    }

    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
        if (!(SettingsSyncMainKt.isSettingsSyncEnabledByKey() && SettingsSyncMainKt.isSettingsSyncEnabledInSettings() && SettingsSyncMain.Companion.isAvailable())) {
            return;
        }
        if (this.getAutoSyncDelay() > 0L) {
            boolean $i$f$service = false;
            Class<SettingsSynchronizerState> serviceClass$iv = SettingsSynchronizerState.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (((SettingsSynchronizerState)object).scheduledFuture == null) {
                $i$f$service = false;
                serviceClass$iv = SettingsSynchronizerState.class;
                object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((SettingsSynchronizerState)object).scheduledFuture = this.setupSyncingByTimer();
            }
        }
        if (Registry.is((String)"settingsSync.autoSync.on.focus", (boolean)true)) {
            SettingsSynchronizerKt.fireSettingsChanged();
        }
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
        boolean $i$f$service = false;
        Class<SettingsSynchronizerState> serviceClass$iv = SettingsSynchronizerState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((SettingsSynchronizerState)object).stopSyncingByTimer();
    }

    @RequiresEdt
    private final ScheduledFuture<?> setupSyncingByTimer() {
        long delay = this.getAutoSyncDelay();
        boolean $i$f$service = false;
        Class<SettingsSynchronizerState> serviceClass$iv = SettingsSynchronizerState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ScheduledFuture<?> scheduledFuture = ((SettingsSynchronizerState)object).executorService.scheduleWithFixedDelay(SettingsSynchronizer::setupSyncingByTimer$lambda$0, delay, delay, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        return scheduledFuture;
    }

    private static final void setupSyncingByTimer$lambda$0() {
        SettingsSynchronizerKt.access$getLOG$p().debug("Syncing settings by timer");
        SettingsSynchronizerKt.fireSettingsChanged();
    }
}

