/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.BaseLineInfo;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.LineInfo;
import com.jetbrains.jdi.LocalVariableImpl;
import com.jetbrains.jdi.LocationImpl;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.SDE;
import com.jetbrains.jdi.StratumLineInfo;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.VirtualMachine;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

public class ConcreteMethodImpl
extends MethodImpl {
    private volatile Location location = null;
    private volatile SoftReference<SoftLocationXRefs> softBaseLocationXRefsRef;
    private volatile SoftReference<SoftLocationXRefs> softOtherLocationXRefsRef;
    private volatile SoftReference<List<LocalVariable>> variablesRef = null;
    private volatile boolean absentVariableInformation = false;
    private volatile long firstIndex = -1L;
    private volatile long lastIndex = -1L;
    private volatile SoftReference<byte[]> bytecodesRef = null;
    private volatile int argSlotCount = -1;

    ConcreteMethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long ref, String name, String signature, String genericSignature, int modifiers) {
        super(vm, declaringType, ref, name, signature, genericSignature, modifiers);
    }

    @Override
    public Location location() {
        if (this.location == null) {
            this.getBaseLocations();
        }
        return this.location;
    }

    List<Location> sourceNameFilter(List<Location> list, SDE.Stratum stratum, String sourceName) throws AbsentInformationException {
        if (sourceName == null) {
            return list;
        }
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location loc : list) {
            if (!((LocationImpl)loc).sourceName(stratum).equals(sourceName)) continue;
            locs.add(loc);
        }
        return locs;
    }

    @Override
    List<Location> allLineLocations(SDE.Stratum stratum, String sourceName) throws AbsentInformationException {
        List<Location> lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        return Collections.unmodifiableList(this.sourceNameFilter(lineLocations, stratum, sourceName));
    }

    @Override
    CompletableFuture<List<Location>> allLineLocationsAsync(SDE.Stratum stratum, String sourceName) {
        return this.getLocationsAsync(stratum).thenApply(info -> {
            List<Location> lineLocations = info.lineLocations;
            if (lineLocations.size() == 0) {
                throw new CompletionException(new AbsentInformationException());
            }
            try {
                return Collections.unmodifiableList(this.sourceNameFilter(lineLocations, stratum, sourceName));
            }
            catch (AbsentInformationException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    List<Location> locationsOfLine(SDE.Stratum stratum, String sourceName, int lineNumber) throws AbsentInformationException {
        SoftLocationXRefs info = this.getLocations(stratum);
        if (info.lineLocations.size() == 0) {
            throw new AbsentInformationException();
        }
        List<Location> list = info.lineMapper.get(lineNumber);
        if (list == null) {
            list = new ArrayList<Location>(0);
        }
        return Collections.unmodifiableList(this.sourceNameFilter(list, stratum, sourceName));
    }

    @Override
    CompletableFuture<List<Location>> locationsOfLineAsync(SDE.Stratum stratum, String sourceName, int lineNumber) {
        return this.getLocationsAsync(stratum).thenApply(info -> {
            if (info.lineLocations.size() == 0) {
                throw new CompletionException(new AbsentInformationException());
            }
            List<Location> list = info.lineMapper.get(lineNumber);
            if (list == null) {
                list = Collections.emptyList();
            }
            try {
                return Collections.unmodifiableList(this.sourceNameFilter(list, stratum, sourceName));
            }
            catch (AbsentInformationException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public Location locationOfCodeIndex(long codeIndex) {
        if (this.firstIndex == -1L) {
            this.getBaseLocations();
        }
        if (codeIndex < this.firstIndex || codeIndex > this.lastIndex) {
            return null;
        }
        return new LocationImpl(this.virtualMachine(), this, codeIndex);
    }

    @Override
    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        LocationImpl current;
        if (this.firstIndex == -1L) {
            this.getBaseLocations();
        }
        if (codeIndex < this.firstIndex || codeIndex > this.lastIndex) {
            throw new InternalError("Location with invalid code index");
        }
        List<Location> lineLocations = this.getLocations((SDE.Stratum)stratum).lineLocations;
        if (lineLocations.size() == 0) {
            return super.codeIndexToLineInfo(stratum, codeIndex);
        }
        Iterator<Location> iter = lineLocations.iterator();
        LocationImpl bestMatch = (LocationImpl)iter.next();
        while (iter.hasNext() && (current = (LocationImpl)iter.next()).codeIndex() <= codeIndex) {
            bestMatch = current;
        }
        return bestMatch.getLineInfo(stratum);
    }

    @Override
    public List<LocalVariable> variables() throws AbsentInformationException {
        return this.getVariables();
    }

    @Override
    public CompletableFuture<List<LocalVariable>> variablesAsync() {
        return this.getVariablesAsync();
    }

    @Override
    public List<LocalVariable> variablesByName(String name) throws AbsentInformationException {
        return this.getVariables().stream().filter(v -> v.name().equals(name)).collect(Collectors.toList());
    }

    public CompletableFuture<List<LocalVariable>> variablesByNameAsync(String name) {
        return this.getVariablesAsync().thenApply(variables -> variables.stream().filter(v -> v.name().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public List<LocalVariable> arguments() throws AbsentInformationException {
        return this.getVariables().stream().filter(LocalVariable::isArgument).collect(Collectors.toList());
    }

    public CompletableFuture<List<LocalVariable>> argumentsAsync() {
        return this.getVariablesAsync().thenApply(variables -> variables.stream().filter(LocalVariable::isArgument).collect(Collectors.toList()));
    }

    @Override
    public byte[] bytecodes() {
        byte[] bytecodes;
        byte[] byArray = bytecodes = this.bytecodesRef == null ? null : this.bytecodesRef.get();
        if (bytecodes == null) {
            try {
                bytecodes = JDWP.Method.Bytecodes.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).bytes;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            this.bytecodesRef = new SoftReference<byte[]>(bytecodes);
        }
        return (byte[])bytecodes.clone();
    }

    @Override
    public CompletableFuture<byte[]> bytecodesAsync() {
        byte[] bytecodes;
        byte[] byArray = bytecodes = this.bytecodesRef == null ? null : this.bytecodesRef.get();
        if (bytecodes != null) {
            return CompletableFuture.completedFuture((byte[])bytecodes.clone());
        }
        return JDWP.Method.Bytecodes.processAsync(this.vm, this.declaringType, this.ref).thenApply(b -> {
            this.bytecodesRef = new SoftReference<byte[]>(b.bytes);
            return (byte[])b.bytes.clone();
        });
    }

    @Override
    int argSlotCount() throws AbsentInformationException {
        if (this.argSlotCount == -1) {
            this.getVariables();
        }
        return this.argSlotCount;
    }

    private SoftLocationXRefs getLocations(SDE.Stratum stratum) {
        SoftLocationXRefs info;
        if (stratum.isJava()) {
            return this.getBaseLocations();
        }
        String stratumID = stratum.id();
        SoftLocationXRefs softLocationXRefs = info = this.softOtherLocationXRefsRef == null ? null : this.softOtherLocationXRefsRef.get();
        if (info != null && info.stratumID.equals(stratumID)) {
            return info;
        }
        ArrayList<Location> lineLocations = new ArrayList<Location>();
        HashMap<Integer, List<Location>> lineMapper = new HashMap<Integer, List<Location>>();
        int lowestLine = -1;
        int highestLine = -1;
        SDE.LineStratum lastLineStratum = null;
        SDE.Stratum baseStratum = this.declaringType.stratum("Java");
        for (Location lineLocation : this.getBaseLocations().lineLocations) {
            int lineNumber;
            LocationImpl loc = (LocationImpl)lineLocation;
            int baseLineNumber = loc.lineNumber(baseStratum);
            SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
            if (lineStratum == null || (lineNumber = lineStratum.lineNumber()) == -1 || lineStratum.equals(lastLineStratum)) continue;
            lastLineStratum = lineStratum;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            loc.addStratumLineInfo(new StratumLineInfo(stratumID, lineNumber, lineStratum.sourceName(), lineStratum.sourcePath()));
            lineLocations.add(loc);
            lineMapper.computeIfAbsent(lineNumber, k -> new ArrayList(1)).add(loc);
        }
        info = new SoftLocationXRefs(stratumID, lineMapper, lineLocations, lowestLine, highestLine);
        this.softOtherLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    private CompletableFuture<SoftLocationXRefs> getLocationsAsync(SDE.Stratum stratum) {
        SoftLocationXRefs info;
        if (stratum.isJava()) {
            return this.getBaseLocationsAsync();
        }
        String stratumID = stratum.id();
        SoftLocationXRefs softLocationXRefs2 = info = this.softOtherLocationXRefsRef == null ? null : this.softOtherLocationXRefsRef.get();
        if (info != null && info.stratumID.equals(stratumID)) {
            return CompletableFuture.completedFuture(info);
        }
        return this.declaringType.stratumAsync("Java").thenCombine(this.getBaseLocationsAsync(), (baseStratum, softLocationXRefs) -> {
            ArrayList<Location> lineLocations = new ArrayList<Location>();
            HashMap<Integer, List<Location>> lineMapper = new HashMap<Integer, List<Location>>();
            int lowestLine = -1;
            int highestLine = -1;
            SDE.LineStratum lastLineStratum = null;
            for (Location lineLocation : softLocationXRefs.lineLocations) {
                int lineNumber;
                LocationImpl loc = (LocationImpl)lineLocation;
                int baseLineNumber = loc.lineNumber((SDE.Stratum)baseStratum);
                SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
                if (lineStratum == null || (lineNumber = lineStratum.lineNumber()) == -1 || lineStratum.equals(lastLineStratum)) continue;
                lastLineStratum = lineStratum;
                if (lineNumber > highestLine) {
                    highestLine = lineNumber;
                }
                if (lineNumber < lowestLine || lowestLine == -1) {
                    lowestLine = lineNumber;
                }
                loc.addStratumLineInfo(new StratumLineInfo(stratumID, lineNumber, lineStratum.sourceName(), lineStratum.sourcePath()));
                lineLocations.add(loc);
                lineMapper.computeIfAbsent(lineNumber, k -> new ArrayList(1)).add(loc);
            }
            SoftLocationXRefs res = new SoftLocationXRefs(stratumID, lineMapper, lineLocations, lowestLine, highestLine);
            this.softOtherLocationXRefsRef = new SoftReference<SoftLocationXRefs>(res);
            return res;
        });
    }

    private SoftLocationXRefs getBaseLocations() {
        JDWP.Method.LineTable lntab;
        SoftLocationXRefs info;
        SoftLocationXRefs softLocationXRefs = info = this.softBaseLocationXRefsRef == null ? null : this.softBaseLocationXRefsRef.get();
        if (info != null) {
            return info;
        }
        try {
            lntab = JDWP.Method.LineTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        int count = lntab.lines.length;
        ArrayList<Location> lineLocations = new ArrayList<Location>(count);
        HashMap<Integer, List<Location>> lineMapper = new HashMap<Integer, List<Location>>();
        int lowestLine = -1;
        int highestLine = -1;
        for (int i = 0; i < count; ++i) {
            long bci = lntab.lines[i].lineCodeIndex;
            int lineNumber = lntab.lines[i].lineNumber;
            if (i + 1 != count && bci == lntab.lines[i + 1].lineCodeIndex) continue;
            if (lineNumber > highestLine) {
                highestLine = lineNumber;
            }
            if (lineNumber < lowestLine || lowestLine == -1) {
                lowestLine = lineNumber;
            }
            LocationImpl loc = new LocationImpl(this.virtualMachine(), this, bci);
            loc.addBaseLineInfo(new BaseLineInfo(lineNumber, this.declaringType));
            lineLocations.add(loc);
            lineMapper.computeIfAbsent(lineNumber, k -> new ArrayList(1)).add(loc);
        }
        if (this.location == null) {
            this.firstIndex = lntab.start;
            this.lastIndex = lntab.end;
            this.location = count > 0 ? (Location)lineLocations.get(0) : new LocationImpl(this.virtualMachine(), this, this.firstIndex);
        }
        info = new SoftLocationXRefs("Java", lineMapper, lineLocations, lowestLine, highestLine);
        this.softBaseLocationXRefsRef = new SoftReference<SoftLocationXRefs>(info);
        return info;
    }

    private CompletableFuture<SoftLocationXRefs> getBaseLocationsAsync() {
        SoftLocationXRefs info;
        SoftLocationXRefs softLocationXRefs = info = this.softBaseLocationXRefsRef == null ? null : this.softBaseLocationXRefsRef.get();
        if (info != null) {
            return CompletableFuture.completedFuture(info);
        }
        return JDWP.Method.LineTable.processAsync(this.vm, this.declaringType, this.ref).thenApply(lntab -> {
            int count = lntab.lines.length;
            ArrayList<Location> lineLocations = new ArrayList<Location>(count);
            HashMap<Integer, List<Location>> lineMapper = new HashMap<Integer, List<Location>>();
            int lowestLine = -1;
            int highestLine = -1;
            for (int i = 0; i < count; ++i) {
                long bci = lntab.lines[i].lineCodeIndex;
                int lineNumber = lntab.lines[i].lineNumber;
                if (i + 1 != count && bci == lntab.lines[i + 1].lineCodeIndex) continue;
                if (lineNumber > highestLine) {
                    highestLine = lineNumber;
                }
                if (lineNumber < lowestLine || lowestLine == -1) {
                    lowestLine = lineNumber;
                }
                LocationImpl loc = new LocationImpl(this.virtualMachine(), this, bci);
                loc.addBaseLineInfo(new BaseLineInfo(lineNumber, this.declaringType));
                lineLocations.add(loc);
                lineMapper.computeIfAbsent(lineNumber, k -> new ArrayList(1)).add(loc);
            }
            if (this.location == null) {
                this.firstIndex = lntab.start;
                this.lastIndex = lntab.end;
                this.location = count > 0 ? (Location)lineLocations.get(0) : new LocationImpl(this.virtualMachine(), this, this.firstIndex);
            }
            SoftLocationXRefs res = new SoftLocationXRefs("Java", lineMapper, lineLocations, lowestLine, highestLine);
            this.softBaseLocationXRefsRef = new SoftReference<SoftLocationXRefs>(res);
            return res;
        });
    }

    private List<LocalVariable> getVariables1_4() throws AbsentInformationException {
        JDWP.Method.VariableTable vartab;
        try {
            vartab = JDWP.Method.VariableTable.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw exc.toJDIException();
        }
        return this.createVariables1_4(vartab);
    }

    private CompletableFuture<List<LocalVariable>> getVariables1_4Async() {
        return ((CompletableFuture)JDWP.Method.VariableTable.processAsync(this.vm, this.declaringType, this.ref).exceptionally(throwable -> {
            if (JDWPException.isOfType(throwable, 101)) {
                this.absentVariableInformation = true;
                throw new CompletionException(new AbsentInformationException());
            }
            throw (RuntimeException)throwable;
        })).thenApply(this::createVariables1_4);
    }

    private List<LocalVariable> createVariables1_4(JDWP.Method.VariableTable vartab) {
        this.argSlotCount = vartab.argCnt;
        int count = vartab.slots.length;
        ArrayList<LocalVariable> variables = new ArrayList<LocalVariable>(count);
        for (int i = 0; i < count; ++i) {
            JDWP.Method.VariableTable.SlotInfo si = vartab.slots[i];
            if (si.name.startsWith("this$") || si.name.equals("this")) continue;
            LocationImpl scopeStart = new LocationImpl(this.virtualMachine(), this, si.codeIndex);
            LocationImpl scopeEnd = new LocationImpl(this.virtualMachine(), this, si.codeIndex + (long)si.length - 1L);
            LocalVariableImpl variable = new LocalVariableImpl(this.virtualMachine(), this, si.slot, scopeStart, scopeEnd, si.name, si.signature, null);
            variables.add(variable);
        }
        return variables;
    }

    private List<LocalVariable> getVariables1() throws AbsentInformationException {
        JDWP.Method.VariableTableWithGeneric vartab;
        if (!this.vm.canGet1_5LanguageFeatures()) {
            return this.getVariables1_4();
        }
        try {
            vartab = JDWP.Method.VariableTableWithGeneric.process(this.vm, this.declaringType, this.ref);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                this.absentVariableInformation = true;
                throw new AbsentInformationException();
            }
            throw exc.toJDIException();
        }
        return this.createVariables(vartab);
    }

    private CompletableFuture<List<LocalVariable>> getVariables1Async() {
        if (!this.vm.canGet1_5LanguageFeatures()) {
            return this.getVariables1_4Async();
        }
        return ((CompletableFuture)JDWP.Method.VariableTableWithGeneric.processAsync(this.vm, this.declaringType, this.ref).exceptionally(throwable -> {
            if (JDWPException.isOfType(throwable, 101)) {
                this.absentVariableInformation = true;
                throw new CompletionException(new AbsentInformationException());
            }
            throw (RuntimeException)throwable;
        })).thenApply(this::createVariables);
    }

    private List<LocalVariable> createVariables(JDWP.Method.VariableTableWithGeneric vartab) {
        this.argSlotCount = vartab.argCnt;
        int count = vartab.slots.length;
        ArrayList<LocalVariable> variables = new ArrayList<LocalVariable>(count);
        for (int i = 0; i < count; ++i) {
            JDWP.Method.VariableTableWithGeneric.SlotInfo si = vartab.slots[i];
            if (!this.isStatic() && (si.name.startsWith("this$") || si.name.equals("this"))) continue;
            LocationImpl scopeStart = new LocationImpl(this.virtualMachine(), this, si.codeIndex);
            LocationImpl scopeEnd = new LocationImpl(this.virtualMachine(), this, si.codeIndex + (long)si.length - 1L);
            LocalVariableImpl variable = new LocalVariableImpl(this.virtualMachine(), this, si.slot, scopeStart, scopeEnd, si.name, si.signature, si.genericSignature);
            variables.add(variable);
        }
        return variables;
    }

    private List<LocalVariable> getVariables() throws AbsentInformationException {
        List<LocalVariable> variables;
        if (this.absentVariableInformation) {
            throw new AbsentInformationException();
        }
        List<LocalVariable> list = variables = this.variablesRef == null ? null : this.variablesRef.get();
        if (variables != null) {
            return variables;
        }
        variables = this.getVariables1();
        variables = Collections.unmodifiableList(variables);
        this.variablesRef = new SoftReference<List<LocalVariable>>(variables);
        return variables;
    }

    private CompletableFuture<List<LocalVariable>> getVariablesAsync() {
        List<LocalVariable> variables;
        if (this.absentVariableInformation) {
            return CompletableFuture.failedFuture(new AbsentInformationException());
        }
        List<LocalVariable> list = variables = this.variablesRef == null ? null : this.variablesRef.get();
        if (variables != null) {
            return CompletableFuture.completedFuture(variables);
        }
        return this.getVariables1Async().thenApply(v -> {
            List res = Collections.unmodifiableList(v);
            this.variablesRef = new SoftReference(res);
            return res;
        });
    }

    private static class SoftLocationXRefs {
        final String stratumID;
        final Map<Integer, List<Location>> lineMapper;
        final List<Location> lineLocations;
        final int lowestLine;
        final int highestLine;

        SoftLocationXRefs(String stratumID, Map<Integer, List<Location>> lineMapper, List<Location> lineLocations, int lowestLine, int highestLine) {
            this.stratumID = stratumID;
            this.lineMapper = Collections.unmodifiableMap(lineMapper);
            this.lineLocations = Collections.unmodifiableList(lineLocations);
            this.lowestLine = lowestLine;
            this.highestLine = highestLine;
        }
    }
}

