/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusClientIdTrackerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u001e\u0010\u0019\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0017\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\nX\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/ex/ClientIdsDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "clientIds", "", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getClientIds", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Ljava/util/List;", "setClientIds", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "mergeRanges", "", "block1", "block2", "merged", "onRangeRefreshed", "", "before", "after", "onRangeShifted", "onRangesChanged", "intellij.platform.vcs.impl"})
public abstract class ClientIdsDocumentTrackerHandler
implements DocumentTracker.Handler {
    @NotNull
    private final Project project;

    public ClientIdsDocumentTrackerHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected abstract List<ClientId> getClientIds(@NotNull DocumentTracker.Block var1);

    protected abstract void setClientIds(@NotNull DocumentTracker.Block var1, @NotNull List<ClientId> var2);

    public void onRangesChanged(@NotNull List<DocumentTracker.Block> before, @NotNull DocumentTracker.Block after) {
        Intrinsics.checkNotNullParameter(before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        List<ClientId> result2 = CollectionsKt.emptyList();
        for (DocumentTracker.Block block : before) {
            result2 = LineStatusClientIdTrackerKt.mergeSortedClientIds(result2, this.getClientIds(block));
        }
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.project);
        if (session.isGuest()) {
            result2 = LineStatusClientIdTrackerKt.mergeSortedClientIds(result2, CollectionsKt.listOf((Object)session.getClientId()));
        }
        this.setClientIds(after, result2);
    }

    public void onRangeRefreshed(@NotNull DocumentTracker.Block before, @NotNull List<DocumentTracker.Block> after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter(after, (String)"after");
        List<ClientId> clientIds = this.getClientIds(before);
        if (clientIds.isEmpty()) {
            return;
        }
        for (DocumentTracker.Block block : after) {
            this.setClientIds(block, clientIds);
        }
    }

    public boolean mergeRanges(@NotNull DocumentTracker.Block block1, @NotNull DocumentTracker.Block block2, @NotNull DocumentTracker.Block merged) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
        this.setClientIds(merged, LineStatusClientIdTrackerKt.mergeSortedClientIds(this.getClientIds(block1), this.getClientIds(block2)));
        return true;
    }

    public void onRangeShifted(@NotNull DocumentTracker.Block before, @NotNull DocumentTracker.Block after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        this.setClientIds(after, this.getClientIds(before));
    }
}

