/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IssueLinkRenderer {
    private final SimpleColoredComponent myColoredComponent;
    private final IssueNavigationConfiguration myIssueNavigationConfiguration;

    public IssueLinkRenderer(Project project, SimpleColoredComponent coloredComponent) {
        this.myColoredComponent = coloredComponent;
        this.myIssueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
    }

    public List<String> appendTextWithLinks(@Nls String text2) {
        return this.appendTextWithLinks(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public List<String> appendTextWithLinks(@Nls String text2, @NotNull SimpleTextAttributes baseStyle) {
        if (baseStyle == null) {
            IssueLinkRenderer.$$$reportNull$$$0(0);
        }
        ArrayList<String> pieces = new ArrayList<String>();
        SimpleTextAttributes linkAttributes = IssueLinkRenderer.getLinkAttributes(baseStyle);
        IssueNavigationConfiguration.processTextWithLinks((String)text2, (List)this.myIssueNavigationConfiguration.findIssueLinks((CharSequence)text2), s -> {
            pieces.add((String)s);
            this.append((String)s, baseStyle);
        }, (link2, target) -> {
            pieces.add((String)link2);
            this.append((String)link2, linkAttributes, (String)target);
        });
        return pieces;
    }

    private void append(@Nls String piece, SimpleTextAttributes baseStyle) {
        this.myColoredComponent.append(piece, baseStyle);
    }

    private void append(@Nls String piece, SimpleTextAttributes baseStyle, @NlsSafe String targetUrl) {
        this.myColoredComponent.append(piece, baseStyle, (Object)new SimpleColoredComponent.BrowserLauncherTag(targetUrl));
    }

    private static SimpleTextAttributes getLinkAttributes(@NotNull SimpleTextAttributes baseStyle) {
        Color color;
        if (baseStyle == null) {
            IssueLinkRenderer.$$$reportNull$$$0(1);
        }
        int alpha = (color = baseStyle.getFgColor()) != null ? color.getAlpha() : 255;
        Color linkColor = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        Color resultColor = new Color(linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue(), alpha);
        return new SimpleTextAttributes(baseStyle.getStyle() | 0x10, resultColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "baseStyle";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/issueLinks/IssueLinkRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendTextWithLinks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLinkAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

