/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnversionedDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @Nullable
    private final Project myProject;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final ChangesBrowserNode.Tag myTag;

    private UnversionedDiffRequestProducer(@Nullable Project project, @NotNull FilePath path2, @NotNull ChangesBrowserNode.Tag tag) {
        if (path2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPath = path2;
        this.myTag = tag;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(2);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = FileStatus.UNKNOWN;
        if (fileStatus == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(3);
        }
        return fileStatus;
    }

    @Override
    @NotNull
    public ChangesBrowserNode.Tag getTag() {
        ChangesBrowserNode.Tag tag = this.myTag;
        if (tag == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(4);
        }
        return tag;
    }

    @NotNull
    public String getName() {
        String string = this.myPath.getPresentableUrl();
        if (string == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        VirtualFile file;
        if (context == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(7);
        }
        if ((file = this.myPath.getVirtualFile()) == null) {
            throw new DiffRequestProducerException(DiffBundle.message((String)"error.cant.show.diff.file.not.found", (Object[])new Object[0]));
        }
        return UnversionedDiffRequestProducer.createRequest(this.myProject, file);
    }

    @NotNull
    public static UnversionedDiffRequestProducer create(@Nullable Project project, @NotNull FilePath path2) {
        if (path2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(8);
        }
        return UnversionedDiffRequestProducer.create(project, path2, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    @NotNull
    public static UnversionedDiffRequestProducer create(@Nullable Project project, @NotNull FilePath path2, @NotNull ChangesBrowserNode.Tag tag) {
        if (path2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(9);
        }
        if (tag == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(10);
        }
        return new UnversionedDiffRequestProducer(project, path2, tag);
    }

    @NotNull
    private static DiffRequest createRequest(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(11);
        }
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        EmptyContent content1 = contentFactory.createEmpty();
        DiffContent content2 = contentFactory.create(project, file);
        SimpleDiffRequest request = new SimpleDiffRequest(DiffRequestFactory.getInstance().getTitle(file), (DiffContent)content1, content2, null, ChangeDiffRequestProducer.getYourVersion());
        DiffUtil.putDataKey((UserDataHolder)request, (DataKey)VcsDataKeys.CURRENT_UNVERSIONED, (Object)file);
        SimpleDiffRequest simpleDiffRequest = request;
        if (simpleDiffRequest == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(12);
        }
        return simpleDiffRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnversionedDiffRequestProducer producer = (UnversionedDiffRequestProducer)o;
        return Objects.equals(this.myPath, producer.myPath);
    }

    public int hashCode() {
        return this.myPath.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/UnversionedDiffRequestProducer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/UnversionedDiffRequestProducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 12 -> new IllegalStateException(string);
        };
    }
}

