/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.CommonBundle;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

abstract class SpecificFilesViewDialog
extends DialogWrapper {
    protected final JPanel myPanel;
    protected final AsyncChangesTree myView;
    protected final Project myProject;

    protected SpecificFilesViewDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String title2, @NotNull DataKey<Iterable<FilePath>> shownDataKey) {
        if (project == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(1);
        }
        if (shownDataKey == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.setTitle(title2);
        this.myProject = project;
        this.myView = new MyChangesTree(project, shownDataKey);
        this.myView.setTreeStateStrategy(ChangesTree.KEEP_NON_EMPTY);
        Runnable closer = () -> this.close(0);
        EditSourceOnEnterKeyHandler.install((JComponent)((Object)this.myView), (Runnable)closer);
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myView), (Runnable)closer);
        this.myView.setMinimumSize((Dimension)new JBDimension(100, 100));
        this.myPanel = this.createPanel();
        this.setOKButtonText(CommonBundle.getCloseButtonText());
        this.init();
        ChangeListAdapter changeListListener = new ChangeListAdapter(){

            public void changeListUpdateDone() {
                SpecificFilesViewDialog.this.myView.rebuildTree();
            }
        };
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)changeListListener, this.myDisposable);
        this.myView.rebuildTree();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private JPanel createPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup group2 = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SPECIFIC_FILES_DIALOG", (ActionGroup)group2, true);
        this.addCustomActions(group2);
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group2.addSeparator();
        group2.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup treeActions = new DefaultActionGroup();
        treeActions.add(cam.createExpandAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        treeActions.add(cam.createCollapseAllHeaderAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(actionToolbar, (ActionGroup)treeActions, (JComponent)((Object)this.myView));
        panel2.add((Component)toolbarPanel, "North");
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        return panel2;
    }

    protected void addCustomActions(@NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            SpecificFilesViewDialog.$$$reportNull$$$0(4);
        }
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.SpecificFilesViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    @RequiresBackgroundThread
    protected abstract List<FilePath> getFiles();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shownDataKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCustomActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class MyChangesTree
    extends AsyncChangesTree {
        @NotNull
        private final DataKey<Iterable<FilePath>> myShownDataKey;

        MyChangesTree(@NotNull Project project, DataKey<Iterable<FilePath>> shownDataKey) {
            if (project == null) {
                MyChangesTree.$$$reportNull$$$0(0);
            }
            if (shownDataKey == null) {
                MyChangesTree.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.myShownDataKey = shownDataKey;
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        @Override
        public void installPopupHandler(@NotNull ActionGroup group2) {
            if (group2 == null) {
                MyChangesTree.$$$reportNull$$$0(2);
            }
            PopupHandler.installPopupMenu((JComponent)((Object)this), (ActionGroup)group2, (String)"ChangesViewPopup");
        }

        @Override
        @NotNull
        protected AsyncChangesTreeModel getChangesTreeModel() {
            AsyncChangesTreeModel asyncChangesTreeModel = SimpleAsyncChangesTreeModel.create(grouping -> {
                List<FilePath> files2 = SpecificFilesViewDialog.this.getFiles();
                return TreeModelBuilder.buildFromFilePaths(this.myProject, grouping, files2);
            });
            if (asyncChangesTreeModel == null) {
                MyChangesTree.$$$reportNull$$$0(3);
            }
            return asyncChangesTreeModel;
        }

        @Override
        public void resetTreeState() {
            ChangesBrowserNode<?> root = this.getRoot();
            if (root.getChildCount() == 1) {
                TreeNode child = root.getChildAt(0);
                this.expandPath(TreeUtil.getPathFromRoot((TreeNode)child));
            }
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyChangesTree.$$$reportNull$$$0(4);
            }
            super.uiDataSnapshot(sink);
            VcsTreeModelData.uiDataSnapshot(sink, this.myProject, (JTree)((Object)this));
            VcsTreeModelData treeSelection = VcsTreeModelData.selected((JTree)((Object)this));
            VcsTreeModelData exactSelection = VcsTreeModelData.exactlySelected((JTree)((Object)this));
            sink.lazy(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY, () -> VcsTreeModelData.mapToExactVirtualFile(exactSelection));
            sink.set(this.myShownDataKey, treeSelection.iterateUserObjects(FilePath.class));
            sink.set(VcsDataKeys.FILE_PATHS, treeSelection.iterateUserObjects(FilePath.class));
            sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new VirtualFileDeleteProvider());
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"ideaInterface.changes");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shownDataKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$MyChangesTree";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/SpecificFilesViewDialog$MyChangesTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "installPopupHandler";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)SpecificFilesViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)SpecificFilesViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !SpecificFilesViewDialog.this.myView.getGroupingSupport().isNone();
        }
    }
}

