/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsQuickListPopupAction
extends QuickSwitchSchemeAction
implements DumbAware {
    public VcsQuickListPopupAction() {
        this.myActionPlace = "ActionPlace.VcsQuickListPopupAction";
    }

    protected String getPopupTitle(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsQuickListPopupAction.$$$reportNull$$$0(0);
        }
        return VcsBundle.message((String)"vcs.quicklist.popup.title", (Object[])new Object[0]);
    }

    protected void fillActions(@Nullable Project project, @NotNull DefaultActionGroup group2, @NotNull DataContext dataContext) {
        if (group2 == null) {
            VcsQuickListPopupAction.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            VcsQuickListPopupAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            return;
        }
        CustomActionsSchema schema = CustomActionsSchema.getInstance();
        group2.add(schema.getCorrectedAction("Vcs.Operations.Popup"));
    }

    private static boolean isUnderVcs(@NotNull Project project) {
        if (project == null) {
            VcsQuickListPopupAction.$$$reportNull$$$0(3);
        }
        return ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
    }

    @Nullable
    private static AbstractVcs getContextVcs(@Nullable Project project, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsQuickListPopupAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            return null;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs[] activeVcss = vcsManager2.getAllActiveVcss();
        if (activeVcss.length == 0) {
            return null;
        }
        if (activeVcss.length == 1) {
            return activeVcss[0];
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderVcs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextVcs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NonVcsAware
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NonVcsAware.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            e.getPresentation().setVisible(project != null && !VcsQuickListPopupAction.isUnderVcs(project));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NonVcsAware.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction$NonVcsAware";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction$NonVcsAware";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class VcsAware
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            DataContext dataContext;
            Project project;
            AbstractVcs vcs;
            if (e == null) {
                VcsAware.$$$reportNull$$$0(0);
            }
            if ((vcs = VcsQuickListPopupAction.getContextVcs(project = e.getProject(), dataContext = e.getDataContext())) != null) {
                JBIterable providers = JBIterable.of((Object[])((VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()));
                List replacingActions = (List)providers.filterMap(p -> p.replaceVcsActionsFor(vcs, dataContext) ? p.getVcsActions(project, vcs, dataContext) : null).first();
                e.getPresentation().setVisible(replacingActions == null);
            } else {
                e.getPresentation().setVisible(false);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                VcsAware.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction$VcsAware";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction$VcsAware";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class VcsNameSeparator
    extends ActionGroup
    implements DumbAware {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (EMPTY_ARRAY == null) {
                    VcsNameSeparator.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            Project project = e.getProject();
            AbstractVcs vcs = VcsQuickListPopupAction.getContextVcs(project, e.getDataContext());
            if (vcs != null) {
                AnAction[] anActionArray = new AnAction[]{Separator.create((String)vcs.getDisplayName())};
                if (anActionArray == null) {
                    VcsNameSeparator.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }
            if (EMPTY_ARRAY == null) {
                VcsNameSeparator.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                VcsNameSeparator.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction$VcsNameSeparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Providers
    extends ActionGroup
    implements DumbAware {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List replacingActions;
            AbstractVcs vcs;
            if (e == null) {
                if (EMPTY_ARRAY == null) {
                    Providers.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            Project project = e.getProject();
            DataContext dataContext = e.getDataContext();
            if (project == null) {
                if (EMPTY_ARRAY == null) {
                    Providers.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            JBIterable providers = JBIterable.of((Object[])((VcsQuickListContentProvider[])VcsQuickListContentProvider.EP_NAME.getExtensions()));
            JBIterable actions = !VcsQuickListPopupAction.isUnderVcs(project) ? providers.flatMap(p -> p.getNotInVcsActions(project, dataContext)) : ((vcs = VcsQuickListPopupAction.getContextVcs(project, dataContext)) != null ? ((replacingActions = (List)providers.filterMap(p -> p.replaceVcsActionsFor(vcs, dataContext) ? p.getVcsActions(project, vcs, dataContext) : null).first()) != null ? JBIterable.from((Iterable)replacingActions) : providers.flatMap(p -> p.getVcsActions(project, vcs, dataContext))) : JBIterable.empty());
            AnAction[] anActionArray = actions.toList().toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                Providers.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                Providers.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/actions/VcsQuickListPopupAction$Providers";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

