/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.OptionsUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationOptions {
    public static final InstrumentationOptions DEFAULT = new Builder().build();
    public final boolean isBranchCoverage;
    public final boolean isMergeData;
    public final boolean isCalculateUnloaded;
    public final boolean isInstructionCoverage;
    public final boolean isCalculateHits;
    public final boolean isSaveSource;
    public final List<Pattern> includePatterns;
    public final List<Pattern> excludePatterns;
    public final List<Pattern> includeAnnotations;
    public final List<Pattern> excludeAnnotations;
    public final File dataFile;
    public final File sourceMapFile;
    public final TestTrackingMode testTrackingMode;

    /*
     * WARNING - void declaration
     */
    public InstrumentationOptions(boolean isBranchCoverage, boolean isMergeData, boolean isCalculateUnloaded, boolean isInstructionCoverage, boolean isCalculateHits, boolean isSaveSource, List<Pattern> includePatterns, List<Pattern> excludePatterns, List<Pattern> includeAnnotations, List<Pattern> excludeAnnotations, File dataFile, File sourceMapFile, TestTrackingMode testTrackingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.isBranchCoverage = var1_1;
        this.isMergeData = var2_2;
        this.isCalculateUnloaded = var3_3;
        this.isInstructionCoverage = isInstructionCoverage;
        this.isCalculateHits = isCalculateHits;
        this.isSaveSource = isSaveSource;
        this.includePatterns = includePatterns;
        this.excludePatterns = excludePatterns;
        this.includeAnnotations = includeAnnotations;
        this.excludeAnnotations = excludeAnnotations;
        this.dataFile = dataFile;
        this.sourceMapFile = sourceMapFile;
        this.testTrackingMode = testTrackingMode;
    }

    public boolean isTestTracking() {
        return this.testTrackingMode != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private boolean isBranchCoverage = true;
        private boolean isMergeData = false;
        private boolean isCalculateUnloaded = false;
        private boolean isInstructionCoverage = OptionsUtil.INSTRUCTIONS_COVERAGE_ENABLED;
        private boolean isCalculateHits = OptionsUtil.CALCULATE_HITS_COUNT;
        private boolean isSaveSource = false;
        private List<Pattern> includePatterns = Collections.emptyList();
        private List<Pattern> excludePatterns = Collections.emptyList();
        private List<Pattern> includeAnnotations = Collections.emptyList();
        private List<Pattern> excludeAnnotations = Collections.emptyList();
        private File dataFile = null;
        private File sourceMapFile = null;
        private TestTrackingMode testTrackingMode = null;

        /*
         * WARNING - void declaration
         */
        public Builder setBranchCoverage(boolean isBranchCoverage) {
            void var1_1;
            this.isBranchCoverage = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIsMergeData(boolean isMergeData) {
            void var1_1;
            this.isMergeData = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIsCalculateUnloaded(boolean isCalculateUnloaded) {
            void var1_1;
            this.isCalculateUnloaded = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstructionCoverage(boolean isInstructionCoverage) {
            void var1_1;
            this.isInstructionCoverage = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIsCalculateHits(boolean isCalculateHits) {
            void var1_1;
            this.isCalculateHits = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSaveSource(boolean isSaveSource) {
            void var1_1;
            this.isSaveSource = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIncludePatterns(List<Pattern> includePatterns) {
            void var1_1;
            this.includePatterns = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setExcludePatterns(List<Pattern> excludePatterns) {
            void var1_1;
            this.excludePatterns = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIncludeAnnotations(List<Pattern> includeAnnotations) {
            void var1_1;
            this.includeAnnotations = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setExcludeAnnotations(List<Pattern> excludeAnnotations) {
            void var1_1;
            this.excludeAnnotations = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDataFile(File dataFile) {
            void var1_1;
            this.dataFile = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSourceMapFile(File sourceMapFile) {
            void var1_1;
            this.sourceMapFile = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTestTrackingMode(TestTrackingMode testTrackingMode) {
            void var1_1;
            this.testTrackingMode = var1_1;
            return this;
        }

        public InstrumentationOptions build() {
            return new InstrumentationOptions(this.isBranchCoverage, this.isMergeData, this.isCalculateUnloaded, this.isInstructionCoverage, this.isCalculateHits, this.isSaveSource || this.sourceMapFile != null, this.includePatterns, this.excludePatterns, this.includeAnnotations, this.excludeAnnotations, this.dataFile, this.sourceMapFile, this.testTrackingMode);
        }
    }
}

