/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.tools;

import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.actions.validate.ValidateXmlHandler;
import org.jetbrains.annotations.NotNull;

final class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlHandler getHandler(@NotNull PsiFile file) {
        if (file == null) {
            ValidateXmlAction.$$$reportNull$$$0(0);
        }
        for (ValidateXmlHandler handler : ValidateXmlHandler.EP_NAME.getExtensionList()) {
            if (!handler.isAvailable((XmlFile)file)) continue;
            return handler;
        }
        ValidateXmlActionHandler handler = new ValidateXmlActionHandler(true);
        handler.setErrorReporter((ErrorReporter)new StdErrorReporter(handler, file, () -> this.doRunAction(file)));
        return handler;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            ValidateXmlAction.$$$reportNull$$$0(1);
        }
        if ((psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null && psiFile.getVirtualFile() != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ValidateXmlAction.$$$reportNull$$$0(2);
        }
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), () -> {
            Runnable action = () -> {
                try {
                    psiFile.putUserData(runningValidationKey, (Object)"");
                    PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                    this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                }
                finally {
                    psiFile.putUserData(runningValidationKey, null);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, this.getCommandName(), null);
    }

    @NlsContexts.Command
    private String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ValidateXmlAction.$$$reportNull$$$0(3);
        }
        Presentation presentation = event.getPresentation();
        PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_FILE);
        boolean visible = psiElement instanceof XmlFile;
        presentation.setVisible(visible);
        boolean enabled = psiElement instanceof XmlFile;
        if (enabled) {
            PsiFile containingFile = psiElement.getContainingFile();
            enabled = containingFile != null && containingFile.getVirtualFile() != null && (containingFile.getFileType() == XmlFileType.INSTANCE || containingFile.getFileType() == XHtmlFileType.INSTANCE) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ValidateXmlAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/tools/ValidateXmlAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/tools/ValidateXmlAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRunAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

