/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

final class NodeStack {
    private DependencyNode[] nodes = new DependencyNode[96];
    private int size;

    NodeStack() {
    }

    public DependencyNode top() {
        if (this.size <= 0) {
            throw new IllegalStateException("stack empty");
        }
        return this.nodes[this.size - 1];
    }

    public void push(DependencyNode node) {
        if (this.size >= this.nodes.length) {
            DependencyNode[] tmp = new DependencyNode[this.size + 64];
            System.arraycopy(this.nodes, 0, tmp, 0, this.nodes.length);
            this.nodes = tmp;
        }
        this.nodes[this.size++] = node;
    }

    public void pop() {
        if (this.size <= 0) {
            throw new IllegalStateException("stack empty");
        }
        --this.size;
    }

    public int find(Artifact artifact) {
        DependencyNode node;
        Artifact a2;
        for (int i2 = this.size - 1; i2 >= 0 && (a2 = (node = this.nodes[i2]).getArtifact()) != null; --i2) {
            if (!a2.getArtifactId().equals(artifact.getArtifactId()) || !a2.getGroupId().equals(artifact.getGroupId()) || !a2.getExtension().equals(artifact.getExtension()) || !a2.getClassifier().equals(artifact.getClassifier())) continue;
            return i2;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public DependencyNode get(int index) {
        return this.nodes[index];
    }

    public String toString() {
        return Arrays.toString(this.nodes);
    }
}

