/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.evt.BaseEventImpl;

public class CharactersEventImpl
extends BaseEventImpl
implements Characters {
    final String mContent;
    final boolean mIsCData;
    final boolean mIgnorableWS;
    boolean mWhitespaceChecked = false;
    boolean mIsWhitespace = false;

    public CharactersEventImpl(Location loc, String content, boolean cdata) {
        super(loc);
        this.mContent = content;
        this.mIsCData = cdata;
        this.mIgnorableWS = false;
    }

    private CharactersEventImpl(Location loc, String content, boolean cdata, boolean allWS, boolean ignorableWS) {
        super(loc);
        this.mContent = content;
        this.mIsCData = cdata;
        this.mIsWhitespace = allWS;
        if (allWS) {
            this.mWhitespaceChecked = true;
            this.mIgnorableWS = ignorableWS;
        } else {
            this.mWhitespaceChecked = false;
            this.mIgnorableWS = false;
        }
    }

    public static final CharactersEventImpl createIgnorableWS(Location loc, String content) {
        return new CharactersEventImpl(loc, content, false, true, true);
    }

    public static final CharactersEventImpl createNonIgnorableWS(Location loc, String content) {
        return new CharactersEventImpl(loc, content, false, true, false);
    }

    @Override
    public Characters asCharacters() {
        return this;
    }

    @Override
    public int getEventType() {
        return this.mIsCData ? 12 : 4;
    }

    @Override
    public boolean isCharacters() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w2) throws XMLStreamException {
        try {
            if (this.mIsCData) {
                w2.write("<![CDATA[");
                w2.write(this.mContent);
                w2.write("]]>");
            } else {
                CharactersEventImpl.writeEscapedXMLText(w2, this.mContent);
            }
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 w2) throws XMLStreamException {
        if (this.mIsCData) {
            w2.writeCData(this.mContent);
        } else {
            w2.writeCharacters(this.mContent);
        }
    }

    @Override
    public String getData() {
        return this.mContent;
    }

    @Override
    public boolean isCData() {
        return this.mIsCData;
    }

    @Override
    public boolean isIgnorableWhiteSpace() {
        return this.mIgnorableWS;
    }

    @Override
    public boolean isWhiteSpace() {
        if (!this.mWhitespaceChecked) {
            int i2;
            this.mWhitespaceChecked = true;
            String str = this.mContent;
            int len = str.length();
            for (i2 = 0; i2 < len && str.charAt(i2) <= ' '; ++i2) {
            }
            this.mIsWhitespace = i2 == len;
        }
        return this.mIsWhitespace;
    }

    public void setWhitespaceStatus(boolean status) {
        this.mWhitespaceChecked = true;
        this.mIsWhitespace = status;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof Characters)) {
            return false;
        }
        Characters other = (Characters)o2;
        if (this.mContent.equals(other.getData())) {
            return this.isCData() == other.isCData();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mContent.hashCode();
    }

    protected static void writeEscapedXMLText(Writer w2, String text) throws IOException {
        int len = text.length();
        for (int i2 = 0; i2 < len; ++i2) {
            int start = i2;
            char c2 = '\u0000';
            while (i2 < len && (c2 = text.charAt(i2)) != '<' && c2 != '&' && (c2 != '>' || i2 < 2 || text.charAt(i2 - 1) != ']' || text.charAt(i2 - 2) != ']')) {
                ++i2;
            }
            int outLen = i2 - start;
            if (outLen > 0) {
                w2.write(text, start, outLen);
            }
            if (i2 >= len) continue;
            if (c2 == '<') {
                w2.write("&lt;");
                continue;
            }
            if (c2 == '&') {
                w2.write("&amp;");
                continue;
            }
            if (c2 != '>') continue;
            w2.write("&gt;");
        }
    }
}

