/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.ProfileActivationFilePathInterpolator;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.util.StringUtils;

@Named(value="file")
@Singleton
public class FileProfileActivator
implements ProfileActivator {
    @Inject
    private ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;

    public FileProfileActivator setProfileActivationFilePathInterpolator(ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator) {
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
        return this;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file2 = activation.getFile();
        if (file2 == null) {
            return false;
        }
        if (StringUtils.isNotEmpty(file2.getExists())) {
            path = file2.getExists();
            missing = false;
        } else if (StringUtils.isNotEmpty(file2.getMissing())) {
            path = file2.getMissing();
            missing = true;
        } else {
            return false;
        }
        try {
            path = this.profileActivationFilePathInterpolator.interpolate(path, context);
        }
        catch (InterpolationException e2) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate file location " + path + " for profile " + profile.getId() + ": " + e2.getMessage()).setLocation(file2.getLocation(missing ? "missing" : "exists")).setException(e2));
            return false;
        }
        if (path == null) {
            return false;
        }
        File f2 = new File(path);
        if (!f2.isAbsolute()) {
            return false;
        }
        boolean fileExists = f2.exists();
        return missing ? !fileExists : fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file2 = activation.getFile();
        return file2 != null;
    }
}

