/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.util.io.pagecache.impl.PageImpl;
import com.intellij.util.io.pagecache.impl.PageToStorageHandle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public final class RWLockProtectedPageImpl
extends PageImpl {
    private static final long EMPTY_MODIFIED_REGION = 0L;
    private final transient ReentrantReadWriteLock contentProtectingLock;
    private volatile long modifiedRegionPacked;

    public RWLockProtectedPageImpl(int pageIndex, int pageSize, @NotNull PageToStorageHandle pageToStorageHandle, ReentrantReadWriteLock lock) {
        if (pageToStorageHandle == null) {
            RWLockProtectedPageImpl.$$$reportNull$$$0(0);
        }
        super(pageIndex, pageSize, pageToStorageHandle);
        this.modifiedRegionPacked = 0L;
        this.contentProtectingLock = lock;
    }

    public static RWLockProtectedPageImpl createBlankWithOwnLock(int index, int pageSize, @NotNull PageToStorageHandle pageToStorageHandle) {
        RWLockProtectedPageImpl page;
        if (pageToStorageHandle == null) {
            RWLockProtectedPageImpl.$$$reportNull$$$0(1);
        }
        if (!(page = new RWLockProtectedPageImpl(index, pageSize, pageToStorageHandle, new ReentrantReadWriteLock())).isNotReadyYet()) {
            throw new AssertionError((Object)("Bug: page just created must be NOT_READY_YET, but " + page));
        }
        return page;
    }

    public static RWLockProtectedPageImpl createBlankWithExplicitLock(int index, int pageSize, @NotNull PageToStorageHandle pageToStorageHandle, ReentrantReadWriteLock contentProtectingLock) {
        RWLockProtectedPageImpl page;
        if (pageToStorageHandle == null) {
            RWLockProtectedPageImpl.$$$reportNull$$$0(2);
        }
        if (!(page = new RWLockProtectedPageImpl(index, pageSize, pageToStorageHandle, contentProtectingLock)).isNotReadyYet()) {
            throw new AssertionError((Object)("Bug: page just created must be NOT_READY_YET, but " + page));
        }
        return page;
    }

    @Override
    public void lockPageForWrite() {
        this.contentProtectingLock.writeLock().lock();
    }

    @Override
    public void unlockPageForWrite() {
        this.contentProtectingLock.writeLock().unlock();
    }

    @Override
    public void lockPageForRead() {
        this.contentProtectingLock.readLock().lock();
    }

    @Override
    public void unlockPageForRead() {
        this.contentProtectingLock.readLock().unlock();
    }

    @Override
    public boolean isDirty() {
        return this.modifiedRegionPacked != 0L;
    }

    @Override
    public void flush() throws IOException {
        this.flushWithReadLock();
    }

    @Override
    public boolean tryFlush() throws IOException {
        if (!this.isDirty()) {
            return true;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.contentProtectingLock.readLock();
        if (!readLock.tryLock()) {
            return false;
        }
        try {
            this.flushImpl();
            boolean bl2 = true;
            return bl2;
        }
        finally {
            readLock.unlock();
        }
    }

    private void flushWithReadLock() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        if (this.state() > 3) {
            this.flushImpl();
        } else {
            this.lockPageForRead();
            try {
                this.flushImpl();
            }
            finally {
                this.unlockPageForRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushImpl() throws IOException {
        RWLockProtectedPageImpl rWLockProtectedPageImpl = this;
        synchronized (rWLockProtectedPageImpl) {
            long modifiedRegion = this.modifiedRegionPacked;
            if (modifiedRegion == 0L) {
                return;
            }
            int minOffsetModified = RWLockProtectedPageImpl.unpackMinOffsetModified(modifiedRegion);
            int maxOffsetModifiedExclusive = RWLockProtectedPageImpl.unpackMaxOffsetModifiedExclusive(modifiedRegion);
            ByteBuffer sliceToSave = this.data.duplicate().order(this.data.order());
            sliceToSave.position(minOffsetModified).limit(maxOffsetModifiedExclusive);
            this.storageHandle.flushBytes(sliceToSave, this.offsetInFile() + (long)minOffsetModified);
            this.storageHandle.pageBecomeClean();
            this.modifiedRegionPacked = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regionModified(int startOffsetModified, int length) {
        long modifiedRegionNew;
        long modifiedRegionOld;
        assert (this.contentProtectingLock.writeLock().isHeldByCurrentThread()) : "writeLock must be held while calling this method";
        RWLockProtectedPageImpl rWLockProtectedPageImpl = this;
        synchronized (rWLockProtectedPageImpl) {
            modifiedRegionOld = this.modifiedRegionPacked;
            int minOffsetModifiedOld = RWLockProtectedPageImpl.unpackMinOffsetModified(modifiedRegionOld);
            int maxOffsetModifiedOld = RWLockProtectedPageImpl.unpackMaxOffsetModifiedExclusive(modifiedRegionOld);
            int minOffsetModifiedNew = Math.min(minOffsetModifiedOld, startOffsetModified);
            int endOffset = startOffsetModified + length;
            int maxOffsetModifiedNew = Math.max(maxOffsetModifiedOld, endOffset);
            if (minOffsetModifiedOld == minOffsetModifiedNew && maxOffsetModifiedOld == maxOffsetModifiedNew) {
                return;
            }
            this.modifiedRegionPacked = modifiedRegionNew = (long)minOffsetModifiedNew | (long)maxOffsetModifiedNew << 32;
        }
        this.storageHandle.modifiedRegionUpdated(this.offsetInFile() + (long)startOffsetModified, length);
        if (modifiedRegionOld == 0L && modifiedRegionNew != 0L) {
            this.storageHandle.pageBecomeDirty();
        }
    }

    private static int unpackMinOffsetModified(long modifiedRegionPacked) {
        return (int)modifiedRegionPacked;
    }

    private static int unpackMaxOffsetModifiedExclusive(long modifiedRegionPacked) {
        return (int)(modifiedRegionPacked >> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OUT, E extends Exception> OUT read(int startOffsetOnPage, int length, ThrowableNotNullFunction<ByteBuffer, OUT, E> reader) throws E {
        this.contentProtectingLock.readLock().lock();
        try {
            this.checkPageIsValidForAccess();
            ByteBuffer slice = this.data.duplicate().order(this.data.order()).asReadOnlyBuffer();
            slice.position(startOffsetOnPage).limit(startOffsetOnPage + length);
            OUT OUT = reader.fun(slice);
            return OUT;
        }
        finally {
            this.contentProtectingLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OUT, E extends Exception> OUT write(int startOffsetOnPage, int length, ThrowableNotNullFunction<ByteBuffer, OUT, E> writer) throws E {
        this.contentProtectingLock.writeLock().lock();
        try {
            OUT OUT;
            this.checkPageIsValidForAccess();
            ByteBuffer slice = this.data.duplicate().order(this.data.order());
            slice.position(startOffsetOnPage).limit(startOffsetOnPage + length);
            try {
                OUT = writer.fun(slice);
                this.regionModified(startOffsetOnPage, length);
            }
            catch (Throwable throwable) {
                this.regionModified(startOffsetOnPage, length);
                this.checkPageIsValidForAccess();
                throw throwable;
            }
            this.checkPageIsValidForAccess();
            return OUT;
        }
        finally {
            this.contentProtectingLock.writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        long modifiedRegion = this.modifiedRegionPacked;
        int minOffset = RWLockProtectedPageImpl.unpackMinOffsetModified(modifiedRegion);
        int maxOffsetExclusive = RWLockProtectedPageImpl.unpackMaxOffsetModifiedExclusive(modifiedRegion);
        return super.toString() + ", dirtyRegion: [" + minOffset + ".." + maxOffsetExclusive + ") ";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "pageToStorageHandle";
        objectArray2[1] = "com/intellij/util/io/pagecache/impl/RWLockProtectedPageImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlankWithOwnLock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlankWithExplicitLock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

