/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class ReplicatorInputStream
extends InputStream {
    private final BufferExposingByteArrayOutputStream myTarget;
    private final InputStream mySource;
    private int markedSize;

    public ReplicatorInputStream(@NotNull InputStream source, @NotNull BufferExposingByteArrayOutputStream target) {
        if (source == null) {
            ReplicatorInputStream.$$$reportNull$$$0(0);
        }
        if (target == null) {
            ReplicatorInputStream.$$$reportNull$$$0(1);
        }
        this.mySource = source;
        this.myTarget = target;
    }

    @Override
    public int read() throws IOException {
        int b2 = this.mySource.read();
        if (b2 == -1) {
            return -1;
        }
        this.myTarget.write(b2);
        return b2;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mySource.mark(readlimit);
        this.markedSize = this.myTarget.size();
    }

    @Override
    public boolean markSupported() {
        return this.mySource.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mySource.reset();
        this.myTarget.backOff(this.myTarget.size() - this.markedSize);
        this.markedSize = 0;
    }

    @Override
    public int read(byte @NotNull [] b2) throws IOException {
        if (b2 == null) {
            ReplicatorInputStream.$$$reportNull$$$0(2);
        }
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte @NotNull [] b2, int off, int len) throws IOException {
        int count2;
        if (b2 == null) {
            ReplicatorInputStream.$$$reportNull$$$0(3);
        }
        if ((count2 = this.mySource.read(b2, off, len)) < 0) {
            return count2;
        }
        this.myTarget.write(b2, off, count2);
        return count2;
    }

    @Override
    public long skip(long n2) throws IOException {
        int skipped = this.read(new byte[(int)n2]);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.mySource.available();
    }

    @Override
    public void close() throws IOException {
        this.mySource.close();
        this.myTarget.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ReplicatorInputStream";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

