/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderedSet<T>
extends ArrayList<T>
implements Set<T>,
RandomAccess {
    private final ObjectOpenCustomHashSet<T> hashSet;

    public OrderedSet() {
        this.hashSet = new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCanonicalStrategy());
    }

    public OrderedSet(@NotNull Collection<? extends T> set) {
        if (set == null) {
            OrderedSet.$$$reportNull$$$0(0);
        }
        super(set);
        this.hashSet = new ObjectOpenCustomHashSet<T>(set, FastUtilHashingStrategies.getCanonicalStrategy());
    }

    public OrderedSet(@NotNull HashingStrategy<? super T> hashingStrategy) {
        if (hashingStrategy == null) {
            OrderedSet.$$$reportNull$$$0(1);
        }
        this.hashSet = new ObjectOpenCustomHashSet<T>(FastUtilHashingStrategies.adaptAsNotNull(hashingStrategy));
    }

    public OrderedSet(int capacity) {
        super(capacity);
        this.hashSet = new ObjectOpenCustomHashSet(capacity, FastUtilHashingStrategies.getCanonicalStrategy());
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            OrderedSet.$$$reportNull$$$0(2);
        }
        boolean removed = false;
        for (Object o2 : c2) {
            removed |= this.remove(o2);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            OrderedSet.$$$reportNull$$$0(3);
        }
        boolean removed = false;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Object o2 = this.get(i2);
            if (c2.contains(o2)) continue;
            removed |= this.remove(o2);
        }
        return removed;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean contains(Object o2) {
        return this.hashSet.contains(o2);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c2) {
        if (c2 == null) {
            OrderedSet.$$$reportNull$$$0(4);
        }
        boolean result2 = false;
        for (T t2 : c2) {
            result2 |= this.add(t2);
        }
        return result2;
    }

    @Override
    public boolean add(T o2) {
        if (this.hashSet.add(o2)) {
            super.add(o2);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o2) {
        if (this.hashSet.remove(o2)) {
            super.remove(o2);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.hashSet.clear();
        super.clear();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c2) {
        if (c2 == null) {
            OrderedSet.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, @NotNull T element) {
        if (element == null) {
            OrderedSet.$$$reportNull$$$0(6);
        }
        T removed = this.remove(index);
        this.add(index, element);
        return removed;
    }

    @Override
    public void add(int index, @NotNull T element) {
        if (element == null) {
            OrderedSet.$$$reportNull$$$0(7);
        }
        if (this.hashSet.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        Object t2 = super.remove(index);
        this.hashSet.remove(t2);
        return (T)t2;
    }

    @Override
    public int indexOf(Object o2) {
        T existing = this.hashSet.get(o2);
        return existing == null ? -1 : super.indexOf(existing);
    }

    @Override
    public int lastIndexOf(Object o2) {
        T existing = this.hashSet.get(o2);
        return existing == null ? -1 : super.lastIndexOf(existing);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/OrderedSet";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAll";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "retainAll";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAll";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

