/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadonlyStatusHandlerBase
extends ReadonlyStatusHandler {
    private static final Logger LOG = Logger.getInstance(ReadonlyStatusHandlerBase.class);
    private final Project myProject;

    public ReadonlyStatusHandlerBase(Project project) {
        this.myProject = project;
    }

    private static void checkThreading() {
        ThreadingAssertions.assertEventDispatchThread();
        Application app = ApplicationManager.getApplication();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is("tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    protected static ReadonlyStatusHandler.OperationStatus createResultStatus(@NotNull Collection<? extends VirtualFile> originalFiles, @NotNull Collection<? extends VirtualFile> files2) {
        if (originalFiles == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (!virtualFile.exists() || virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        assert (!readOnlyFiles.isEmpty() || ContainerUtil.and(originalFiles, file2 -> file2 == null || file2.isWritable())) : "Original files: " + originalFiles + ", files: " + files2;
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles) {
        OperationStatusImpl status;
        if (originalFiles == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(2);
        }
        if (originalFiles.isEmpty()) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ReadonlyStatusHandlerBase.checkThreading();
        HashSet<void> realFiles = new HashSet<void>(originalFiles.size());
        for (VirtualFile virtualFile : originalFiles) {
            void var4_4;
            void var4_8;
            @Nullable VirtualFile virtualFile2 = ObjectUtils.doIfNotNull(virtualFile, VirtualFileUtil::originalFileOrSelf);
            if (virtualFile2 instanceof VirtualFileWindow) {
                @Nullable VirtualFile virtualFile3 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
            }
            if (var4_8 instanceof BackedVirtualFile) {
                @Nullable VirtualFile virtualFile4 = ((BackedVirtualFile)var4_8).getOriginFile();
            }
            if (var4_4 == null) continue;
            realFiles.add(var4_4);
        }
        AccessToken ignore = SlowOperations.knownIssue("EA-1051315, IJPL-149483");
        ArrayList arrayList = new ArrayList(realFiles);
        OperationStatusImpl operationStatusImpl = status = this.myProject.isDefault() ? null : (OperationStatusImpl)WritingAccessProvider.EP.computeSafeIfAny((AreaInstance)this.myProject, provider -> {
            Collection<VirtualFile> denied = ContainerUtil.filter(arrayList, virtualFile -> !provider.isPotentiallyWritable((VirtualFile)virtualFile));
            if (denied.isEmpty()) {
                denied = provider.requestWriting(arrayList);
            }
            return denied.isEmpty() ? null : new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(denied), provider.getReadOnlyMessage(), provider.getHyperlinkListener());
        });
        if (status != null) {
            OperationStatusImpl operationStatusImpl2 = status;
            OperationStatusImpl operationStatusImpl3 = operationStatusImpl2;
            if (operationStatusImpl3 == null) {
                ReadonlyStatusHandlerBase.$$$reportNull$$$0(3);
            }
            return operationStatusImpl3;
        }
        ReadonlyStatusHandler.OperationStatus operationStatus = this.ensureFilesWritable(originalFiles, arrayList);
        ReadonlyStatusHandler.OperationStatus operationStatus2 = operationStatus;
        if (operationStatus2 == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(4);
        }
        return operationStatus2;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    @NotNull
    protected ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles, Collection<? extends VirtualFile> files2) {
        if (originalFiles == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(5);
        }
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerBase.createResultStatus(originalFiles, files2);
        if (operationStatus == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(6);
        }
        return operationStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultStatus";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        @NotNull
        private final @NlsContexts.DialogMessage String myReadOnlyReason;
        @Nullable
        private final HyperlinkListener myHyperlinkListener;

        public OperationStatusImpl(VirtualFile @NotNull [] readonlyFiles) {
            if (readonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(0);
            }
            this(readonlyFiles, "");
        }

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NotNull @NlsContexts.DialogMessage String readOnlyReason) {
            if (readOnlyReason == null) {
                OperationStatusImpl.$$$reportNull$$$0(1);
            }
            this(readonlyFiles, readOnlyReason, null);
        }

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NotNull @NlsContexts.DialogMessage String readOnlyReason, @Nullable HyperlinkListener hyperlinkListener) {
            if (readOnlyReason == null) {
                OperationStatusImpl.$$$reportNull$$$0(2);
            }
            this.myReadonlyFiles = readonlyFiles;
            this.myReadOnlyReason = readOnlyReason;
            this.myHyperlinkListener = hyperlinkListener;
        }

        @Override
        public VirtualFile @NotNull [] getReadonlyFiles() {
            if (this.myReadonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(3);
            }
            return this.myReadonlyFiles;
        }

        @Override
        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @Override
        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                if (!Strings.isEmpty(this.myReadOnlyReason)) {
                    String string2 = this.myReadOnlyReason;
                    if (string2 == null) {
                        OperationStatusImpl.$$$reportNull$$$0(4);
                    }
                    return string2;
                }
                if (this.myReadonlyFiles.length > 1) {
                    StringBuilder buf = new StringBuilder();
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    String string3 = CoreBundle.message("failed.to.make.the.following.files.writable.error.message", buf.toString());
                    if (string3 == null) {
                        OperationStatusImpl.$$$reportNull$$$0(5);
                    }
                    return string3;
                }
                String string4 = CoreBundle.message("failed.to.make.file.writable.error.message", this.myReadonlyFiles[0].getPresentableUrl());
                if (string4 == null) {
                    OperationStatusImpl.$$$reportNull$$$0(6);
                }
                return string4;
            }
            throw new RuntimeException("No readonly files");
        }

        @Override
        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readonlyFiles";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyReason";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase$OperationStatusImpl";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase$OperationStatusImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFilesMessage";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

