/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.app;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.util.Version;
import com.thaiopensource.xml.dtd.app.SchemaWriter;
import com.thaiopensource.xml.dtd.app.UriEntityManager;
import com.thaiopensource.xml.dtd.app.XmlOutputStreamWriter;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.parse.DtdParserImpl;
import com.thaiopensource.xml.em.EntityManager;
import java.io.IOException;

public class Driver {
    private static final int FAILURE_EXIT_CODE = 1;
    private static final Localizer localizer = new Localizer(class$com$thaiopensource$xml$dtd$app$Driver == null ? (class$com$thaiopensource$xml$dtd$app$Driver = Driver.class$("com.thaiopensource.xml.dtd.app.Driver")) : class$com$thaiopensource$xml$dtd$app$Driver);
    static /* synthetic */ Class class$com$thaiopensource$xml$dtd$app$Driver;

    public static void main(String[] stringArray) {
        try {
            if (Driver.doMain(stringArray)) {
                return;
            }
        }
        catch (IOException iOException) {
            Driver.error(iOException.getMessage());
        }
        System.exit(1);
    }

    public static boolean doMain(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            Driver.error(localizer.message("MISSING_ARGUMENT"));
            Driver.usage();
            return false;
        }
        if (stringArray.length > 1) {
            Driver.error(localizer.message("TOO_MANY_ARGUMENTS"));
            Driver.usage();
            return false;
        }
        String string2 = UriOrFile.toUri(stringArray[0]);
        Dtd dtd = new DtdParserImpl().parse(string2, (EntityManager)new UriEntityManager());
        XmlOutputStreamWriter xmlOutputStreamWriter = new XmlOutputStreamWriter(System.out, dtd.getEncoding());
        new SchemaWriter(xmlOutputStreamWriter).writeDtd(dtd);
        xmlOutputStreamWriter.close();
        return true;
    }

    private static void usage() {
        Driver.print(localizer.message("USAGE", Version.getVersion(class$com$thaiopensource$xml$dtd$app$Driver == null ? (class$com$thaiopensource$xml$dtd$app$Driver = Driver.class$("com.thaiopensource.xml.dtd.app.Driver")) : class$com$thaiopensource$xml$dtd$app$Driver)));
    }

    private static void error(String string2) {
        Driver.print(localizer.message("ERROR", string2));
    }

    private static void warning(String string2) {
        Driver.print(localizer.message("WARNING", string2));
    }

    private static void print(String string2) {
        System.err.println(string2);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

