/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsonSchemaMappingsProjectConfiguration", storages={@Storage(value="jsonSchemas.xml")})
public class JsonSchemaMappingsProjectConfiguration
implements PersistentStateComponent<MyState> {
    @NotNull
    private final Project myProject;
    public volatile MyState myState;

    @Nullable
    public UserDefinedJsonSchemaConfiguration findMappingBySchemaInfo(JsonSchemaInfo value) {
        for (UserDefinedJsonSchemaConfiguration configuration : this.myState.myState.values()) {
            if (!this.areSimilar(value, configuration)) continue;
            return configuration;
        }
        return null;
    }

    public boolean areSimilar(JsonSchemaInfo value, UserDefinedJsonSchemaConfiguration configuration) {
        return Objects.equals(this.normalizePath(value.getUrl(this.myProject)), this.normalizePath(configuration.getRelativePathToSchema()));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public String normalizePath(@Nullable String valueUrl) {
        if (valueUrl == null) {
            return null;
        }
        if (StringUtil.contains((CharSequence)valueUrl, (CharSequence)"..")) {
            valueUrl = new File(valueUrl).getAbsolutePath();
        }
        return valueUrl.replace('\\', '/');
    }

    @Nullable
    public UserDefinedJsonSchemaConfiguration findMappingForFile(VirtualFile file) {
        VirtualFile projectBaseDir = this.myProject.getBaseDir();
        for (UserDefinedJsonSchemaConfiguration configuration : this.myState.myState.values()) {
            for (UserDefinedJsonSchemaConfiguration.Item pattern2 : configuration.patterns) {
                VirtualFile relativeFile;
                if (pattern2.mappingKind != JsonMappingKind.File || !Objects.equals(relativeFile = VfsUtil.findRelativeFile((VirtualFile)projectBaseDir, (String[])pattern2.getPathParts()), file) && !file.getUrl().equals(UserDefinedJsonSchemaConfiguration.Item.neutralizePath(pattern2.getPath()))) continue;
                return configuration;
            }
        }
        return null;
    }

    public static JsonSchemaMappingsProjectConfiguration getInstance(@NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(0);
        }
        return (JsonSchemaMappingsProjectConfiguration)project2.getService(JsonSchemaMappingsProjectConfiguration.class);
    }

    public JsonSchemaMappingsProjectConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(1);
        }
        this.myState = new MyState();
        this.myProject = project2;
    }

    @Nullable
    public MyState getState() {
        return this.myState;
    }

    public void schemaFileMoved(@NotNull Project project2, @NotNull String oldRelativePath, @NotNull String newRelativePath) {
        if (project2 == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(2);
        }
        if (oldRelativePath == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(3);
        }
        if (newRelativePath == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(4);
        }
        Optional<UserDefinedJsonSchemaConfiguration> old = this.myState.myState.values().stream().filter(schema -> FileUtil.pathsEqual((String)schema.getRelativePathToSchema(), (String)oldRelativePath)).findFirst();
        old.ifPresent(configuration -> {
            configuration.setRelativePathToSchema(newRelativePath);
            JsonSchemaService.Impl.get(project2).reset();
        });
    }

    public void removeConfiguration(UserDefinedJsonSchemaConfiguration configuration) {
        for (Map.Entry<String, UserDefinedJsonSchemaConfiguration> entry2 : this.myState.myState.entrySet()) {
            if (entry2.getValue() != configuration) continue;
            this.myState.myState.remove(entry2.getKey());
            return;
        }
    }

    public void addConfiguration(UserDefinedJsonSchemaConfiguration configuration) {
        Object name = configuration.getName();
        while (this.myState.myState.containsKey(name)) {
            name = (String)name + "1";
        }
        this.myState.myState.put((String)name, configuration);
    }

    public Map<String, UserDefinedJsonSchemaConfiguration> getStateMap() {
        return Collections.unmodifiableMap(this.myState.myState);
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(5);
        }
        this.myState = state;
        JsonSchemaService.Impl.get(this.myProject).reset();
    }

    public void setState(@NotNull Map<String, UserDefinedJsonSchemaConfiguration> state) {
        if (state == null) {
            JsonSchemaMappingsProjectConfiguration.$$$reportNull$$$0(6);
        }
        this.myState = new MyState(state);
    }

    public boolean isIgnoredFile(VirtualFile virtualFile) {
        UserDefinedJsonSchemaConfiguration mappingForFile = this.findMappingForFile(virtualFile);
        return mappingForFile != null && mappingForFile.isIgnoredFile();
    }

    public void markAsIgnored(VirtualFile virtualFile) {
        UserDefinedJsonSchemaConfiguration existingMapping = this.findMappingForFile(virtualFile);
        if (existingMapping != null) {
            this.removeConfiguration(existingMapping);
        }
        this.addConfiguration(JsonSchemaMappingsProjectConfiguration.createIgnoreSchema(virtualFile.getUrl()));
    }

    public void unmarkAsIgnored(VirtualFile virtualFile) {
        if (this.isIgnoredFile(virtualFile)) {
            UserDefinedJsonSchemaConfiguration existingMapping = this.findMappingForFile(virtualFile);
            this.removeConfiguration(existingMapping);
        }
    }

    private static UserDefinedJsonSchemaConfiguration createIgnoreSchema(String ignoredFileUrl) {
        UserDefinedJsonSchemaConfiguration schemaConfiguration = new UserDefinedJsonSchemaConfiguration(JsonBundle.message("schema.widget.no.schema.label", new Object[0]), JsonSchemaVersion.SCHEMA_4, "", true, Collections.singletonList(new UserDefinedJsonSchemaConfiguration.Item(ignoredFileUrl, false, false)));
        schemaConfiguration.setIgnoredFile(true);
        return schemaConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRelativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRelativePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "schemaFileMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyState {
        @Tag(value="state")
        @XCollection
        public Map<String, UserDefinedJsonSchemaConfiguration> myState = new TreeMap<String, UserDefinedJsonSchemaConfiguration>();

        MyState() {
        }

        MyState(Map<String, UserDefinedJsonSchemaConfiguration> state) {
            this.myState = state;
        }
    }
}

