/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.AstLoadingFilter;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlNSDescriptorSequence;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlNsDescriptorUtil {
    private static final Logger LOG = Logger.getInstance(XmlNsDescriptorUtil.class);
    private static final Key<Boolean> AUTO_GENERATED = Key.create((String)"auto-generated xml schema");

    public static boolean isAutoGeneratedSchema(XmlFile file) {
        return file.getUserData(AUTO_GENERATED) != null;
    }

    @Nullable
    public static XmlNSDescriptor getCachedHtmlNsDescriptor(@NotNull XmlFile descriptorFile) {
        if (descriptorFile == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(0);
        }
        return XmlNsDescriptorUtil.getCachedHtmlNsDescriptor(descriptorFile, "");
    }

    @Nullable
    public static XmlNSDescriptor getCachedHtmlNsDescriptor(@NotNull XmlFile descriptorFile, @NotNull String prefix) {
        if (descriptorFile == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(2);
        }
        Map descriptorsByPrefix = (Map)CachedValuesManager.getCachedValue((PsiElement)descriptorFile, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{descriptorFile}));
        return descriptorsByPrefix.computeIfAbsent(prefix, p -> {
            XmlDocument document2 = descriptorFile.getDocument();
            if (document2 == null) {
                return null;
            }
            return new HtmlNSDescriptorImpl((XmlNSDescriptor)document2.getMetaData());
        });
    }

    public static boolean isGeneratedFromDtd(@NotNull XmlDocument document2, XmlNSDescriptor defaultNSDescriptorInner) {
        if (document2 == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(3);
        }
        if (defaultNSDescriptorInner == null) {
            return false;
        }
        XmlFile descriptorFile = defaultNSDescriptorInner.getDescriptorFile();
        if (descriptorFile == null) {
            return false;
        }
        @NonNls String otherName = XmlUtil.getContainingFile(document2).getName() + ".dtd";
        return descriptorFile.getName().equals(otherName);
    }

    @Nullable
    public static XmlNSDescriptor getDefaultNSDescriptor(@NotNull XmlDocument document2, @Nullable String namespace, boolean strict) {
        XmlFile xmlFile;
        XmlNSDescriptor descr;
        XmlFile containingFile;
        if (document2 == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(4);
        }
        if ((containingFile = XmlUtil.getContainingFile(document2)) == null) {
            return null;
        }
        XmlProlog prolog = document2.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        boolean dtdUriFromDocTypeIsNamespace = false;
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            XmlFile descriptorFile;
            XmlNSDescriptor nsDescriptor;
            XmlNSDescriptor xmlNSDescriptor = nsDescriptor = doctype != null ? XmlNsDescriptorUtil.getNsDescriptorFormDocType(document2, doctype, containingFile, true) : null;
            if (doctype != null) {
                LOG.debug("Descriptor from doctype " + doctype + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
            }
            if (nsDescriptor == null) {
                String htmlns = ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(document2.getProject());
                if (htmlns.isEmpty()) {
                    htmlns = Html5SchemaProvider.getHtml5SchemaLocation();
                }
                nsDescriptor = XmlNsDescriptorUtil.getDefaultNSDescriptor(document2, htmlns, false);
            }
            if (nsDescriptor != null && (descriptorFile = nsDescriptor.getDescriptorFile()) != null) {
                return XmlNsDescriptorUtil.getCachedHtmlNsDescriptor(descriptorFile);
            }
            return new HtmlNSDescriptorImpl(nsDescriptor);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace)) {
            String xhtmlNamespace = XmlUtil.getDefaultXhtmlNamespace(document2.getProject());
            if (xhtmlNamespace == null || xhtmlNamespace.isEmpty()) {
                xhtmlNamespace = Html5SchemaProvider.getXhtml5SchemaLocation();
            }
            return XmlNsDescriptorUtil.getDefaultNSDescriptor(document2, xhtmlNamespace, false);
        }
        if (namespace != null && !namespace.equals("")) {
            if (doctype == null || !namespace.equals(XmlUtil.getDtdUri(doctype))) {
                XmlDocument nsDocument;
                XmlFile xmlFile2;
                boolean documentIsSchemaThatDefinesNs = namespace.equals(XmlUtil.getTargetSchemaNsFromTag(document2.getRootTag()));
                XmlFile xmlFile3 = xmlFile2 = documentIsSchemaThatDefinesNs ? containingFile : XmlUtil.findNamespace(containingFile, namespace);
                if (xmlFile2 != null && (nsDocument = (XmlDocument)AstLoadingFilter.forceAllowTreeLoading((PsiFile)xmlFile2, () -> xmlFile2.getDocument())) != null) {
                    return (XmlNSDescriptor)nsDocument.getMetaData();
                }
            } else {
                dtdUriFromDocTypeIsNamespace = true;
            }
        }
        if (strict && !dtdUriFromDocTypeIsNamespace) {
            return null;
        }
        if (doctype != null && (descr = XmlNsDescriptorUtil.getNsDescriptorFormDocType(document2, doctype, containingFile, false)) != null) {
            return XmlExtension.getExtension(containingFile).getDescriptorFromDoctype(containingFile, descr);
        }
        if (strict) {
            return null;
        }
        if ("".equals(namespace) && (xmlFile = XmlUtil.findNamespace(containingFile, namespace)) != null) {
            return (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
        }
        try {
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)document2.getProject()).createFileFromText(containingFile.getName() + ".dtd", (Language)DTDLanguage.INSTANCE, (CharSequence)XmlUtil.generateDocumentDTD(document2, false), false, false);
            if (fileFromText instanceof XmlFile) {
                fileFromText.putUserData(AUTO_GENERATED, (Object)Boolean.TRUE);
                return (XmlNSDescriptor)((XmlFile)fileFromText).getDocument().getMetaData();
            }
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static XmlNSDescriptor getNsDescriptorFormDocType(@NotNull XmlDocument document2, XmlDoctype doctype, XmlFile containingFile, boolean forHtml) {
        if (document2 == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(5);
        }
        XmlNSDescriptor descriptor = XmlNsDescriptorUtil.getNSDescriptorFromMetaData(document2, doctype.getMarkupDecl(), true);
        String filePath = XmlNsDescriptorUtil.getFilePathForLogging(containingFile);
        String dtdUri = XmlUtil.getDtdUri(doctype);
        LOG.debug("DTD url for doctype " + doctype.getText() + " in file " + filePath + " is " + dtdUri);
        if (dtdUri != null && !dtdUri.isEmpty()) {
            XmlFile xmlFile = XmlUtil.findNamespace(containingFile, dtdUri);
            if (xmlFile == null) {
                xmlFile = XmlNamespaceIndex.guessDtd(dtdUri, containingFile);
            }
            String schemaFilePath = XmlNsDescriptorUtil.getFilePathForLogging(xmlFile);
            LOG.debug("Schema file for " + filePath + " is " + schemaFilePath);
            XmlNSDescriptor descriptorFromDtd = XmlNsDescriptorUtil.getNSDescriptorFromMetaData(document2, xmlFile == null ? null : (PsiMetaOwner)AstLoadingFilter.forceAllowTreeLoading((PsiFile)xmlFile, xmlFile::getDocument), forHtml);
            LOG.debug("Descriptor from meta data for schema file " + schemaFilePath + " is " + (descriptorFromDtd != null ? descriptorFromDtd.getClass().getCanonicalName() : "NULL"));
            if (descriptor != null && descriptorFromDtd != null) {
                descriptor = new XmlNSDescriptorSequence(new XmlNSDescriptor[]{descriptor, descriptorFromDtd});
            } else if (descriptorFromDtd != null) {
                descriptor = descriptorFromDtd;
            }
        }
        return descriptor;
    }

    @Nullable
    private static XmlNSDescriptor getNSDescriptorFromMetaData(@NotNull XmlDocument document2, @Nullable PsiMetaOwner metaOwner, boolean nonEmpty) {
        if (document2 == null) {
            XmlNsDescriptorUtil.$$$reportNull$$$0(6);
        }
        if (metaOwner == null) {
            return null;
        }
        XmlNSDescriptor descriptor = (XmlNSDescriptor)metaOwner.getMetaData();
        if (descriptor == null) {
            return null;
        }
        if (nonEmpty && descriptor.getRootElementsDescriptors(document2).length == 0) {
            return null;
        }
        return descriptor;
    }

    @NotNull
    private static String getFilePathForLogging(@Nullable PsiFile file) {
        if (file == null) {
            return "NULL";
        }
        VirtualFile vFile = file.getVirtualFile();
        return vFile != null ? vFile.getPath() : "NULL_VFILE";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/impl/XmlNsDescriptorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedHtmlNsDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isGeneratedFromDtd";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultNSDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNsDescriptorFormDocType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNSDescriptorFromMetaData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

