/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.search;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.references.WebSymbolReference;
import com.intellij.webSymbols.search.PsiSourcedWebSymbolReference;
import com.intellij.webSymbols.search.PsiSourcedWebSymbolRequestResultProcessor$processTextOccurrence$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/webSymbols/search/PsiSourcedWebSymbolRequestResultProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "targetElement", "Lcom/intellij/psi/PsiElement;", "targetSymbols", "", "Lcom/intellij/webSymbols/WebSymbol;", "includeRegularReferences", "", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Z)V", "myPsiReferenceService", "Lcom/intellij/psi/PsiReferenceService;", "kotlin.jvm.PlatformType", "mySymbolReferenceService", "Lcom/intellij/model/psi/PsiSymbolReferenceService;", "Lorg/jetbrains/annotations/NotNull;", "processTextOccurrence", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.platform.webSymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPsiSourcedWebSymbolRequestResultProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiSourcedWebSymbolRequestResultProcessor.kt\ncom/intellij/webSymbols/search/PsiSourcedWebSymbolRequestResultProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n473#2:73\n1313#2:74\n1314#2:90\n800#3,11:75\n1747#3,3:87\n1#4:86\n*S KotlinDebug\n*F\n+ 1 PsiSourcedWebSymbolRequestResultProcessor.kt\ncom/intellij/webSymbols/search/PsiSourcedWebSymbolRequestResultProcessor\n*L\n34#1:73\n36#1:74\n36#1:90\n38#1:75,11\n45#1:87,3\n*E\n"})
public final class PsiSourcedWebSymbolRequestResultProcessor
extends RequestResultProcessor {
    @NotNull
    private final PsiElement targetElement;
    @NotNull
    private final List<WebSymbol> targetSymbols;
    private final boolean includeRegularReferences;
    @NotNull
    private final PsiSymbolReferenceService mySymbolReferenceService;
    private final PsiReferenceService myPsiReferenceService;

    public PsiSourcedWebSymbolRequestResultProcessor(@NotNull PsiElement targetElement, @NotNull List<? extends WebSymbol> targetSymbols, boolean includeRegularReferences) {
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        Intrinsics.checkNotNullParameter(targetSymbols, (String)"targetSymbols");
        super(new Object[0]);
        this.targetElement = targetElement;
        this.targetSymbols = targetSymbols;
        this.includeRegularReferences = includeRegularReferences;
        PsiSymbolReferenceService psiSymbolReferenceService = PsiSymbolReferenceService.getService();
        Intrinsics.checkNotNullExpressionValue((Object)psiSymbolReferenceService, (String)"getService(...)");
        this.mySymbolReferenceService = psiSymbolReferenceService;
        this.myPsiReferenceService = PsiReferenceService.getService();
    }

    /*
     * WARNING - void declaration
     */
    public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.targetElement.isValid()) {
            return false;
        }
        if (element instanceof PsiExternalReferenceHost) {
            void $this$forEach$iv;
            Sequence $this$filterIsInstance$iv;
            Collection collection = this.mySymbolReferenceService.getReferences(element, PsiSymbolReferenceHints.offsetHint((int)offsetInElement));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getReferences(...)");
            Sequence sequence = CollectionsKt.asSequence((Iterable)collection);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processTextOccurrence$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<WebSymbolReference, Boolean>(offsetInElement){
                final /* synthetic */ int $offsetInElement;
                {
                    this.$offsetInElement = $offsetInElement;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull WebSymbolReference it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getRangeInElement().containsOffset(this.$offsetInElement);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WebSymbol equivalentSymbol;
                WebSymbol webSymbol;
                void $this$filterIsInstanceTo$iv$iv;
                WebSymbolReference ref = (WebSymbolReference)element$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                Iterable $this$filterIsInstance$iv2 = ref.resolveReference();
                boolean $i$f$filterIsInstance2 = false;
                Iterable iterable = $this$filterIsInstance$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiSourcedWebSymbol)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List psiSourcedWebSymbols = (List)destination$iv$iv;
                if (psiSourcedWebSymbols.isEmpty()) continue;
                if (this.targetSymbols.isEmpty()) {
                    Iterator iterator;
                    block13: {
                        Intrinsics.checkNotNullExpressionValue((Object)PsiSymbolService.getInstance().asSymbol(this.targetElement), (String)"asSymbol(...)");
                        Iterable iterable2 = psiSourcedWebSymbols;
                        Iterator iterator2 = iterable2.iterator();
                        while (iterator2.hasNext()) {
                            Symbol targetPsiSymbol;
                            Iterator iterator3 = iterator2.next();
                            PsiSourcedWebSymbol it = (PsiSourcedWebSymbol)((Object)iterator3);
                            boolean bl2 = false;
                            if (!it.isEquivalentTo(targetPsiSymbol)) continue;
                            iterator = iterator3;
                            break block13;
                        }
                        iterator = null;
                    }
                    webSymbol = (WebSymbol)((Object)iterator);
                } else {
                    Object v5;
                    block15: {
                        iterable = this.targetSymbols;
                        for (Object e : iterable) {
                            boolean bl3;
                            block14: {
                                WebSymbol targetSymbol = (WebSymbol)e;
                                boolean bl4 = false;
                                Iterable $this$any$iv = psiSourcedWebSymbols;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        PsiSourcedWebSymbol it = (PsiSourcedWebSymbol)element$iv2;
                                        boolean bl5 = false;
                                        if (!it.isEquivalentTo(targetSymbol)) continue;
                                        bl3 = true;
                                        break block14;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) continue;
                            v5 = e;
                            break block15;
                        }
                        v5 = null;
                    }
                    webSymbol = v5;
                }
                if ((equivalentSymbol = webSymbol) == null) continue;
                PsiExternalReferenceHost psiExternalReferenceHost = (PsiExternalReferenceHost)element;
                TextRange textRange = ref.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
                if (consumer.process((Object)new PsiSourcedWebSymbolReference(equivalentSymbol, this.targetElement, psiExternalReferenceHost, textRange))) continue;
                return false;
            }
        }
        if (this.includeRegularReferences) {
            List list2 = this.myPsiReferenceService.getReferences(element, new PsiReferenceService.Hints(this.targetElement, Integer.valueOf(offsetInElement)));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getReferences(...)");
            List references = list2;
            int n = references.size();
            for (int i = 0; i < n; ++i) {
                PsiReference ref = (PsiReference)references.get(i);
                ProgressManager.checkCanceled();
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || !ref.isReferenceTo(this.targetElement) || consumer.process((Object)ref)) continue;
                return false;
            }
        }
        return true;
    }
}

